/* XMLAttribute.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素XMLAttribute类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml;

import com.ds.bpm.bpd.xml.panels.*;
import com.ds.enums.EnumsAttribute;
import org.w3c.dom.*;

/**
 * Represents any attribute in a sence of the XML. This class extends the {@link XMLChoice} class in order to be able to
 * select some predefined values for attribute if such exists, otherwise, it is intended to hold the attribute name and
 * it's user defined (or automaticaly) defined value.
 * <p>
 * Like any other class which base class is <code>
 * XMLElement</code> class, this class provides visual way to change the value that it is supposed to take care of.
 */
public class XMLAttribute extends XMLChoice {
    /**
     * The type of textual XMLPanel:0-XMLTextPanel, XMLLocationPanel otherwise.
     */
    private int XMLTextPanelType = 0;


    public EnumsAttribute enumsAttribute;


    /**
     * Language depended names of choices-read from property file.
     */
    private String[] choiceNames = null;

    /**
     * Indicates if attribut uses XMLComboPanel or XMLRadioPanel.
     */
    private boolean isComboPanel = true;

    /**
     * Indicates if element's label and edit box will be shown one above other, or one beside other.
     */
    private boolean isVertical = false;

    protected XMLPanel p;

    /**
     * Creates an instance of class that represents specified XML attribute, with default value for text panel type
     * (XMLTextPanel).
     *
     * @param name The XML attribute name.
     */
    public XMLAttribute(String name) {
        super(name, null);
    }

    public XMLAttribute(String name, String title) {
        super(name, null);
        this.setLabelName(title);
    }

    /**
     * Creates an instance of class that represents specified XML attribute, with specified value of text panel.
     *
     * @param name   The XML attribute name.
     * @param tpType The type of text panel, 1=XMLLocationPanel, 2=XMLTextPanel with password text field,
     *               3=XMLMultiLineTextPanel, 0 or anything else=ordinary XMLTextPanel
     */
    public XMLAttribute(String name, int tpType) {
        super(name, null);
        this.XMLTextPanelType = tpType;
    }

    /**
     * Creates an instance of class that represents specified XML attribute that has a given set of choices to choose
     * for attribute value, and with specified index of choice to be choosen after creation. The default setting's for
     * panel type is used-XMLComboPanel, and default layout for label and edit box will be used (one beside other). The
     * choices are used as a keys for search within a property file and the values read from property file are used when
     * showing choices within combo box or at radio button labels.
     *
     * @param name         The XML attribute name.
     * @param choices      The valid choices for this attribute value.
     * @param choosenIndex The index of value to be choosen after creation.
     */
    public XMLAttribute(String name, String[] choices, int choosenIndex) {
        this(name, choices, choosenIndex, true, false);
    }

    public XMLAttribute(EnumsAttribute attribute) {


        this(attribute.getName(), attribute.getAttributes(), attribute.getDefaultIndex());

        this.setLabelName(attribute.getDisplayName());
        this.enumsAttribute = attribute;
        // super(attribute);
        // this(name, choices, choosenIndex, true, false);
    }

    public XMLAttribute(String name, Object[] choices, int choosenIndex) {
        this(name, choices, choosenIndex, true, false);
    }

    public EnumsAttribute getEnumsAttribute() {
        return enumsAttribute;
    }

    public void setEnumsAttribute(EnumsAttribute enumsAttribute) {
        this.enumsAttribute = enumsAttribute;
    }

    /**
     * Creates an instance of class that represents specified XML attribute that has a given set of choices to choose
     * for attribute value, the specified index of choice to be choosen after creation, the specified setting for panel
     * type and specified layout for label and edit box. The choices are used as a keys for search within a property
     * file and the values read from property file are used when showing choices within combo box or at radio button
     * labels.
     *
     * @param name         The XML attribute name.
     * @param choices      The valid choices for this attribute value.
     * @param choosenIndex The index of value to be choosen after creation.
     * @param isComboPanel The type of panel:<tt>true</tt> if XMLComboPanel will be used, <tt>false</tt> if XMLRadioPanel will be
     *                     used.
     * @param isVertical   The type of layout:<tt>true</tt> if vertical layout will be used, <tt>false</tt> if horizontal layout
     *                     will be used.
     */
    public XMLAttribute(String name, String[] choices, int choosenIndex, boolean isComboPanel, boolean isVertical) {

        super(name, (Object[]) choices, choosenIndex);
        choosenIndex = (choosenIndex > choices.length - 1) ? choices.length - 1 : choosenIndex;
        this.choiceNames = new String[choices.length];
        String nm;
        for (int i = 0; i < choices.length; i++) {
            nm = XMLUtil.getLanguageDependentString(choices[i] + "Key");
            if (nm != null) {
                this.choiceNames[i] = nm;
            } else {
                this.choiceNames[i] = choices[i];
            }
        }
        nm = XMLUtil.getLanguageDependentString(choices[choosenIndex] + "Key");
        if (nm != null) {
            this.choosen = nm;
        } else {
            choosen = choices[choosenIndex];
        }
        this.isComboPanel = isComboPanel;
        this.isVertical = isVertical;
    }

    public XMLAttribute(String name, Object[] choices, int choosenIndex, boolean isComboPanel, boolean isVertical) {

        super(name, (Object[]) choices, choosenIndex);
        choosenIndex = (choosenIndex > choices.length - 1) ? choices.length - 1 : choosenIndex;
        this.choiceNames = new String[choices.length];
        this.choices = choices;
        String nm;
        for (int i = 0; i < choices.length; i++) {
            nm = XMLUtil.getLanguageDependentString(choices[i] + "Key");
            if (nm != null) {
                this.choiceNames[i] = nm;
            } else {
                this.choiceNames[i] = ((String[]) choices[i])[0];
            }
        }
        nm = XMLUtil.getLanguageDependentString(choices[choosenIndex] + "Key");
        if (nm != null) {
            this.choosen = nm;
        } else {
            choosen = choices[choosenIndex];
        }
        this.isComboPanel = isComboPanel;
        this.isVertical = isVertical;
    }

    /**
     * Overrides super-class method to return this class specific representation of choices.
     *
     * @return The language specific array of strings that correspodent to real allowed values for this attribute. If
     * this is not an attribute with restricted set values, <tt>null</tt> is returned.
     */
    public Object[] getChoices() {
        return choices;
    }

    /**
     * Gets the choosen value for attribute.
     *
     * @return The language specific presentation for one of allowed values that is choosen or <tt>null</tt> if this is
     * not an attribute with restricted set of values.
     */
    public Object getChoosen() {
        return choosen;
    }

    /**
     * Indicates if element is empty.
     *
     * @return <tt>true</tt> if user haven't defined the element value within dialog, <tt>false</tt> otherwise.
     */
    public boolean isEmpty() {
        if (choices == null) {
            return super.isEmpty();
        } else {
            if (choosen == null || ((choosen instanceof String) && ((String) choosen).length() == 0)) {
                return true;
            } else {
                return false;
            }
        }
    }

    /**
     * Overrides super-class method.
     *
     * @return The same as the super-class if this is not an attribute with restricted set of values, string
     * representation of choosen value otherwise.
     */
    public String toString() {
        if (choices == null) {
            return super.toString();
        } else {
            if (choosen != null) {
                if (choosen instanceof String[]) {
                    return ((String[]) choosen)[0];
                }
                return choosen.toString();
            } else {
                return super.toString();
            }
        }
    }

    /**
     * Overrides super-class method to return an attribute specific XML output.
     */
    public void toXML(Node parent) throws DOMException {
        if (parent != null) {
            Attr node = null;
            if (parent.getOwnerDocument() == null) {
                node = ((Document) parent).createAttribute(name);
            } else {

                node = (parent.getOwnerDocument()).createAttribute(name);

            }
            String nodeValue;
            if (value instanceof String[]) {
                nodeValue = ((String[]) value)[1];
                // nodeValue = value.toString();
                node.setValue(nodeValue.trim());
                ((Element) parent).setAttributeNode(node);
            } else {
                if (value != null) {
                    nodeValue = value.toString();
                    node.setValue(nodeValue.trim());
                    ((Element) parent).setAttributeNode(node);
                } else {
                    System.out.println(name);

                }

            }

        }

    }

    /**
     * Overrides super-class method to return an attribute specific XML input.
     */
    public void fromXML(Node node) {
        super.fromXML(node);
        if (choices != null) {
            for (int i = 0; i < choices.length; i++) {
                if (choices[i].equals(value)) {
                    choosen = choiceNames[i];
                    break;
                } else if (choices[i] instanceof String[] && ((String[]) choices[i])[1].equals(value)) {
                    choosen = choices[i];
                    break;
                }
            }
        }
    }

    /**
     * Returns the panel for editing an attribute element value.
     *
     * @return <ul>
     * <li>{@link XMLTextPanel} or {@link XMLLocationPanel} if attribute is not an attribute with restricted
     * values. Which of those two types of panel will be returned depends of how particular object of this class
     * is created.
     * <li>{@link XMLComboPanel} or {@link XMLRadioPanel} if attribute has a set of restricted values. Which of
     * those two types of panel will be returned depends of how particular object of this class is created.
     * </ul>
     */
    public XMLPanel getPanel() {
        if (choices == null) {
            if (XMLTextPanelType == 1) {
                p = new XMLLocationPanel(this);
            } else if (XMLTextPanelType == 2) {
                p = new XMLTextPanel(this, XMLPanel.BOX_LAYOUT, false, true);
            } else if (XMLTextPanelType == 3) {
                p = new XMLMultiLineTextPanel(this);
            } else {
                p = new XMLTextPanel(this, XMLPanel.BOX_LAYOUT, isVertical, false);
            }
        } else {
            if (isComboPanel) {
                p = new XMLComboPanel(this, XMLPanel.BOX_LAYOUT, isVertical);
                this.refreshDisplayValue();
                this.refreshPanelValue();
            } else {
                p = new XMLRadioPanel(this, toLabel(), XMLPanel.BOX_LAYOUT, isVertical);
            }
        }
        return p;
    }

    /**
     * If this is not an attribute with restricted set of values, the super-class method is called, and if it is not,
     * the value that is passed is the value of language specific choice, so this value is put into the
     * <code>choosen</code> member of this class, and the real value that corresponds to this language specific value is
     * put into <code>value</code>member. of this class.
     */
    public void setValue(Object v) {
        // 去掉填入字符串两边的空格
        if (v instanceof String) {
            v = ((String) v).trim();
        }
        if (choices == null) {
            super.setValue(v);
        } else {
            if (v != null) {
                // choosen = v.toString();
                choosen = v;
                boolean choiceFound = false;
                for (int i = 0; i < choiceNames.length; i++) {

                    if (choiceNames[i] != null && choiceNames[i].equals(choosen.toString())) {
                        value = choices[i];
                        choosen = choices[i];
                        choiceFound = true;
                        break;
                    }
                }
                if (!choiceFound) {
                    value = v;
                }
            } else {
                if (choices != null && choices.length > 0) {
                    value = choices[0];
                }
            }
        }
    }

    /**
     * Used to create exact copy of instance of this class. The newly created instance will have all the properties same
     * as the copied one.
     *
     * @return The newly created instance of this class.
     */
    public Object clone() {
        XMLAttribute d = (XMLAttribute) super.clone();
        d.XMLTextPanelType = this.XMLTextPanelType;
        d.choiceNames = this.choiceNames;
        d.isComboPanel = this.isComboPanel;
        d.setValue(toValue());
        d.refreshDisplayValue();
        return d;
    }

    public void refreshLabelName() {
        super.refreshLabelName();
        if (choices != null) {
            String nm, oldnm;
            for (int i = 0; i < choices.length; i++) {
                nm = XMLUtil.getLanguageDependentString(choices[i] + "Key");
                oldnm = choiceNames[i];
                if (nm != null) {
                    choiceNames[i] = nm;
                } else {
                    if (choices[i] instanceof String[]) {
                        String[] choice = (String[]) choices[i];
                        choiceNames[i] = choice[0];
                    } else {
                        choiceNames[i] = (String) choices[i];
                    }
                }
                if (choosen != null && choosen.toString().equals(oldnm)) {
                    choosen = choiceNames[i];
                }
            }
        }
    }

    /**
     * 得到属性Value
     */
    public Object toKey() {
        if (choosen == null) {
            return "";
        }
        if (choosen instanceof String[]) {
            return ((String[]) choosen)[0];
        } else {
            return value;
        }
    }

    /**
     * 得到属性Value
     */
    public Object toValue() {
        if (value == null) {
            return "";
        }
        if (value instanceof String[]) {
            return ((String[]) value)[1];
        } else {
            return value;
        }
    }

    // 刷新带下拉框的属性的显示值
    public void refreshDisplayValue() {
        if (choices != null) {
            for (int i = 0; i < choices.length; i++) {
                if (choices[i].equals(value) && value instanceof String) {
                    choosen = choiceNames[i];
                    break;
                } else if (choices[i] instanceof String[]
                        // && value instanceof String
                        && ((String[]) choices[i])[1].equalsIgnoreCase(toValue().toString())) {
                    choosen = choices[i];
                    break;
                }
            }
        }
    }

    public void setChoices(Object[] choices) {
        this.choices = choices;
    }

    public void refreshPanelValue() {
        if (p instanceof XMLTextPanel) {
            ((XMLTextPanel) p).setText(toValue().toString());
        }
        if (p instanceof XMLComboPanel) {
            if (choosen instanceof String[]) {
                String[] tmp = (String[]) choosen;
                ((XMLComboPanel) p).setItem(new XMLSelectOption(tmp[0], tmp[1]));
            } else {
                ((XMLComboPanel) p).setItem(choosen);
            }
        }
    }

    public XMLPanel getOldPanel() {
        return p;
    }
}
