package com.ds.bpm.bpd.xml;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 *
 * Redefine DefaultMutableTreeNode's toString() method to provide appropriate display
 * in jtree.
 * @author Zoran Milakovic zoran@prozone.co.yu
 * @version 1.0
 */

public class ToNameMutableTreeNode extends DefaultMutableTreeNode {

   public ToNameMutableTreeNode(Object userObject) {
      super(userObject);
   }

   public ToNameMutableTreeNode(Object userObject, boolean allowsChild) {
      super(userObject, allowsChild);
   }

   /**
    * Returns result of call toName() method of userObject, or null if there is no user object,
    * or user object is null.
    * @return result of call toName() or null if userObject is null;
    */
   public String toString() {
      if ( this.userObject == null )
         return null;
      String name = ((XMLElement)userObject).toName();
      String extension = userObject.toString();
      if( extension == null || extension.equals("") || extension.equalsIgnoreCase(name) )
         extension = "";
      else
         extension = "-"+extension;
      return name+extension;
   }
}
