/**
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：登陆远端服务器界面类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-1-13
 */
package com.ds.bpm.bpd.server.panels;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.MainLeftDownPanel;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.cluster.udp.UDPClient;
import com.ds.common.JDSException;
import com.ds.common.md5.MD5;
import com.ds.common.org.service.UserService;
import com.ds.common.swing.ProgressDialog;
import com.ds.common.swing.progress.Task;
import com.ds.common.swing.util.SwingWorker;
import com.ds.config.UserBean;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.context.MinServerActionContextImpl;

import com.ds.engine.ConnectInfo;
import com.ds.iot.json.UserInfo;
import com.ds.jds.core.User;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.comet.AbstractCometHandle;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;

public class LoginDialog extends JDialog {

    // 登录按钮
    private JButton buttonLogin;

    // 取消按钮
    private JButton buttonCancel;

    // 文本域大小
    private static Dimension textFieldDimension = new Dimension(150, 20);

    private JPanel contentPanel;

    // 远端服务器名称域
    private JTextField serverNameJTF;

    // 远端服务器端口域
    private JTextField serverPortJTF;

    // 用户登录名称域
    private JTextField userNameJTF;

    // 用户登录密码域
    private JTextField passwordNameJTF;

    private Task task;

    /**
     * 对话框构造器
     *
     * @param parentFrame 父窗口.
     * @param title       对话框标题.
     * @param isModal     是否是模式.
     */
    public LoginDialog(JFrame parentFrame, String title, boolean isModal) {
        super(parentFrame, title, isModal);
        initDialog();
    }

    /**
     * 初始化界面
     */
    private void initDialog() {
        try {
            // 添加JDialog面板内容
            Container cp = getContentPane();
            // 创建显示的内容面板
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, BoxLayout.Y_AXIS));
            contentPanel.setAlignmentX(JPanel.CENTER_ALIGNMENT);
            contentPanel.add(createContentPanel());
            contentPanel.add(createButtonGroupPanel());
            cp.add(contentPanel, BorderLayout.CENTER);
            // 添加窗口侦听器
            addWindowListener(wl);
            getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false), "Cancel");
            getRootPane().getActionMap().put("Cancel", new AbstractAction() {

                public void actionPerformed(ActionEvent e) {
                    dispose();
                }
            });
            setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
            setResizable(false);
            setLocationRelativeTo(getParent());
            buttonLogin.setDefaultCapable(true);
            getRootPane().setDefaultButton(buttonLogin);
            passwordNameJTF.setText(UserBean.getInstance().getUserpassword());

        } catch (Exception e) {
            System.out.println("初始化远程服务器工作流列表面板出错！");
        }
    }

    /**
     * 返回登陆远端服务器的显示内容面板
     *
     * @return contentPanel (the JPanel of content )
     */
    private JPanel createContentPanel() {
        // 创建显示的内容面板
        contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, BoxLayout.Y_AXIS));
        contentPanel.setAlignmentX(JPanel.CENTER_ALIGNMENT);
        String hostTitle = ResourceManager.getLanguageDependentString("RemoteLogin.HostTextField.Name.display");
        contentPanel.add(createTextPanel(hostTitle, false));
        String portTitle = ResourceManager.getLanguageDependentString("RemoteLogin.PortTextField.Name.display");
        contentPanel.add(createTextPanel(portTitle, false));
        String userTitle = ResourceManager.getLanguageDependentString("RemoteLogin.UserTextField.Name.display");
        contentPanel.add(createTextPanel(userTitle, false));
        String passwordTitle = ResourceManager.getLanguageDependentString("RemoteLogin.PasswordTextField.Name.display");
        contentPanel.add(createTextPanel(passwordTitle, true));
        serverNameJTF = ((JTextField) ((JPanel) contentPanel.getComponent(0)).getComponent(1));
        serverNameJTF.setText(BPDConfig.getInstance().getServerName());
        serverPortJTF = ((JTextField) ((JPanel) contentPanel.getComponent(1)).getComponent(1));
        serverPortJTF.setText(BPDConfig.getInstance().getServerPort());
        userNameJTF = ((JTextField) ((JPanel) contentPanel.getComponent(2)).getComponent(1));
        userNameJTF.setText(BPDConfig.getInstance().getUserName());
        passwordNameJTF = ((JTextField) ((JPanel) contentPanel.getComponent(3)).getComponent(1));
        // 返回内容面板
        return contentPanel;
    }

    /**
     * 创建文本域面板
     *
     * @param title           文本域名称
     * @param isPasswordField 文本域是否是密码
     * @return textPanel 返回文本域面板
     */
    private JPanel createTextPanel(String title, boolean isPasswordField) {
        // 创建文本域面板
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, BoxLayout.X_AXIS));
        textPanel.setAlignmentX(JPanel.RIGHT_ALIGNMENT);
        textPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        // 创建文本域标题
        JLabel jl = new JLabel(title);
        jl.setAlignmentX(Component.LEFT_ALIGNMENT);
        jl.setAlignmentY(Component.CENTER_ALIGNMENT);
        jl.setHorizontalAlignment(SwingConstants.RIGHT);
        textPanel.add(jl);
        // 创建文本域
        final JTextField jtf;
        if (!isPasswordField) {
            jtf = new JTextField();
        } else {
            jtf = new JPasswordField();
        }
        jtf.setAlignmentX(Component.LEFT_ALIGNMENT);
        jtf.setAlignmentY(Component.CENTER_ALIGNMENT);
        jtf.setMinimumSize(new Dimension(textFieldDimension));
        jtf.setMaximumSize(new Dimension(textFieldDimension));
        jtf.setPreferredSize(new Dimension(textFieldDimension));
        jtf.setFont(BPDConfig.getInstance().getFont());
        textPanel.add(jtf);
        // 返回文本域面板
        return textPanel;
    }

    /**
     * 创建按钮组面板
     *
     * @return buttonGroupPanel (the JPanel of buttongroup )
     */
    private JPanel createButtonGroupPanel() {
        JPanel buttonGroupPanel = new JPanel();
        buttonGroupPanel.setLayout(new BoxLayout(buttonGroupPanel, BoxLayout.X_AXIS));
        buttonGroupPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        // 创建确定按钮
        buttonLogin = new JButton(ResourceManager.getLanguageDependentString("RemoteLogin.LoginButton.Name.display"));
        buttonLogin.setFont(BPDConfig.getInstance().getFont());
        URL u = ResourceManager.getResource("LoginImage");
        if (u != null) {
            buttonLogin.setIcon(new ImageIcon(u));
        }
        // 为确定按钮添加侦听器
        buttonLogin.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent ae) {
                if (checkRequired()) { // 如果必填字段都已经填写
                    task = new LoginTask();
                    dispose();
                    SwingUtilities.invokeLater(new Runnable() {

                        public void run() {
                            String progressTitle = ResourceManager.getLanguageDependentString("RemoteLogin.Progress.Title.Name.display");
                            String progressDescription = ResourceManager.getLanguageDependentString("RemoteLogin.Progress.Description.Name.display");
                            String progressMessage = ResourceManager.getLanguageDependentString("RemoteLogin.Progress.Message.Name.display");
                            ProgressDialog progressDialog = new ProgressDialog((JFrame) getParent(), progressTitle, progressDescription, progressMessage, task, 0, false);
                            progressDialog.dispose();
                        }
                    });
                    task.go();
                }
            }
        });
        // 创建取消按钮
        buttonCancel = new JButton(ResourceManager.getLanguageDependentString("RemoteLogin.CancelButton.Name.display"));
        buttonCancel.setFont(BPDConfig.getInstance().getFont());
        u = ResourceManager.getResource("CancelImage");
        if (u != null) {
            buttonCancel.setIcon(new ImageIcon(u));
        }
        // 为取消按钮添加侦听器
        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                dispose();
            }
        });
        // 在按钮之间加空格
        buttonGroupPanel.add(Box.createHorizontalStrut(10));
        buttonGroupPanel.add(buttonLogin);
        // 在按钮之间加空格
        buttonGroupPanel.add(Box.createHorizontalStrut(10));
        buttonGroupPanel.add(buttonCancel);
        return buttonGroupPanel;
    }

    /**
     * 验证必须填写的字段
     *
     * @return boolean 必填字段是否都不为空
     */
    private boolean checkRequired() {
        boolean isAllValid = false;
        if (serverNameJTF.getText().equals("")) {
            // 如果服务器名称为空
            JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningServerNameIsNull"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
        } else if (serverPortJTF.getText().equals("")) {
            // 如果用户名称为空
            JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningServerPortIsNull"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
            // } else if (!Utils.isInt(serverPortJTF.getText())) {
            // 如果用户名称为空
            // JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor()
            // .getWindow(), ResourceManager
            // .getLanguageDependentString("WarningServerPortIsNumber"),
            // BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
        } else if (userNameJTF.getText().equals("")) {
            // 如果用户名称为空
            JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningUserNameIsNull"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
        } else if (passwordNameJTF.getText().equals("")) {
            // 如果用户密码为空
            JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningPasswordNameIsNull"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
        } else {
            isAllValid = true;
        }
        return isAllValid;
    }


    public void autoRun() {

        task = new LoginTask();
        dispose();
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                String progressTitle = ResourceManager.getLanguageDependentString("RemoteLogin.Progress.Title.Name.display");
                String progressDescription = ResourceManager.getLanguageDependentString("RemoteLogin.Progress.Description.Name.display");
                String progressMessage = ResourceManager.getLanguageDependentString("RemoteLogin.Progress.Message.Name.display");
                ProgressDialog progressDialog = new ProgressDialog((JFrame) getParent(), progressTitle, progressDescription, progressMessage, task, 0, false);
                progressDialog.dispose();
            }
        });
        task.go();
    }

    /**
     * 创建面板侦听器
     */
    private WindowListener wl = new WindowAdapter() {

        public void windowClosing(WindowEvent e) {
            dispose();
        }
    };

    class LoginTask extends Task {

        public LoginTask() {
            setLengthOfTask(10);
        }

        /*
         * @see com.ds.common.swing.progress.Task#go()
         */
        public void go() {
            final SwingWorker worker = new SwingWorker() {

                public Object construct() {
                    // 获得EngineWebService实例

                    try {
                        setMessage(ResourceManager.getLanguageDependentString("RemoteLogin.Progress.Message.Connecting.Name.display"));

                        // passwordParam = TripleDES.Encrypt(passwordParam);
                        // String password = StringUtility.bytesToBase64(passwordNameJTF.getText().getBytes());

                        String password = MD5.getHashString(passwordNameJTF.getText().trim());

                        // UserService userService = (UserService) EsbUtil.parExpression("$UserService");

                        User user = JDSServer.getClusterClient().getUDPClient().ajaxlogin();
//
//                        user.setAccount(userNameJTF.getText());
//                        user.setPassword(password);// MD5值

//                        user = userService.login(user).get();
//
                        UserInfo userinfo = new UserInfo();


                        userinfo.setAccount(user.getAccount());
                        userinfo.setId(user.getId());
                        userinfo.setSessionId(user.getSessionId());
                        userinfo.setSystemCode(user.getSystemCode());
                        userinfo.setUdpIP(user.getUdpIP());
                        userinfo.setUdpPort(user.getUdpPort());


                        if (userinfo != null) {

                            MinServerActionContextImpl context = (MinServerActionContextImpl) JDSActionContext.getActionContext();
                            context.setSessionId(userinfo.getSessionId());
                            context.getParamMap().put(JDSContext.SYSCODE, userinfo.getSystemCode());
                            context.getSession().put("JDSUSERID", userinfo.getId());
                            context.getParamMap().put("JDSUSERID", userinfo.getId());
                            AbstractCometHandle.sessionMapUser.put(userinfo.getSessionId(), userinfo.getId());
                            JDSActionContext.setContext(context);

                            JDSClientService clientService = EsbUtil.parExpression(JDSClientService.class);
                            if (clientService.getConnectInfo() == null) {
                                try {
                                    Person person = OrgManagerFactory.getOrgManager().getPersonByID(JDSServer.getInstance().getAdminUser().getId());
                                    ConnectInfo connectInfo = new ConnectInfo(person.getID(), person.getAccount(), person.getPassword());
                                    clientService.connect(connectInfo);
                                } catch (PersonNotFoundException e) {
                                    e.printStackTrace();
                                } catch (JDSException e) {
                                    e.printStackTrace();
                                }

                            }

                            BPD.getInstance().setUserInfo(userinfo);
                            // 修改配置文件中的服务器登陆信息
                            BPDConfig.getInstance().setServerName(serverNameJTF.getText());
                            BPDConfig.getInstance().setServerPort(serverPortJTF.getText());
                            BPDConfig.getInstance().setUserName(userNameJTF.getText());
                            BPDConfig.getInstance().saveConf();
                            // 设置用户登陆成功标志
                            BPD.getInstance().setLoginFlag(true);
                            // 指定所有打开流程的登录编辑用户
                            BPD.getInstance().setLoginedUserForOpenedProcesses();

                            BPD.getInstance().setRemoteProcessMap(BPD.getInstance().getRemoteProcessDefList(true));
                            // 刷新流程树列表
                            // BPD.getInstance().getPackageEditor()
                            // .getPackageTreePanel()
                            // .refreshPackageTreePanel();
                            MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel().refreshPackageTreePanel();

                            // 刷新界面
                            BPD.getInstance().getPackageEditor().valueChanged(null);
                            // 当登录成功后将树形选择为远程目录树
                            MainLeftDownPanel mainLeftDownPanel = BPD.getInstance().getMainLeftDownPanel();
                            mainLeftDownPanel.getMainLeftDownPanel().setSelectedComponent(mainLeftDownPanel.getRemotePackageTreePanel());

                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                        stop();
                        JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), e.getMessage(), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);

                    } finally {
                        stop();
                    }
                    return new Object();
                }
            };
            worker.start();
        }

        /*
         * @see com.ds.common.swing.progress.Task#cancel()
         */
        public void cancel() {
            BPD.getInstance().setLoginFlag(false);
            // 刷新界面
            BPD.getInstance().getPackageEditor().valueChanged(null);
        }

        /*
         * @see com.ds.common.swing.progress.Task#complete()
         */
        public void complete() {
        }
    }
}
