/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.process;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import com.ds.bpm.enums.form.FormNameEnum;
import com.ds.enums.attribute.Attributetype;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.Iterator;
import java.util.List;

public class Tables extends XMLCollection {

    public Tables(XMLComplexElement myOwner) {
        super(myOwner);
        setLabelName("数据库表");
    }


    public XMLElement generateNewElement() {
        Table f = new Table(this);
        f.setRequired(true);
        return f;
    }

    public XMLPanel getPanel() {
        controlledPanel = new XMLProcessTablePanel(this, "", false, false);
        controlPanel = new XMLProcessTableControlPanel(this, "", true, false);
        return new XMLGroupPanel(this, new XMLPanel[]{controlledPanel,
                controlPanel}, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
    }


    public Tables clone() {
        Tables f = (Tables) super.clone();
        return f;
    }

    public int[] getInvisibleTableFieldOrdinals() {
        return new int[]{0};
    }

    public void toXML(Node parent) {
        if (!isEmpty() || isRequired()) {
            if (parent != null) {
                String names = "";
                for (Iterator it = refCollectionElements.iterator(); it
                        .hasNext(); ) {
                    Table xmlElement = (Table) it.next();
                    xmlElement.toXML(parent);
                    names = xmlElement.getID() + ";" + names;
                }

                Element elem = parent.getOwnerDocument().createElement(
                        "ExtendedAttribute");
                elem.setAttribute("Name", FormNameEnum.TABLE.getType());
                elem.setAttribute("Type", Attributetype.DB.getType());
                elem.setAttribute("Value", names);
                parent.appendChild(elem);

            }
        }
    }

    public void afterImporting(List wpForms) {
        if (wpForms == null) {
            return;
        }
        for (int i = 0; i < wpForms.size(); i++) {
            ExtendedAttribute ea = (ExtendedAttribute) wpForms.get(i);
            String nm = ea.get("Name").toValue().toString();
            nm = nm.substring((FormNameEnum.TABLE.getType() + ".").length());
            if (nm.indexOf(".") == -1) {
                Table formElem = (Table) generateNewElement();
                add(formElem);
                formElem.afterImporting(ea);
            }
        }
    }
}
