/*
 * Created on 2004-3-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.common;

import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 一般扩展属性类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-25 14:53:09
 * @version 1.0
 */
public class CommonExAttribute extends XMLCollectionElement {

	// 属性名称
	private XMLAttribute attrName;

	// 属性值
	private XMLAttribute attrValue = new XMLAttribute("Value");

	// 属性值展示Panel
	private XMLPanel valuePanel;


	// 插件类
	private PluginElement pe;

	/**
	 * Construct a CommonExAttribute instance.
	 * 
	 * @param myCollection
	 */
	public CommonExAttribute(XMLCollection myCollection) {
		super(myCollection);
	
		setLabelName(Message
				.getLanguageDependentString("ExtendedAttributes.display"));
		// 得到所有可配置的扩展属性
		pe = (PluginElement) getCollection().getOwner();
		String configValue = (String) pe.getProperty("ConfigOption");
		String[] configValues = Utils.tokenize(configValue, " ");
		String[][] names = new String[configValues.length][2];
		for (int i = 0; i < names.length; i++) {
			names[i][0] = (String) pe.getProperty(configValues[i] + ".Name");
			names[i][1] = configValues[i];
		}
		attrName = new XMLAttribute("Name", names, 0) {
			public void itemChanged(Object o) {
				XMLSelectOption elem = (XMLSelectOption) o;
				String val = elem.getText();
				String type = (String) pe.getProperty(val + ".Type");
				if (valuePanel == null) {
					valuePanel = attrValue.getOldPanel();
				}
				attrValue = generateValueObject(Integer.parseInt(type), val);
				
				valuePanel.updatePanel(attrValue.getPanel());
				valuePanel.setOwner(attrValue);
				
			}
		};
		attrName.setLabelName(Message
				.getLanguageDependentString("ExtendedAttributes.Name.display"));
		fillStructure();
		if (configValues.length > 0) {
			attrValue = generateValueObject(Integer.parseInt((String) pe
					.getProperty(configValues[0] + ".Type")), configValues[0]);
		}
	}

	protected void fillStructure() {
		super.fillStructure();
		complexStructure.add(attrName);
	}

	// 得到一般扩展属性显示的panel
	public XMLPanel getPanel() {
		
		return new XMLGroupPanel(this,
				new XMLElement[] { attrName, attrValue }, toLabel());
	}

	public void toXML(Node parent) {
		Element elem = parent.getOwnerDocument().createElement(
				"ExtendedAttribute");
		String nm = attrName.toValue().toString();
		elem.setAttribute("Name", nm);
		elem.setAttribute("Type", CommonAttribute.TYPE_NAME);
		elem.setAttribute("Value", attrValue.toValue().toString());
		parent.appendChild(elem);
	}

	public String toString() {
		return attrName.toString();
	}

	// 得到属性值为CheckBox时选择范围
	private String[][] getElemValues(String val) {
		String elemName = (String) pe.getProperty(val + ".SelectOption");
		String[] elemNames = Utils.tokenize(elemName, " ");
		String[][] values = new String[elemNames.length][2];
		for (int i = 0; i < values.length; i++) {
			String elem = elemNames[i];
			String[] elemValues = Utils.tokenize(elem, "|");
			values[i][0] = elemValues[1];
			values[i][1] = elemValues[0];
		}
		return values;
	}

	public void afterImporting(Object obj) {
		if (obj instanceof ExtendedAttribute) {
			ExtendedAttribute ea = (ExtendedAttribute) obj;
			String nm = ea.get("Name").toValue().toString();
			attrName.setValue(nm);
			attrName.refreshDisplayValue();
			String value = ea.get("Value").toValue().toString();
			//if (nm.indexOf(".")!=-1){
				attrValue = generateValueObject(Integer.parseInt((String) pe
						.getProperty(nm + ".Type")), nm);
				attrValue.setValue(value);
				attrValue.refreshDisplayValue();
			//}
		
		}
	}

	private XMLAttribute generateValueObject(int type, String val) {
		XMLAttribute attrValue = null;
		switch (type) {
		case CommonAttribute.TEXTAREA_TYPE:
			attrValue = new XMLAttribute("Value");
			attrValue.setRequired(true);
			break;
		case CommonAttribute.CHECKBOX_TYPE:
			attrValue = new XMLAttribute("Value", getElemValues(val), 0);
			break;
		}
		attrValue
				.setLabelName(Message
						.getLanguageDependentString("ExtendedAttributes.Value.display"));
		if (complexStructure.size() > 2) {
			complexStructure.set(2, attrValue);
		} else {
			complexStructure.add(attrValue);
		}
		return attrValue;
	}

	// 实现clone方法
	public Object clone() {
		CommonExAttribute cea = (CommonExAttribute) super.clone();
		cea.attrName = (XMLAttribute) this.attrName.clone();
		cea.attrValue = (XMLAttribute) this.attrValue.clone();
		cea.fillStructure();
		cea.complexStructure.add(cea.attrValue);
		return cea;
	}
}
