/*
 * Created on 2004-3-9
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import java.awt.event.ActionEvent;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动表单意见域控制显示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-9 9:48:42
 * @version 1.0
 */
public class XMLOpinionControlPanel extends XMLTableControlPanel {

	/**
	 * Construct a XMLOpinionControlPanel instance.
	 * 
	 * @param myOwner
	 * @param title
	 * @param isVertical
	 * @param hasBorder
	 */
	public XMLOpinionControlPanel(XMLCollection myOwner, String title,
			boolean isVertical, boolean hasBorder) {
		super(myOwner, title, isVertical, hasBorder);
	}

	protected void editPerform(ActionEvent ae) {
		if (BPD.getInstance().getUserInfo() == null) {
			return;
		}
		XMLComplexElement editElement = getSelectedElement();
		if (editElement != null) {
			XMLElement fields = editElement.get("OpinionFields");
			XMLElementDialog de = new XMLElementDialog(getDialog(), "'"
					+ editElement.get("Value").toValue().toString() + "' "
					+ fields.toLabel() + " - "
					+ ResourceManager.getLanguageDependentString("EditingKey"));
			de.editXMLElement(fields.getPanel(), true, false);
			if (!de.isCanceled()) {
				modifyElement(editElement);
				((XMLCollection) getOwner()).onElementModified(editElement);
			}
		} else {
			complainLoudly("WarningEmptySelectionToEditOrDelete");
		}
		((XMLTablePanel) controlledPanel).getTable().requestFocus();
	}
}
