/*
 * Created on 2004-3-9
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import javax.swing.JCheckBox;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

public class OpinionRightGroup extends XMLCollectionElement {

    // 权限组代码
    private XMLAttribute attrCode = new XMLAttribute("Code");

    // 权限组名称
    private XMLAttribute attrName = new XMLAttribute("Name");

    // 是否选择
    private XMLAttribute isSelected = new XMLAttribute("IsSelected");

    // 权限组选择框
    private JCheckBox checkBox;

    /**
     * Construct a OpinionRightGroup instance.
     *
     * @param myCollection
     */
    public OpinionRightGroup(XMLCollection myCollection) {
        super(myCollection);
        isSelected.setValue((new Boolean(false)).toString());
        fillStructure();
    }

    protected void fillStructure() {
        complexStructure.add(attrCode);
        complexStructure.add(attrName);
        complexStructure.add(isSelected);
    }

    public XMLPanel getPanel() {
        XMLPanel panel = new XMLPanel() {
            public void setElements() {
                if (checkBox != null && checkBox.isSelected()) {
                    isSelected.setValue(new Boolean(checkBox.isSelected())
                            .toString());
                }
            }
        };
        checkBox = new JCheckBox(attrName.toValue().toString());
        if (isSelected.toValue().toString().equalsIgnoreCase(
                (new Boolean(true).toString()))) {
            checkBox.setSelected(true);
        }
        panel.add(checkBox);
        return panel;
    }

    public boolean isSelected() {
        return isSelected.toValue().toString().equals(
                (new Boolean(true).toString())) ? true : false;
    }

    // 实现clone方法
    public Object clone() {
        OpinionRightGroup org = (OpinionRightGroup) super.clone();
        org.attrCode = (XMLAttribute) this.attrCode.clone();
        org.attrName = (XMLAttribute) this.attrName.clone();
        org.isSelected = (XMLAttribute) this.isSelected.clone();
        org.fillStructure();
        return org;
    }
}
