
package com.ds.bpm.bpd.plugin.impl.activity;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.activitydef.task.TaskEnums;
import com.ds.bpm.enums.command.CommonEnums;
import com.ds.config.BPDPlugin;
import com.ds.enums.EnumsUtil;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.*;

public class ActivityTask extends ExpressionElement {

    private XMLAttribute taskDelayTime = new XMLAttribute(TaskEnums.TaskDelayTime.getType(), TaskEnums.TaskDelayTime.getDisplayName());

    private XMLAttribute reRryTimes = new XMLAttribute(TaskEnums.ReRryTimes.getType(), TaskEnums.ReRryTimes.getDisplayName());

    private XMLAttribute performType = new XMLAttribute(EnumsUtil.getAttribute(CommonEnums.COMMANDPERFORMTYPE));

    private XMLAttribute reTryType = new XMLAttribute(EnumsUtil.getAttribute(CommonEnums.COMMANDRETRY));

    private Formulas taskSelected = new Formulas(this, FormulaType.TableSelectedID);

    private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);

    public ActivityTask(BPDPlugin plugin) {
        super(plugin);
        fillStructure();
    }

    public WorkflowProcess getProcess() {
        return wp;
    }

    protected void fillStructure() {
        super.fillStructure();
        taskDelayTime.setValue(0);
        reRryTimes.setValue(3);
        complexStructure.add(performType);
        complexStructure.add(reTryType);
        complexStructure.add(taskSelected);

        complexStructure.add(refExtendedAttributes);
        complexStructure.add(taskDelayTime);
        complexStructure.add(reRryTimes);

        // }
        ExtendedAttribute ea;
        // 把监听器属性加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.get("Value").setRequired(false);
        ea.set("Name", "CommandListeners");

        ((ArrayList) refExtendedAttributes.toCollection()).add(ea);

    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
        NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
        Element easElem;
        Document doc = parent.getOwnerDocument();
        if (nodeList.getLength() != 0) {
            easElem = (Element) nodeList.item(0);
        } else {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                easElem.appendChild(eaElem);
            }
        }

    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        act = (Activity) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List commandSelectedList = new ArrayList();

        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();
            if (nm.startsWith("CommandSelected".toUpperCase())) {
                commandSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }

            if (nm.equalsIgnoreCase("PERFORMTYPE")) {
                performType.setValue(val);
                performType.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase("COMMANDRETRY")) {
                reTryType.setValue(val);
                reTryType.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }

            if (nm.equalsIgnoreCase("TaskDelayTime")) {
                taskDelayTime.setValue(val);
                taskDelayTime.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase("TaskRetryTimes")) {
                reRryTimes.setValue(val);
                reRryTimes.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }

        }

        taskSelected.afterImporting(commandSelectedList);
        exAttrs.toCollection().removeAll(easToRemove);
    }

    public void setLabelName() {
        // 初始化页面显示属性
        setLabelName(this.getBpdElement().getDisplayname());
        reRryTimes.setLabelName(Message.getLanguageDependentString("Activity.Command.RetryTimes.display"));

    }

    public Object clone() {
        ActivityTask ar = (ActivityTask) super.clone();
        ar.performType = (XMLAttribute) this.performType.clone();
        ar.reTryType = (XMLAttribute) this.reTryType.clone();

        ar.taskSelected = (Formulas) this.taskSelected.clone();
        ar.taskDelayTime = (XMLAttribute) this.taskDelayTime.clone();
        ar.reRryTimes = (XMLAttribute) this.reRryTimes.clone();

        ar.fillStructure();
        return ar;
    }

    public XMLPanel getPanel() {
        XMLPanel commonPanel = new XMLGroupPanel(this, new XMLElement[]{performType, reTryType, taskDelayTime, reRryTimes}, "任务执行方式");
        return new XMLTabbedPanel(this, new XMLPanel[]{commonPanel, taskSelected.getPanel()});
    }
}
