/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.activitydef.ActivityDefRightAtt;
import com.ds.bpm.enums.right.RightDefEnums;
import com.ds.bpm.formula.ParticipantSelect;
import com.ds.config.BPDPlugin;
import com.ds.enums.EnumsUtil;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.*;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动权限插件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @version 5.0
 */
public class ActivityRight extends ExpressionElement {

    // 办理人选择条件
    protected Formulas performerSelected = new Formulas(this, FormulaType.PerformerSelectedID);

    // 传阅人选择条件
    protected Formulas readerSelected = new Formulas(this, FormulaType.ReaderSelectedID);

    private XMLAttribute performType = new XMLAttribute(EnumsUtil.getAttribute(RightDefEnums.ActivityDefPerformtype));

    private XMLAttribute performSequence = new XMLAttribute(EnumsUtil.getAttribute(RightDefEnums.ActivityDefPerformSequence));

    private XMLAttribute canInsteadSign = new XMLAttribute(EnumsUtil.getAttribute(RightDefEnums.CANINSTEADSIGN));

    // 代签人条件
    private Formulas insteadSignSelected = new Formulas(this, FormulaType.InsteadSignSelectedID);

    // 办理人办理之后权限组
    private XMLAttribute movePerformerTo = new XMLAttribute(ActivityDefRightAtt.MOVEPERFORMERTO.getType());

    // 传阅人传阅之后权限组
    private XMLAttribute moveReaderTo = new XMLAttribute(ActivityDefRightAtt.MOVEREADERTO.getType());

    private XMLAttribute canSurrogate = new XMLAttribute(EnumsUtil.getAttribute(RightDefEnums.CANSURROGATE));

    // 代办人
    private XMLAttribute surrogate = new XMLAttribute(ActivityDefRightAtt.SURROGATEID.getType());

    private XMLAttribute canReSend = new XMLAttribute(EnumsUtil.getAttribute(RightDefEnums.CANRESEND));

    private XMLAttribute canTakeBack = new XMLAttribute(EnumsUtil.getAttribute(RightDefEnums.CANTAKEBACK));
    private List<ParticipantSelect> formulas;

    public ActivityRight(BPDPlugin plugin) {
        super(plugin);
        fillStructure();
    }

    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(performerSelected);
        complexStructure.add(readerSelected);
        complexStructure.add(performType);
        complexStructure.add(performSequence);
        complexStructure.add(canInsteadSign);
        complexStructure.add(insteadSignSelected);
        complexStructure.add(movePerformerTo);
        complexStructure.add(moveReaderTo);
        complexStructure.add(canSurrogate);
        complexStructure.add(surrogate);
        complexStructure.add(canReSend);
        complexStructure.add(canTakeBack);
    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
        NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
        Element easElem;
        Document doc = parent.getOwnerDocument();
        if (nodeList.getLength() != 0) {
            easElem = (Element) nodeList.item(0);
        } else {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }
        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                eaElem.setAttribute("Type", FormulaType.PerformerSelectedID.getBaseType().getType());
                easElem.appendChild(eaElem);
            }
        }
    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        act = (Activity) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List performerSelectedList = new ArrayList();
        List readerSelectedList = new ArrayList();
        List insteadSignSelectedList = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();

            if (nm.startsWith(ActivityDefRightAtt.PERFORMERSELECTEDID.getType())) {
                performerSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }
            if (nm.startsWith(ActivityDefRightAtt.READERSELECTEDID.getType())) {
                readerSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(RightDefEnums.ActivityDefPerformtype.getType())) {
                performType.setValue(val);
                performType.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(RightDefEnums.ActivityDefPerformSequence.getType())) {
                performSequence.setValue(val);
                performSequence.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(RightDefEnums.CANINSTEADSIGN.getType())) {
                canInsteadSign.setValue(val);
                canInsteadSign.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }

            if (nm.startsWith(ActivityDefRightAtt.INSTEADSIGNSELECTED.getType())) {
                insteadSignSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(ActivityDefRightAtt.MOVEPERFORMERTO.getType())) {
                movePerformerTo.setValue(val);
                movePerformerTo.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(ActivityDefRightAtt.MOVEREADERTO.getType())) {
                moveReaderTo.setValue(val);
                moveReaderTo.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(RightDefEnums.CANSURROGATE.getType())) {
                canSurrogate.setValue(val);
                canSurrogate.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(RightDefEnums.CANSURROGATE.getType())) {
                surrogate.setValue(val);
                surrogate.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(RightDefEnums.CANRESEND.getType())) {
                canReSend.setValue(val);
                canReSend.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
            if (nm.equalsIgnoreCase(RightDefEnums.CANTAKEBACK.getType())) {
                canTakeBack.setValue(val);
                canTakeBack.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }

        }
        performerSelected.afterImporting(performerSelectedList);
        readerSelected.afterImporting(readerSelectedList);
        insteadSignSelected.afterImporting(insteadSignSelectedList);
        exAttrs.toCollection().removeAll(easToRemove);
    }

    public void loadProperties() throws PluginException {
        Object wpObj = getProperty("WorkflowProcess");
        if (wpObj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        wp = (WorkflowProcess) wpObj;

        Object obj = getProperty("Activity");
        if (obj != null) {
            act = (Activity) obj;
            Object[] rightGroup = WorkflowManager.getRightGroup(act.getOwnerProcess()).toArray();
            movePerformerTo = new XMLAttribute(ActivityDefRightAtt.MOVEPERFORMERTO.getType(), rightGroup, 0);
            moveReaderTo = new XMLAttribute(ActivityDefRightAtt.MOVEREADERTO.getType(), rightGroup, 0);
            int index = getIndex(ActivityDefRightAtt.MOVEPERFORMERTO.getType());
            if (index != -1) {
                complexStructure.set(index, movePerformerTo);
            } else {
                complexStructure.add(movePerformerTo);
            }
            index = getIndex(ActivityDefRightAtt.MOVEREADERTO.getType());
            if (index != -1) {
                complexStructure.set(index, moveReaderTo);
            } else {
                complexStructure.add(moveReaderTo);
            }
            setLabelName();
            if (BPD.getInstance().getUserInfo() != null) {
                formulas = getFormulas(FormulaType.PerformerSelectedID);
            }
            //throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }

    }

    public void setLabelName() {
        // 初始化页面显示属性
        setLabelName(Message.getLanguageDependentString("Activity.Right.display"));
        performerSelected.setLabelName(Message.getLanguageDependentString("Activity.Right.PerformerSelectedID.display"));
        readerSelected.setLabelName(Message.getLanguageDependentString("Activity.Right.ReaderSelectedID.display"));
        movePerformerTo.setLabelName(Message.getLanguageDependentString("Activity.Right.MovePerformerTo.display"));
        moveReaderTo.setLabelName(Message.getLanguageDependentString("Activity.Right.MoveReaderTo.display"));
        surrogate.setLabelName(Message.getLanguageDependentString("Activity.Right.Surrogate.display"));
    }

    public Object clone() {
        ActivityRight ar = (ActivityRight) super.clone();
        ar.performerSelected = (Formulas) this.performerSelected.clone();
        ar.readerSelected = (Formulas) this.readerSelected.clone();
        ar.performType = (XMLAttribute) this.performType.clone();
        ar.performSequence = (XMLAttribute) this.performSequence.clone();
        ar.canInsteadSign = (XMLAttribute) this.canInsteadSign.clone();
        ar.insteadSignSelected = (Formulas) this.insteadSignSelected.clone();
        ar.movePerformerTo = (XMLAttribute) this.movePerformerTo.clone();
        ar.moveReaderTo = (XMLAttribute) this.moveReaderTo.clone();
        ar.canSurrogate = (XMLAttribute) this.canSurrogate.clone();
        ar.surrogate = (XMLAttribute) this.surrogate.clone();
        ar.canReSend = (XMLAttribute) this.canReSend.clone();
        ar.canTakeBack = (XMLAttribute) this.canTakeBack.clone();
        ar.fillStructure();
        return ar;
    }

    public XMLPanel getPanel() {
        XMLPanel commonPanel = new XMLGroupPanel(this, new XMLElement[]{performType, performSequence, canSurrogate, canTakeBack, canReSend, surrogate}, Message.getLanguageDependentString("Activity.Right.Common.display"));
        XMLPanel performerPanel = performerSelected.getPanel();
        XMLPanel readerPanel = readerSelected.getPanel();
        XMLPanel insteadSignPanel = new XMLGroupPanel(this, new XMLElement[]{canInsteadSign, insteadSignSelected}, insteadSignSelected.toLabel());
        return new XMLTabbedPanel(this, new XMLPanel[]{commonPanel, performerPanel, readerPanel, insteadSignPanel});
    }
}
