
package com.ds.bpm.bpd.plugin.impl.activity;

import com.ds.bpm.bpd.enums.DeviceDefEventEnums;
import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.config.BPDPlugin;
import com.ds.enums.EnumsUtil;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.*;

public class ActivityDeviceEvent extends ExpressionElement {

    private Formulas performSelected = new Formulas(this, FormulaType.DeviceSelectedID);

    private XMLAttribute attributeName = new XMLAttribute(EnumsUtil.getAttribute(DeviceDefEventEnums.AttributeName));


    public ActivityDeviceEvent(BPDPlugin plugin) {
        super(plugin);
        fillStructure();
    }

    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(attributeName);
        complexStructure.add(performSelected);

    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
        NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
        Element easElem;
        Document doc = parent.getOwnerDocument();
        if (nodeList.getLength() != 0) {
            easElem = (Element) nodeList.item(0);
        } else {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Type", FormulaType.DeviceEventSelectedID.getBaseType().getType());
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                easElem.appendChild(eaElem);
            }
        }
    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        act = (Activity) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List performerSelectedList = new ArrayList();
        List deviceEventSelectedList = new ArrayList();

        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();
            if (nm.startsWith(FormulaType.DeviceSelectedID.getType())) {
                performerSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }

            if (nm.equalsIgnoreCase("AttributeName")) {
                attributeName.setValue(val);
                attributeName.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }

            if (nm.startsWith(FormulaType.DeviceEventSelectedID.getType())) {
                deviceEventSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }

        }
        //deviceEventSelected.afterImporting(deviceEventSelectedList);
        performSelected.afterImporting(performerSelectedList);

        exAttrs.toCollection().removeAll(easToRemove);
    }

    public void setLabelName() {
        // 初始化页面显示属性
        //setLabelName(Message.getLanguageDependentString("Activity.DeviceEvent.display"));
        this.setLabelName(this.getBpdElement().getDisplayname());

//	deviceEventSelected.setLabelName(Message.getLanguageDependentString("Activity.DeviceEvent.EventSelected.display"));
        performSelected.setLabelName(Message.getLanguageDependentString("Activity.DeviceEvent.PerformType.display"));

    }

    public Object clone() {
        ActivityDeviceEvent ar = (ActivityDeviceEvent) super.clone();
        ar.attributeName = (XMLAttribute) this.attributeName.clone();
        ar.performSelected = (Formulas) this.performSelected.clone();

        ar.fillStructure();
        return ar;
    }

//    public XMLPanel getPanel() {
//
//	return new XMLTabbedPanel(this, new XMLPanel[] { performSelected.getPanel(), attributeName.getPanel() });
//    }
}
