/*
 * Created on 2004-2-16
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDPlugin;
import com.ds.config.PluginType;
import ognl.Ognl;
import ognl.OgnlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 实现插件的基类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author Huchm 2004-2-16 15:13:21
 * @version 1.0
 */
public abstract class PluginElement extends XMLComplexElement {

    // 插件引用的外部资源库
    private Map properties = new HashMap();

    // 插件类型
    private PluginType type;

    private BPDPlugin bpdElement;

    public Map contextMap;

    protected  PluginElement(BPDPlugin bpdElement) {
        this.bpdElement = bpdElement;
    }

    // 根据key取得外部资源
    public Object getProperty(String key) {
        Object value = properties.get(key.toUpperCase());
        if (value == null) {
            value = properties.get(key);

        }
        return value;
    }

    // 取得外部资源的所有key值
    public String[] getPropertyKeys() {
        return (String[]) properties.keySet().toArray(new String[properties.size()]);
    }

    // 设置外部资源
    public void setProperty(String key, Object obj) {
        properties.put(key.toUpperCase(), obj);
        properties.put(key, obj);
    }

    // 插件Load后配置信息
    public void afterImporting() throws PluginException {

    }

    // 插件Load后的初始化外部资源
    public void loadProperties() throws PluginException {
    }

    // 把数据信息保存到XML对象中
    public void toXML(Node parent) {
        Element easElem = (Element) XMLUtility.getFirstChild(parent, "ExtendedAttributes");
        Document doc = parent.getOwnerDocument();
        if (easElem == null) {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }
        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            element.toXML(easElem);
        }
    }

    public PluginType getType() {
        return type;
    }

    public void setType(PluginType type) {
        this.type = type;
    }

    public Object clone() {
        PluginElement pe = (PluginElement) super.clone();
        return pe;
    }

    public String getServerUrl() {

        String server = BPDConfig.getInstance().getServerName();
        String port = BPDConfig.getInstance().getServerPort();
        return "http://" + server + ":" + port;

    }

    public Object parExpression(String expression) {
        Object obj = null;
        try {
            obj = Ognl.getValue(expression, new HashMap(), getContextMap());
        } catch (OgnlException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public BPDPlugin getBpdElement() {
        return bpdElement;
    }

    public void setBpdElement(BPDPlugin bpdElement) {
        this.bpdElement = bpdElement;
    }

    public Map getContextMap() {
        if (contextMap == null) {
            contextMap = new HashMap();
            contextMap.put("BPD", BPD.getInstance());
            contextMap.put("username", BPD.getInstance().getUserInfo().getAccount());
            contextMap.put("personId", BPD.getInstance().getUserInfo().getId());
            contextMap.put("WorkflowProcess", getProperty("WorkflowProcess"));
            contextMap.put("Activity", getProperty("Activity"));
            contextMap.put("Route", getProperty("Route"));
            contextMap.put("BPDElement", this.getBpdElement());

        }
        return contextMap;
    }

    public void setContextMap(Map contextMap) {
        this.contextMap = contextMap;
    }

}
