
package com.ds.bpm.bpd.plugin;

import com.ds.bpm.bpd.plugin.impl.common.Message;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.Transition;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.formula.ExpressionParameter;
import com.ds.bpm.formula.ParticipantSelect;
import com.ds.common.JDSException;
import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import com.ds.esd.bpm.BPMFactory;
import com.ds.esd.client.ESDFacrory;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wenzhang
 */
public abstract class ExpressionElement extends PluginElement {

    // 公式类型

    // 公式名称
    public static final String FORMULA_NAME = "FORMULA";

    // 权限高级公式标识名
    public static final String CUSTOMFORMULA = "CUSTOMFORMULA";

    // 工作流对象
    protected WorkflowProcess wp;

    // 活动路由对象
    protected Transition route;

    // 活动路由对象
    protected Activity act;

    protected abstract void setLabelName();

    public void loadProperties() throws PluginException {
        Object wpObj = getProperty("WorkflowProcess");
        if (wpObj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        wp = (WorkflowProcess) wpObj;
        Object obj = getProperty("Route");
        if (obj != null) {
            route = (Transition) obj;
        }

        Object actObj = getProperty("Activity");
        if (act != null) {
            act = (Activity) actObj;
        }
        setLabelName();

    }

    protected ExpressionElement(BPDPlugin bpdElement) {
        super(bpdElement);
    }

    // 取得公式的信息集，返回二维数组，
    public List<ParticipantSelect> getFormulas(FormulaType type) {
        List<ParticipantSelect> obj = new ArrayList<>();
        try {
            getBPMFactory().reLoadFormulas();
            obj = getBPMFactory().getFormulas(type);
        } catch (JDSException e) {
            e.printStackTrace();
        }

        return obj;

    }

    public ParticipantSelect getFormula(List<ParticipantSelect> formulas, String val) {
        ParticipantSelect ret = null;

        if (val == null || val.trim().equals("")) {
            return ret;
        }
        if (formulas == null || formulas.isEmpty()) {
            return ret;
        }

        for (ParticipantSelect formula : formulas) {

            if (formula.getParticipantSelectId().equals(val)) {
                ret = formula;
                break;
            }
        }
        for (ParticipantSelect formula : formulas) {

            if (formula.getSelectName().equals(val)) {
                ret = formula;
                break;
            }
        }
        for (ParticipantSelect formula : formulas) {

            if (formula.getFormula().equals(val)) {
                ret = formula;
                break;
            }
        }
        return ret;
    }

    // 得到某个公式的参数集，没有参数返回空list
    public List<ExpressionParameter> getFormulaParameters(String formulaId) {
        List<ExpressionParameter> parameters = new ArrayList<>();
        try {
            ParticipantSelect formula = getBPMFactory().getFormulaById(formulaId);
            parameters = formula.getParameterList();
        } catch (JDSException e) {
            e.printStackTrace();
        }

        return parameters;
    }


    BPMFactory getBPMFactory() throws JDSException {

        return BPMFactory.getInstance(ESDFacrory.getESDClient().getSpace());
    }
}
