package com.ds.bpm.bpd.misc.treenode;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.misc.PackageTreePanel;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.client.ProcessDefVersion;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * 远端流程版本节点
 * <p>
 * 内部类
 */
public class RemoteProcessDefVersionNode extends DefaultMutableTreeNode {

    private final PackageTreePanel treePanel;

    /**
     * 类构造方法
     *
     * @param processDefVersion
     */
    public RemoteProcessDefVersionNode(ProcessDefVersion processDefVersion,PackageTreePanel treePanel) {
        setUserObject(processDefVersion);
        this.treePanel=treePanel;
        DefaultMutableTreeNode childNode = getChildNode(processDefVersion.getProcessDefVersionId());
        if (childNode != null) {
            int k = childNode.getChildCount();
            for (int i = 0; k > i; i++) {
                DefaultMutableTreeNode newChildNode = childNode.getNextNode();
                add(newChildNode);
            }
        }

    }

    /**
     * 获得流程版本对象
     *
     * @return
     */
    public ProcessDefVersion getProcessDefVersion() {
        return (ProcessDefVersion) getUserObject();
    }

    /**
     * 是否准许有子节点
     */
    public boolean getAllowsChildren() {
        return true;
    }

    /**
     * 是否是叶节点
     */
    public boolean isLeaf() {
        return false;
    }

    public DefaultMutableTreeNode getChildNode(String PorcessDefVersionId) {
        DefaultMutableTreeNode childLocalPracessNode = new DefaultMutableTreeNode();
        WorkflowProcess wp = (WorkflowProcess) BPD.getInstance().getRomveWorkflowProcessMap().get(PorcessDefVersionId);
        if (wp == null) {

            return null;
        } else {

            DefaultMutableTreeNode newremoteProcessNode = new DefaultMutableTreeNode();
            childLocalPracessNode = treePanel.addChildProcess(wp, newremoteProcessNode, BPDConstants.PROCESS_REMOTE);
            treePanel.getRemoteTreeNodeMap().put(newremoteProcessNode, wp.getVersionID());
        }
        return childLocalPracessNode;
    }

    /**
     * 获得显示字符串
     */
    public String toString() {
        ProcessDefVersion processDefVersion = getProcessDefVersion();
        // 获得流程版本的状态

        // 节点显示名称
        String versionName = ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessVersionNode.Name.display") + "." + processDefVersion.getVersion() + " (" + processDefVersion.getPublicationStatus().getName() + ")";
        return versionName;
    }


}