package com.ds.bpm.bpd.misc.treenode;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.misc.PackageTreePanel;
import com.ds.bpm.client.ProcessDef;
import com.ds.config.BPDProjectConfig;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.Iterator;
import java.util.Map;

/**
 * 远端流程分类节点
 * <p>
 * 内部类
 */
public class RemoteClassificationDefNode extends DefaultMutableTreeNode {

    private final PackageTreePanel treePanel;
    // 是否张开的标志
    private boolean explore = false;

    /**
     * 构造方法
     */
    public RemoteClassificationDefNode(BPDProjectConfig classificationName, PackageTreePanel treePanel) {
        setUserObject(classificationName);
        this.treePanel = treePanel;
        explore();
    }

    /**
     * 获得远端流程分类对象
     *
     * @return
     */
    public BPDProjectConfig getClassification() {
        return (BPDProjectConfig) getUserObject();
    }

    /**
     * 是否准许有子节点
     */
    public boolean getAllowsChildren() {
        return true;
    }

    /**
     * 是否是叶节点
     */
    public boolean isLeaf() {
        return false;
    }

    /**
     * 是否已经展开
     *
     * @return explore
     */
    public boolean isExplore() {
        return explore;
    }

    /**
     * 获得显示字符串
     */
    public String toString() {
        BPDProjectConfig classification = getClassification();
        return classification.getName();
    }

    /**
     * 展开分类节点
     */
    public void explore() {
        if (!isExplore()) {
            BPDProjectConfig classification = getClassification();
            if (classification != null) {
                Map<String, ProcessDef> processDefMap = BPD.getInstance().getRemoteProcessMap();

                for (Iterator<String> it = processDefMap.keySet().iterator(); it.hasNext(); ) {
                    String processDefId = it.next();
                    ProcessDef processDef = processDefMap.get(processDefId);
                    if (processDef.getClassification() != null && processDef.getSystemCode().equals(classification.getSysId()) && processDef.getClassification().equals(classification.getCode())) {

                        RemoteProcessDefNode remoteProcessDefNode = new RemoteProcessDefNode(processDef, treePanel);
                        add(remoteProcessDefNode);

                    }

                }
                explore = true;
            }

        }
    }
}