package com.ds.bpm.bpd.misc.treenode;

import com.ds.bpm.bpd.*;
import com.ds.bpm.bpd.misc.PackageTreePanel;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import java.awt.*;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ProcessDefNodeRenderer extends DefaultTreeCellRenderer {

    private final PackageTreePanel treePanel;
    private JPanel panel = new JPanel();


    /**
     * 构造方法
     */
    public ProcessDefNodeRenderer(PackageTreePanel treePanel) {
        this.treePanel = treePanel;
        setOpaque(false);
        panel.setOpaque(false);
        panel.setPreferredSize(new Dimension(150, 20));
        panel.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
        panel.add(this);
    }

    /**
     * 重构类的方法
     */
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Map processMap = new HashMap();
        String versionId = "";
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;

        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        // 节点是否在本地打开流程集合中
        if (treePanel.getLocalTreeNodeMap().containsKey(node)) {
            processMap = BPD.getInstance().getLocalEditingProcessMap();
            versionId = (String) treePanel.getLocalTreeNodeMap().get(node);
        }
        // 节点是否在远程打开流程集合中
        else if (treePanel.getRemoteTreeNodeMap().containsKey(node)) {
            processMap = BPD.getInstance().getRemoteEditingProcessMap();
            versionId = (String) treePanel.getRemoteTreeNodeMap().get(node);
        }
        // 验证流程是否被打开
        boolean processIsOpened = false;
        PackageEditor editor = treePanel.getPackageEditor();
        if (editor.getContentTabbedPane().indexOfComponent((ProcessEditor) processMap.get(versionId)) != -1) {
            processIsOpened = true;
        }

        if (node instanceof RemoteClassificationDefNode) {
            // 区分打开流程的图片
            URL url = ResourceManager.getResource("FlowTypeTabbedPane" + BPDConstants.IMAGE_SUFFIX);
            ImageIcon image = new ImageIcon(url);
            this.setIcon(image);
        }

        if (node instanceof RemoteAppDefNode) {
            // 区分打开流程的图片
            URL url = ResourceManager.getResource("AppTabbedPane" + BPDConstants.IMAGE_SUFFIX);
            ImageIcon image = new ImageIcon(url);
            this.setIcon(image);
        }

        // 如果流程被打开，则流程节点后显示已打开图标
        if (node instanceof RemoteProcessDefVersionNode) {
            // 区分打开流程的图片
            URL url = ResourceManager.getResource("OpenedProcessTabbedPane" + BPDConstants.IMAGE_SUFFIX);
            ImageIcon image = new ImageIcon(url);
            this.setIcon(image);
        }

        return panel;
    }
}
