/* XMLTreePanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：主界面右侧的流程树展示类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.misc;

import com.ds.bpm.bpd.*;
import com.ds.bpm.bpd.actions.Close;
import com.ds.bpm.bpd.actions.New;
import com.ds.bpm.bpd.config.AppConfigManager;
import com.ds.bpm.bpd.config.ApplicationPanel;
import com.ds.bpm.bpd.misc.task.CreateVersionTask;
import com.ds.bpm.bpd.misc.task.OpenProcessTask;
import com.ds.bpm.bpd.misc.treenode.*;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.WorkflowProcesses;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.client.ProcessDef;
import com.ds.bpm.client.ProcessDefVersion;
import com.ds.bpm.engine.BPMException;
import com.ds.bpm.enums.process.ProcessDefVersionStatus;
import com.ds.common.JDSException;
import com.ds.common.swing.ProgressDialog;
import com.ds.config.CApplication;
import com.ds.config.BPDProjectConfig;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.*;
import java.util.List;
import java.util.Map.Entry;

/**
 * Creates a tree panel.
 */
public class PackageTreePanel extends JPanel {

    // 树列表的最小尺寸
    private static Dimension minTreeDimension = new Dimension(160, 420);

    // 树对象
    final JTree allItems;

    private PackageEditor packageEditor;

    // 打开过的本地流程节点集合
    private Map<DefaultMutableTreeNode, String> localTreeNodeMap = new HashMap<DefaultMutableTreeNode, String>();

    // 打开过的远程流程节点集合
    private Map<DefaultMutableTreeNode, String> remoteTreeNodeMap = new HashMap<DefaultMutableTreeNode, String>();


    private DefaultMutableTreeNode selectedNode;

    // 本地流程树节点
    private DefaultMutableTreeNode localProcessRootNode;

    // 远程流程树节点
    private DefaultMutableTreeNode remoteProcessRootNode;

    // 流程最大版本UUID
    private String maxVersion = "1";


    private String processFlag;

    public PackageTreePanel(PackageEditor pkgEditor, String title, boolean hasBorder, String processFlag) {
        super();
        this.processFlag = processFlag;

        this.packageEditor = pkgEditor;

        // 设置树目录标题
        setTitle(title, hasBorder);

        // creating a tree which do not allow cell editing
        allItems = new JTree();
        // setting some tree properties
        allItems.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        allItems.setRootVisible(false);
        ProcessDefNodeRenderer renderer = new ProcessDefNodeRenderer(this);
        allItems.setCellRenderer(renderer);
        // creates panel
        // allItems.setMaximumSize(maxTreeDimension);
        JScrollPane allItemsPane = new JScrollPane();
        allItemsPane.setViewportView(allItems);
        // allItemsPane.getViewport().setPreferredSize(treeDimension);
        // allItemsPane.getViewport().setMinimumSize(minTreeDimension);
        // allItemsPane.setAlignmentX(JPanel.LEFT_ALIGNMENT);

        setMinimumSize(minTreeDimension);
        setAlignmentX(JPanel.LEFT_ALIGNMENT);
        setLayout(new BorderLayout());
        add(BorderLayout.CENTER, allItemsPane);
        allItems.addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    // 本地流程子根节点名称
                    String localTreeNodeName = ResourceManager.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Name.display");
                    // 远端流程子根节点名称
                    String remoteTreeNodeName = ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Name.display");
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getLastPathComponent();
                    if (!node.toString().equals(localTreeNodeName) && !node.toString().equals(remoteTreeNodeName)) {
                        // 选择点击的流程版本ID
                        String versionId = null;
                        String processFlag = null;
                        Map processMap = new HashMap();
                        if (localTreeNodeMap.containsKey(node)) {
                            // 如果选择流程节点是本地流程，则从本地打开流程集合中获得流程版本ID
                            versionId = (String) localTreeNodeMap.get(node);
                            processFlag = BPDConstants.PROCESS_LOCAL;
                            processMap = BPD.getInstance().getLocalEditingProcessMap();
                        } else if (remoteTreeNodeMap.containsKey(node)) {
                            // 如果选择流程节点是远端流程，则从远端打开流程集合中获得流程版本ID
                            versionId = (String) remoteTreeNodeMap.get(node);
                            processFlag = BPDConstants.PROCESS_REMOTE;
                            processMap = BPD.getInstance().getRemoteEditingProcessMap();
                        }
                        // 如果选择的树节点流程版本已经打开，则选中它
                        if (versionId != null && processMap.containsKey(versionId)) {
                            if (packageEditor.getContentTabbedPane().indexOfComponent((ProcessEditor) processMap.get(versionId)) != -1) {
                                // packageEditor.getContentTabbedPane()
                                // .setSelectedComponent(
                                // (ProcessEditor) processMap
                                // .get(versionId));
                            }
                            /*
                             * Component[] processEditorArray = (Component[]) ctp.getComponents(); for (int i = 0; i <
                             * processEditorArray.length; i++) { ProcessEditor processEditor = (ProcessEditor)
                             * processEditorArray[i]; String editingVersionId = ((WorkflowProcess)
                             * processEditor.getGraph().getXPDLObject()).getVersionID(); if
                             * (processEditor.getProcessFlag().equals(processFlag) &&
                             * editingVersionId.equals(versionId)) { ctp.setSelectedComponent(processEditor); break; } }
                             */
                        }
                    }
                }
            }
        });
        allItems.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                // 右键弹出菜单
                if (SwingUtilities.isRightMouseButton(e)) {
                    JTree tree = (JTree) e.getSource();
                    TreeSelectionModel model = tree.getSelectionModel();
                    TreePath path = model.getSelectionPath();
                    if (path != null) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getLastPathComponent();
                        // 本地流程子根节点名称
                        String localTreeNodeName = ResourceManager.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Name.display");
                        // 远端流程子根节点名称
                        String remoteTreeNodeName = ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Name.display");
                        if (!node.toString().equals(localTreeNodeName) && !node.toString().equals(remoteTreeNodeName)) {
                            JPopupMenu menu = createRightMenu(node);
                            if (menu != null) {
                                menu.show(tree, e.getX(), e.getY());
                            }

                        }
                    }
                }
                // 双击打开流程
                if (!e.isConsumed() && e.getClickCount() == 2) {
                    JTree tree = (JTree) e.getSource();
                    TreeSelectionModel model = tree.getSelectionModel();
                    TreePath path = model.getSelectionPath();
                    if (path != null) {
                        // 本地流程子根节点名称
                        String localTreeNodeName = ResourceManager.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Name.display");
                        // 远端流程子根节点名称
                        String remoteTreeNodeName = ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Name.display");
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getLastPathComponent();
                        selectedNode = node;
                        openFlow(node);
                    }
                }
            }
        });
        refreshPackageTreePanel();
    }

    /**
     * 刷新打开流程面板
     */
    public void refreshPackageTreePanel() {

        JTree jt = getTree();
        jt.setBackground(Utils.getColor(BPDConfig.getInstance().getGraphBackgroundColor()));
        ProcessDefNodeRenderer dtcr = (ProcessDefNodeRenderer) jt.getCellRenderer();
        dtcr.setBackground(Utils.getColor(BPDConfig.getInstance().getGraphBackgroundColor()));
        dtcr.setBackgroundNonSelectionColor(Utils.getColor(BPDConfig.getInstance().getGraphBackgroundColor()));
        refreshTreeModel();
        jt.validate();
    }

    /**
     * 刷新打开流程列表内容
     */

    private void refreshTreeModel() {
        if (processFlag == null || processFlag.equals(BPDConstants.PROCESS_LOCAL)) {
            refreshLocalTreeModel();
        }
        if (processFlag == null || processFlag.equals(BPDConstants.PROCESS_REMOTE)) {
            refreshRemoteTreeModel();
        }
    }

    private void refreshLocalTreeModel() {
        DefaultTreeModel model = (DefaultTreeModel) allItems.getModel();
        // 添加流程列表根节点
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(ResourceManager.getLanguageDependentString("PackageTreePanel.Name.display"));
        // 添加本地流程列表的根节点
        localProcessRootNode = new DefaultMutableTreeNode(ResourceManager.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Name.display"));
        // 添加本地流程
        Map localProcessMap = BPD.getInstance().getLocalEditingProcessMap();
        localTreeNodeMap.clear();
        Set localProcessCln = localProcessMap.entrySet();
        Iterator localProcessIter = localProcessCln.iterator();
        while (localProcessIter.hasNext()) {
            Entry processEditorEntry = (Entry) localProcessIter.next();
            String lpVersionId = (String) processEditorEntry.getKey();
            ProcessEditor processEditor = (ProcessEditor) processEditorEntry.getValue();
            String processName = (String) ((WorkflowProcess) processEditor.getGraph().getXPDLObject()).get("Name").toValue();
            WorkflowProcess wp = (WorkflowProcess) processEditor.getGraph().getXPDLObject();

            Package pkg = wp.getPackage();
            if (!wp.isSubFlow()) {
                WorkflowProcesses wps = (WorkflowProcesses) pkg.get("WorkflowProcesses");
                wps.toCollection();

                String version = ((WorkflowProcess) processEditor.getGraph().getXPDLObject()).getVersionNumber();
                DefaultMutableTreeNode localProcessNode = new DefaultMutableTreeNode(processName + "(" + ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessVersionNode.Name.display") + "." + version + ")");
                DefaultMutableTreeNode childLocalPracessNode = addChildProcess(wp, localProcessNode, BPDConstants.PROCESS_LOCAL);
                localProcessRootNode.add(childLocalPracessNode);

                // localProcessRootNode.add(localProcessNode);
                // 建立本地流程版本节点与本地流程版本ID的对应关系
                localTreeNodeMap.put(localProcessNode, lpVersionId);
            }
        }
        root.add(localProcessRootNode);

        model.setRoot(root);
        model.nodeStructureChanged(root);
        allItems.setModel(model);
        allItems.setExpandsSelectedPaths(true);
        // 展开本地流程根节点
        allItems.expandPath(new TreePath(localProcessRootNode.getPath()));
        // 如果流程树型列表的缺省设置为有效时，才展开
        if (BPDConfig.getInstance().getJTreeExpandStatus()) {
            // 展开所有本地流程节点

            for (int i = 0; i < localProcessRootNode.getChildCount(); i++) {
                allItems.expandPath(new TreePath(((DefaultMutableTreeNode) localProcessRootNode.getChildAt(i)).getPath()));
            }

        }
    }

    private void refreshRemoteTreeModel() {
        DefaultTreeModel model = (DefaultTreeModel) allItems.getModel();
        // 添加流程列表根节点
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(ResourceManager.getLanguageDependentString("PackageTreePanel.Name.display"));

        // 添加远端流程列表的根节点
        remoteProcessRootNode = new DefaultMutableTreeNode(ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Name.display"));

        // 登录后，才添加远端流程到树列表
        if (BPD.getInstance().isLogined()) {
            // 添加远端流程


            Map<String, CApplication> appMap = AppConfigManager.getInstance().getApplicationMap();
            remoteTreeNodeMap.clear();

            for (Iterator<String> it = appMap.keySet().iterator(); it.hasNext(); ) {
                String appCode = it.next();
                CApplication app = appMap.get(appCode);
                if (app != null && app.getBPDProjectConfigMap().size() > 0) {
                    RemoteAppDefNode appDefNode = new RemoteAppDefNode(app, this);
                    remoteProcessRootNode.add(appDefNode);
                }

            }

        }
        root.add(remoteProcessRootNode);
        model.setRoot(root);
        model.nodeStructureChanged(root);
        allItems.setModel(model);
        allItems.setExpandsSelectedPaths(true);

        // 展开远端流程根节点
        // allItems.expandPath(new TreePath(remoteProcessRootNode.getPath()));

        // 如果流程树型列表的缺省设置为有效时，才展开
        if (BPDConfig.getInstance().getJTreeExpandStatus()) {
            // 展开所有远端流程根节点
            if (BPD.getInstance().getActivedProcessEditor() != null) {
                WorkflowProcess wp = (WorkflowProcess) BPD.getInstance().getActivedProcessEditor().getGraph().getPropertyObject();
                String versionId = wp.getMainProcess().getVersionID();
                // String versionId=wp.getVersionID();

                for (Iterator it = remoteTreeNodeMap.keySet().iterator(); it.hasNext(); ) {
                    Object obj = it.next();

                    if (obj instanceof RemoteProcessDefVersionNode) {
                        RemoteProcessDefVersionNode versionNode = (RemoteProcessDefVersionNode) obj;
                        if (versionId.equals(remoteTreeNodeMap.get(versionNode))) {
                            allItems.setSelectionPath(new TreePath(versionNode.getPath()));

                        }
                    }
                }
            } else {

                for (Iterator it = remoteTreeNodeMap.keySet().iterator(); it.hasNext(); ) {
                    Object obj = it.next();
                    if (obj instanceof RemoteProcessDefVersionNode) {
                        RemoteProcessDefVersionNode versionNode = (RemoteProcessDefVersionNode) obj;
                        allItems.expandPath(new TreePath(((DefaultMutableTreeNode) versionNode.getParent().getParent()).getPath()));
                    }
                }
            }

        }
        allItems.updateUI();
    }

    public Map<DefaultMutableTreeNode, String> getLocalTreeNodeMap() {
        return localTreeNodeMap;
    }

    public void setLocalTreeNodeMap(Map<DefaultMutableTreeNode, String> localTreeNodeMap) {
        this.localTreeNodeMap = localTreeNodeMap;
    }

    public Map<DefaultMutableTreeNode, String> getRemoteTreeNodeMap() {
        return remoteTreeNodeMap;
    }

    public void setRemoteTreeNodeMap(Map<DefaultMutableTreeNode, String> remoteTreeNodeMap) {
        this.remoteTreeNodeMap = remoteTreeNodeMap;
    }

    /**
     * add by wenzhang 列表显示子流程(本地子流程)
     *
     * @param wp
     * @param localProcessNode
     * @return
     */

    public DefaultMutableTreeNode addChildProcess(WorkflowProcess wp, DefaultMutableTreeNode localProcessNode, String path) {

        String subVersion = null;
        String subName = null;
        String subLpVersionId = "1";
        List subList = wp.getSubProcessList();

        for (int i = 0; subList.size() > i; i++) {
            WorkflowProcess subWP = (WorkflowProcess) subList.get(i);
            if (subWP == null || !subWP.getID().equals(wp.getID())) {
                continue;
            }
            if (subWP.getVersionNumber() != null) {
                subVersion = subWP.getVersionNumber();
            }
            subName = (String) subWP.get("Name").toValue();

            subLpVersionId = subWP.getVersionID();

            DefaultMutableTreeNode childLocalProcessNode = new DefaultMutableTreeNode(subName + "(" + ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessVersionNode.Name.display") + "." + subVersion + ")");
            if (localProcessNode != null) {
                localProcessNode.add(childLocalProcessNode);
            } else {
                localProcessNode = childLocalProcessNode;
            }
            if (path.equals(BPDConstants.PROCESS_LOCAL)) {

                localTreeNodeMap.put(childLocalProcessNode, subLpVersionId);
            } else {
                remoteTreeNodeMap.put(childLocalProcessNode, subLpVersionId);
            }

            addChildProcess(subWP, childLocalProcessNode, path);
        }
        return localProcessNode;
    }

    /**
     * 得到JTree树对象
     *
     * @return
     */
    public JTree getTree() {
        JScrollPane jsp = (JScrollPane) getComponent(0);
        JViewport jvp = (JViewport) jsp.getComponent(0);
        JTree jt = (JTree) jvp.getComponent(0);
        return jt;
    }

    /**
     * 设置树列表标题
     *
     * @param title
     * @param hasBorder
     */
    public void setTitle(String title, boolean hasBorder) {
        int emptyBorderHSize = 5;
        int emptyBorderVSize = 5;
        Border emptyb = BorderFactory.createEmptyBorder(emptyBorderVSize, emptyBorderHSize, emptyBorderVSize, emptyBorderHSize);
        Border inb = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        if (hasBorder) {
            inb = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray);
            inb = BorderFactory.createTitledBorder(inb, title, TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, BPDConfig.getInstance().getFont());
        } else {
            emptyb = BorderFactory.createTitledBorder(emptyb, title, TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, BPDConfig.getInstance().getFont());
        }
        setBorder(BorderFactory.createCompoundBorder(emptyb, inb));
    }


    // 切换语言时刷新流程列表
    public void refreshWorkflowTree() {
        refreshTreeModel();
    }

    /**
     * 创建应用属性右键菜单
     *
     * @param node
     * @return
     */
    private JPopupMenu createClassificationMenu(DefaultMutableTreeNode node) {
        JPopupMenu menu = new JPopupMenu();
        selectedNode = node;

        // 应用属性
        JMenuItem appItem = new JMenuItem("配置应用");
        URL url = ResourceManager.getResource("OpenRemoteImage");
        if (url != null) {
            appItem.setIcon(new ImageIcon(url));
        }
        appItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                BPDProjectConfig classification = (BPDProjectConfig) selectedNode.getUserObject();
                ApplicationPanel panel = new ApplicationPanel(classification.getSysId(), classification.getCode());
                XMLPanel p;
                XMLElementDialog d;
                PackageEditor pe = (PackageEditor) BPD.getInstance().getPackageEditor();
                d = new XMLElementDialog((JFrame) pe.getWindow(), "配置应用[" + classification.getName() + "]应用");

                d.editXMLElement(panel.getPanel(), false, false);

            }
        });
        menu.add(appItem);
        // 新建版本
        JMenuItem newItem = new JMenuItem("新建流程");
        url = ResourceManager.getResource("CreateVersionImage");
        if (url != null) {
            newItem.setIcon(new ImageIcon(url));
        }
        newItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                BPDProjectConfig classification = (BPDProjectConfig) selectedNode.getUserObject();
                New newAction = new New(BPD.getInstance().getPackageEditor(), classification.getSysId(), classification.getCode());
                newAction.actionPerformed(ae);
            }
        });

        menu.add(newItem);

        return menu;
    }

    /**
     * 创建应用属性右键菜单
     *
     * @param node
     * @return
     */
    private JPopupMenu createAppMenu(DefaultMutableTreeNode node) {
        JPopupMenu menu = new JPopupMenu();
        selectedNode = node;

        // 应用属性
        JMenuItem appItem = new JMenuItem("系统信息");
        URL url = ResourceManager.getResource("OpenRemoteImage");
        if (url != null) {
            appItem.setIcon(new ImageIcon(url));
        }
        appItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                openFlow(selectedNode);
            }
        });
        menu.add(appItem);
        return menu;
    }

    /**
     * 创建流程树右键菜单
     *
     * @param node
     * @return
     */
    private JPopupMenu createRightMenu(DefaultMutableTreeNode node) {

        if (node instanceof RemoteClassificationDefNode) {
            // return null;
            return this.createClassificationMenu(node);
        }
        if (node instanceof RemoteAppDefNode) {
            // return null;
            return this.createAppMenu(node);
        }

        JPopupMenu menu = new JPopupMenu();
        selectedNode = node;
        // 控制是否打开
        boolean isOpen = true;
        // 控制是否删除
        boolean isDel = false;
        // 控制是否新建版本
        boolean isNew = false;
        // 控制是否激活版本
        boolean isActive = false;
        // 控制是否冻结版本
        boolean isFreezed = false;
        // node=(RemoteProcessDefNode) this.remoteProcessProcessDef.get(node);
        if (node instanceof RemoteProcessDefNode) {
            isOpen = true;
            isDel = true;
            isNew = true;
        } else if (node instanceof RemoteProcessDefVersionNode) {
            isNew = true;
            isOpen = true;
            isDel = true;
            RemoteProcessDefVersionNode versionNode = (RemoteProcessDefVersionNode) node;
            ProcessDefVersion processDefVersion = versionNode.getProcessDefVersion();
            if (processDefVersion.getPublicationStatus().equals(ProcessDefVersionStatus.RELEASED)) {
                isFreezed = true;
            } else {
                isActive = true;
            }
        }
        if (node instanceof DefaultMutableTreeNode) {
            isOpen = true;
            isDel = true;
            isNew = true;
        }
        // 打开流程
        JMenuItem openItem = new JMenuItem(ResourceManager.getLanguageDependentString("RemoteProcessList.OpenButton.Name.display"));
        URL url = ResourceManager.getResource("OpenRemoteImage");
        if (url != null) {
            openItem.setIcon(new ImageIcon(url));
        }
        openItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                openFlow(selectedNode);
            }
        });
        openItem.setEnabled(isOpen);
        menu.add(openItem);
        // 新建版本
        JMenuItem newItem = new JMenuItem(ResourceManager.getLanguageDependentString("RemoteProcessVersionList.CreateVersionButton.Name.display"));
        url = ResourceManager.getResource("CreateVersionImage");
        if (url != null) {
            newItem.setIcon(new ImageIcon(url));
        }
        newItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                createVersion(selectedNode);
            }
        });
        newItem.setEnabled(isNew);
        menu.add(newItem);
        // 激活版本
        JMenuItem activeItem = new JMenuItem(ResourceManager.getLanguageDependentString("RemoteProcessVersionList.ActivateVersionButton.Name.display"));
        url = ResourceManager.getResource("ActivateVersionImage");
        if (url != null) {
            activeItem.setIcon(new ImageIcon(url));
        }
        activeItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                activeFlow(selectedNode);
            }
        });
        activeItem.setEnabled(isActive);
        menu.add(activeItem);
        // 冻结版本
        JMenuItem freezeItem = new JMenuItem(ResourceManager.getLanguageDependentString("RemoteProcessVersionList.FreezeVersionButton.Name.display"));
        url = ResourceManager.getResource("FreezeVersionImage");
        if (url != null) {
            freezeItem.setIcon(new ImageIcon(url));
        }
        freezeItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                freezeVersion(selectedNode);
            }
        });
        freezeItem.setEnabled(isFreezed);
        menu.add(freezeItem);
        // 删除流程
        JMenuItem delItem = new JMenuItem(ResourceManager.getLanguageDependentString("RemoteProcessList.DeleteRemoteButton.Name.display"));
        url = ResourceManager.getResource("DeleteRemoteImage");
        if (url != null) {
            delItem.setIcon(new ImageIcon(url));
        }
        delItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                deleteFlow(selectedNode);
            }
        });
        delItem.setEnabled(isDel);
        menu.add(delItem);
        return menu;
    }

    /**
     * 打开流程
     *
     * @param node
     */
    private void openFlow(DefaultMutableTreeNode node) {
        String versionId = null;
        if (localTreeNodeMap.containsKey(node)) {
            // 如果选择流程节点是本地流程，则从本地打开流程集合中获得流程编辑对象
            versionId = (String) localTreeNodeMap.get(node);
            // 当点击选择的流程没有打开时，才重新打开一个编辑页
            if (versionId != null) {
                String xpdlFilePath = (String) BPD.getInstance().getXpdlFilePathMap().get(versionId);
                Map wpMap = BPD.getInstance().getWorkflowProcessMap();
                if (!wpMap.containsKey(versionId)) {
                    BPD.getInstance().checkNameAndOpenDocumentIfPossible(xpdlFilePath);
                }
                BPD.getInstance().openWorkflow(versionId);
            }
        } else if (remoteTreeNodeMap.containsKey(node)) {
            // 如果选择流程节点是远端流程，则从远端打开流程集合中获得流程编辑对象

            versionId = (String) remoteTreeNodeMap.get(node);
            if (BPD.getInstance().getRomveWorkflowProcessMap().containsKey(versionId)) {
                BPD.getInstance().openRomveWorkflow(versionId);
            } else {
                // 当点击选择的流程没有打开时，才重新打开一个编辑页
                if (versionId != null && BPD.getInstance().isProcessOpenedAfresh(BPDConstants.PROCESS_REMOTE, versionId)) {
                    OpenProcessTask task = new OpenProcessTask(versionId);


                    SwingUtilities.invokeLater(new Runnable() {

                        public void run() {
                            String progressTitle = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Title.Name.display");
                            String progressDescription = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Description.Name.display");
                            String progressMessage = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.Name.display");

                            if (BPD.getInstance().getMainFrame() != null) {
                                try {
                                    ProgressDialog progressDialog = new ProgressDialog(BPD.getInstance().getMainFrame(), progressTitle, progressDescription, progressMessage, task, 0, false);
                                    progressDialog.dispose();
                                } catch (Throwable e) {

                                }

                            }

                        }
                    });
                    task.go();
                }
            }
        }
    }

    /**
     * 删除流程或流程某个版本
     *
     * @param node
     */
    private void deleteFlow(DefaultMutableTreeNode node) {
        int dialogFlag;
        String versionIdsString = "";
        ProcessDefVersion processDefVersion;
        if (node instanceof RemoteProcessDefNode) {
            // 删除整个流程，包括所有版本
            dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsDeleteProcessDef"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
            if (dialogFlag == JOptionPane.NO_OPTION) {
                return;
            } else {
                RemoteProcessDefNode processDefNode = (RemoteProcessDefNode) node;
                ProcessDef processDef = processDefNode.getProcessDef();
                List<ProcessDefVersion> versionInfoList = new ArrayList<ProcessDefVersion>();
                try {
                    versionInfoList = processDef.getAllProcessDefVersions();
                } catch (BPMException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                for (int i = 0; i < versionInfoList.size(); i++) {
                    // 获得版本ID字符串，以逗号分割
                    processDefVersion = (ProcessDefVersion) versionInfoList.get(i);
                    if (i != 0) {
                        versionIdsString += ",";
                    }
                    versionIdsString += processDefVersion.getProcessDefVersionId();
                }
            }
        } else {
            // 删除选择的流程版本
            dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsDeleteProcessDefVersion"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
            if (dialogFlag == JOptionPane.NO_OPTION) {
                return;
            } else {
                RemoteProcessDefVersionNode processDefVersionNode = (RemoteProcessDefVersionNode) node;
                processDefVersion = processDefVersionNode.getProcessDefVersion();
                versionIdsString = processDefVersion.getProcessDefVersionId();
            }

        }
        ProcessEditor remoteProcessEditor = (ProcessEditor) BPD.getInstance().getRemoteEditingProcessMap().get(versionIdsString);

        if (remoteProcessEditor != null && remoteProcessEditor.equals(BPD.getInstance().getActivedProcessEditor())) {
            Close closeAction = new Close(BPD.getInstance().getPackageEditor());
            closeAction.delplan();
        }

        if (!versionIdsString.equals("")) {
            // 从WebService服务器删除选择的流程或流程版本

            boolean deleteSuccessFlag = false;

            try {
                deleteSuccessFlag = BPD.getInstance().getBPDService().deleteProcessDefListToDB(versionIdsString);
                // 删除操作成功
                if (deleteSuccessFlag) {
                    // 从远端服务器后，缓存重新获得远程流程定义列表
                    BPD.getInstance().setRemoteProcessMap(BPD.getInstance().getRemoteProcessDefList(true));
                    // 刷新流程树列表
                    refreshPackageTreePanel();
                    JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageDeleteProcessDefVersionSuccess"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
                }
            } catch (JDSException e) {
                BPD.getInstance().getBPDService().handleWebServiceException(e);
            }
        }
        // 删除所选项后，刷新版本面板
        node.removeFromParent();

    }

    /**
     * 激活流程某个版本
     *
     * @param node
     */
    private void activeFlow(DefaultMutableTreeNode node) {
        int dialogFlag;
        String versionId = "";
        // 激活选择的流程版本
        dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsActivateProcessDefVersion"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
        if (dialogFlag == JOptionPane.NO_OPTION || dialogFlag == JOptionPane.CLOSED_OPTION) {
            return;
        } else {
            if (node instanceof RemoteProcessDefVersionNode) {
                RemoteProcessDefVersionNode processDefVersionNode = (RemoteProcessDefVersionNode) node;
                ProcessDefVersion selProcessDefVersion = processDefVersionNode.getProcessDefVersion();
                // 选择了已经激活的版本
                if (selProcessDefVersion.getPublicationStatus().equals(ProcessDefVersionStatus.RELEASED)) {
                    return;
                }
                versionId = selProcessDefVersion.getProcessDefVersionId();
                if (!versionId.equals("")) {
                    // 从WebService服务器激活选择的流程版本

                    boolean activateSuccessFlag = false;

                    try {
                        activateSuccessFlag = BPD.getInstance().getBPDService().activateProcessDefVersion(versionId);
                        // 激活操作成功
                        // if (activateSuccessFlag==null activateSuccessFlag) {
                        // 重新获得流程信息
                        List<ProcessDef> processInfoList = BPD.getInstance().getRemoteProcessDefList(true);
                        BPD.getInstance().setRemoteProcessMap(processInfoList);
                        // 刷新已经打开的流程
                        BPD.getInstance().refreshOpenedWorkflowProcess();
                        // 刷新流程树列表
                        MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel().refreshPackageTreePanel();
                        BPD.getInstance().getPackageEditor().valueChanged(null);

                        // 激活成功标志
                        JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageActivateProcessDefVersionSuccess"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
                        // }
                    } catch (JDSException e) {
                        BPD.getInstance().getBPDService().handleWebServiceException(e);
                    }
                }
            }
        }
    }

    /**
     * 冻结某个版本
     *
     * @param node
     */
    private void freezeVersion(DefaultMutableTreeNode node) {
        int dialogFlag;
        String versionId = "";
        // 冻结选择的流程版本
        dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsFreezeProcessDefVersion"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
        if (dialogFlag == JOptionPane.NO_OPTION) {
            return;
        } else {
            if (node instanceof RemoteProcessDefVersionNode) {
                RemoteProcessDefVersionNode processDefVersionNode = (RemoteProcessDefVersionNode) node;
                ProcessDefVersion selProcessDefVersion = processDefVersionNode.getProcessDefVersion();
                versionId = selProcessDefVersion.getProcessDefVersionId();
                if (!versionId.equals("")) {
                    // 从WebService服务器冻结选择的流程版本

                    boolean freezeSuccessFlag = false;

                    try {
                        freezeSuccessFlag = BPD.getInstance().getBPDService().freezeProcessDefVersion(versionId);
                        // 冻结操作成功
                        // if (freezeSuccessFlag) {
                        // 重新获得流程信息
                        List<ProcessDef> processInfoVector = BPD.getInstance().getRemoteProcessDefList(true);
                        BPD.getInstance().setRemoteProcessMap(processInfoVector);
                        // 刷新已经打开的流程
                        BPD.getInstance().refreshOpenedWorkflowProcess();
                        // 刷新流程树列表

                        MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getPackageTreePanel().refreshPackageTreePanel();

                        MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel().refreshPackageTreePanel();
                        BPD.getInstance().getPackageEditor().valueChanged(null);

                        // 冻结成功标志
                        JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageFreezeProcessDefVersionSuccess"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
                        // }
                    } catch (JDSException e) {
                        BPD.getInstance().getBPDService().handleWebServiceException(e);
                    }
                }
            }
        }
    }

    /**
     * 新建流程版本
     *
     * @param node
     */
    private void createVersion(DefaultMutableTreeNode node) {
        // 获得当前选择的流程对象
        RemoteProcessDefNode processDefNode = null;
        if (node instanceof RemoteProcessDefVersionNode) {
            processDefNode = (RemoteProcessDefNode) node.getParent();
        } else {
            processDefNode = (RemoteProcessDefNode) node;
        }
        ProcessDef processDef = processDefNode.getProcessDef();
        if (processDef != null) {
            // 设置流程新版本的初始值
            int maxVersionId = 0;
            // 获得当前流程的最大版本号和最大版本号的流程信息
            List<ProcessDefVersion> versionInfoList = new ArrayList<ProcessDefVersion>();
            try {
                versionInfoList = processDef.getAllProcessDefVersions();
            } catch (BPMException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            String maxRemoteVersionId = "";
            if (versionInfoList != null && versionInfoList.size() != 0) {
                for (ProcessDefVersion processDefVersion : versionInfoList) {

                    int version = processDefVersion.getVersion();
                    if (version > maxVersionId) {
                        maxVersionId = version;
                        maxRemoteVersionId = processDefVersion.getProcessDefVersionId();
                    }
                }
            }
            // 从服务器获取流程的进程
            CreateVersionTask task = new CreateVersionTask(maxRemoteVersionId);
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    String progressTitle = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Title.Name.display");
                    String progressDescription = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Description.Name.display");
                    String progressMessage = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.Name.display");
                    ProgressDialog progressDialog = new ProgressDialog((JFrame) BPD.getInstance().getPackageEditor().getWindow(), progressTitle, progressDescription, progressMessage, task, 0, false);
                    progressDialog.dispose();
                }
            });
            task.go();
        }
    }


    public PackageEditor getPackageEditor() {
        return packageEditor;
    }
}
