package com.ds.bpm.bpd.misc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.tree.TreeNode;

import com.ds.org.Org;
import com.ds.org.Person;

/**
 * <p>
 * Title: JDSORG缁勭粐鏈烘瀯涓棿浠?
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: jds Copyright (c) 2003-2008
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @author wenzhangli
 * @version 2.0
 */
public class OrgTree {
    public static final String ALL_PERSON = "=all=";
    private boolean enableAllPerson = true;
    // 鏄惁缁勭粐鏁扮粍瀹屽
    private boolean orgComplete = false;

    private TreeNode root;

    public OrgTree(Person[] persons) {
	Map orgMap = new HashMap();
	for (int i = 0; i < persons.length; i++) {
	    Org[] orgs = (Org[]) persons[i].getOrgList().toArray();
	    if (orgs != null) {
		for (int j = 0; j < orgs.length; j++) {
		    if (!orgMap.containsKey(orgs[j].getOrgId()))
			addOrg(orgMap, orgs[j]);
		}
	    }
	}

	Org[] orgs = (Org[]) orgMap.values().toArray(new Org[0]);
	Map map = new HashMap();
	root = new OrgTreeNode();
	for (int i = 0; i < orgs.length; i++) {
	    Org org = orgs[i];
	    map.put(org.getOrgId(), new OrgTreeNode(org));
	}
	for (int i = 0; i < orgs.length; i++) {
	    Org org = orgs[i];
	    if (org != null) {
		OrgTreeNode node = (OrgTreeNode) map.get(org.getOrgId());
		if (org.getParent() == null) {
		    insertNodeInto(node, (OrgTreeNode) root);
		} else {
		    insertNodeInto(node, (OrgTreeNode) map.get(org.getParent().getOrgId()));
		}
	    }
	}
    }

    /**
     * @param map
     * @param person
     */
    private void addOrg(Map map, Org org) {
	if (org != null) {
	    map.put(org.getOrgId(), org);
	    Org parent = org.getParent();
	    if (parent != null && !map.containsKey(parent.getOrgId()))
		addOrg(map, parent);
	}
    }

    /**
     * @param orgs
     */
    public OrgTree(List<Org> orgs) {
	Map map = new HashMap();
	root = new OrgTreeNode();

	for (Org org : orgs) {

	    map.put(org.getOrgId(), new OrgTreeNode(org));
	}

	for (Org org : orgs) {
	    if (org != null) {
		OrgTreeNode node = (OrgTreeNode) map.get(org.getOrgId());
		if (node.getParent() == null) {
		    insertNodeInto(node, (OrgTreeNode) root);
		} else {
		    insertNodeInto(node, (OrgTreeNode) map.get(org.getParent().getOrgId()));
		}

		// Person[] persons = org.getPersons();
		// for (int j = 0; j < persons.length; j++) {
		// Person person = persons[j];
		// insertNodeInto(new OrgTreeNode(person), node);
		// }
	    }
	}
    }

    /**
     * 
     * @param parent
     * @param index
     * @return
     */
    public TreeNode getChild(TreeNode parent, int index) {
	return ((TreeNode) parent).getChildAt(index);
    }

    /**
     * 鍙栧緱鏌愯妭鐐圭殑鎵?鏈夊瓙鑺傜偣
     */
    public Enumeration getChildren(TreeNode parent) {
	return parent.children();
    }

    /**
     * 鍙栧緱鏌愯妭鐐圭殑瀛愯妭鐐规暟
     * 
     * @param parent
     * @return
     */
    public int getChildCount(TreeNode parent) {
	return parent.getChildCount();
    }

    /**
     * 鍒ゆ柇鏌愯妭鐐规槸鍚︽槸鍙跺瓙鑺傜偣銆?
     * 
     * @param node
     * @return
     */
    public boolean isLeaf(TreeNode node) {
	return node.isLeaf();
    }

    /**
     * 灏嗘煇涓妭鐐规彃鍏ュ埌鏌愪釜鐖惰妭鐐圭殑鎸囧畾浣嶇疆涓嬨??
     * 
     * @param newChild
     * @param parent
     * @param index
     */
    public void insertNodeInto(OrgTreeNode newChild, OrgTreeNode parent, int index) {
	if (newChild == null) {
	    throw new IllegalArgumentException("new child is null");
	}
	if (parent == null) {
	    throw new IllegalArgumentException("parent is null");
	}

	parent.insert(newChild, index);
    }

    /**
     * 灏嗘煇涓妭鐐规坊鍔犲埌鏌愪釜鐖惰妭鐐圭殑涓嬶紝浣嶇疆涓烘墍鏈夊瓙鑺傜偣鐨勬渶鍚庛??
     * 
     * @param newChild
     * @param parent
     */
    public void insertNodeInto(OrgTreeNode newChild, OrgTreeNode parent) {
	if (newChild == null) {
	    throw new IllegalArgumentException("new child is null");
	}
	if (parent == null) {
	    throw new IllegalArgumentException("parent is null");
	}

	parent.insert(newChild);
    }

    /**
     * 灏嗘煇涓妭鐐逛粠浠栫殑鐖惰妭鐐逛笂鍒犻櫎
     * 
     * @param node
     */
    public void removeNodeFromParent(OrgTreeNode node) {
	OrgTreeNode parent = (OrgTreeNode) node.getParent();
	if (parent == null)
	    throw new IllegalArgumentException("node does not have a parent.");

	parent.remove(node);
    }

    /**
     * 鍙栧緱璇ユ爲鐨勬牴鑺傜偣
     */
    public TreeNode getRoot() {
	return root;
    }

    /**
     * @param root
     *            The root to set.
     */
    public void setRoot(TreeNode root) {
	this.root = root;
    }

}
