/* BlockActivityGraph.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：跳转活动JGraph图形类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.util.Iterator;
import java.util.Set;

import org.jgraph.graph.GraphModel;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ProcessGraph;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.PackageValidator;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ActivitySet;
import com.ds.bpm.bpd.xml.elements.ActivitySets;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * Implementation of block activity graph.
 */
public class BlockActivityGraph extends ProcessGraph {

	private BlockActivity myBlockActivity;

	/**
	 * Written only to override original method. Newer supposed to be created
	 * this way.
	 */
	public BlockActivityGraph(AbstractEditor packageEditor,
			BlockActivityEditor pe) {
		super((GraphModel) null, null, packageEditor, pe);
	}

	/**
	 * Constructs block activity graph based on a given model.
	 */
	public BlockActivityGraph(GraphModel model, AbstractEditor packageEditor,
			BlockActivityEditor pe) {
		super(model, packageEditor, pe);
	}

	public void setMyBlockActivity(BlockActivity ba) {
		myBlockActivity = ba;
	}

	public BlockActivity getMyBlockActivity() {
		return myBlockActivity;
	}

	protected void updateXMLObjectsBeforeChecking() {
		// first update extended attributes for start and end for all block
		// activities
		Set blockActs = getWorkflowManager().getBlockActivities(true);
		// add its block activity
		blockActs.add(myBlockActivity);
		Iterator itBas = blockActs.iterator();
		while (itBas.hasNext()) {
			BlockActivity ba = (BlockActivity) itBas.next();
			ProcessEditor bwe = ba.getImplementationEditor();
			com.ds.bpm.bpd.xml.activity.Activity bap = (com.ds.bpm.bpd.xml.activity.Activity) ba
					.getUserObject();
			bap.setStartDescriptions(Utils.getStartDescriptions(bwe));
			bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
		}
	}

	public boolean checkLogic(boolean fullCheck) {
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, false);
		boolean isLogical = pv.checkActivitySet((ActivitySet) getXPDLObject(),
				fullCheck);
		basicLogicError = pv.getBasicLogicError((ActivitySet) getXPDLObject());
		logicErrors = pv.getLogicErrors((ActivitySet) getXPDLObject());
		return isLogical;
	}

	/**
	 * Gets an XPDL object (DTDElement).
	 */
	public XMLElement getXPDLObject() {
		try {
			String ID = myBlockActivity.getBlockID();
			ActivitySet as = ((ActivitySets) ((WorkflowProcess) xmlObject)
					.get("ActivitySets")).getActivitySet(ID);
			return as;
		} catch (Exception ex) {
			return null;
		}
	}

}

/* End of BlockActivityGraph.java */
