/* BlockActivity.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：跳转活动图形实现类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Point;
import java.awt.Window;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDMarqueeHandler;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ProcessGraph;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowManager;

/**
 * Used to define BlockActivity object in process and to modify it's properties.
 */
public class BlockActivity extends Activity {

    protected transient PackageEditor pEditor;

    /**
     * Reference to block activity editor that will be created the first time showBlockActivity method is called.
     */
    protected transient BlockActivityEditor baEditor = null;

    /**
     * Creates block activity.
     */
    public BlockActivity(PackageEditor pEd) {
	this(null, pEd);
    }

    /**
     * Creates block activity with given userObject.
     */
    public BlockActivity(Object userObject, PackageEditor pEd) {
	super(userObject);
	this.pEditor = pEd;
    }

    public ProcessEditor getImplementationEditor() {
	return baEditor;
    }

    public String getBlockID() {

	String blockID = ((com.ds.bpm.bpd.xml.activity.Activity) userObject).getBlockActivity().get("Id").toString();
	return blockID;
    }

    /**
     * Shows a block activity editor with it's toolbar.
     */
    public void showBlockActivity() {
	String baTitle = ResourceManager.getLanguageDependentString("ProcessKey") + "-'" + toString() + "'";
	if (baEditor == null) {
	    com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = ((com.ds.bpm.bpd.xml.activity.Activity) userObject).getOwnerProcess();
	    baEditor = new BlockActivityEditor(wp, this, pEditor);
	    ProcessGraph processGraph = (ProcessGraph) baEditor.getGraph();
	    processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));
	    // 创建缺省的画图背景
	    processGraph.getWorkflowManager().insertParticipantAndArrangeParticipants(new Point(processGraph.getX(), processGraph.getY()), null);
	    BPD.getInstance().setActivedProcessEditor(baEditor);
	    pEditor.addProcessToTabbedPane(baTitle, baEditor);
	    baEditor.getStatusBar().updateMessage();
	} else {
	    // check xpdl object to prevent crashing if this is an invalid
	    // block activity without defined activity set
	    if (baEditor.getGraph().getXPDLObject() != null) {
		ProcessGraph processGraph = (ProcessGraph) baEditor.getGraph();
		processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));
		BPD.getInstance().setActivedProcessEditor(baEditor);
		pEditor.addProcessToTabbedPane(baTitle, baEditor);
		baEditor.getStatusBar().updateMessage();

	    }
	    // JPanel jpanel=BPD.getInstance().getErrTablePanel().getTablePanel();
	    // BPD.getInstance().getPackageEditor().errPanel=jpanel;
	    // BPD.getInstance().getPackageEditor().graphMainsplitPane.setBottomComponent(jpanel);
	}
    }

    public void createBlockActivityGraph(Window parentWindow) {
	// create new editor
	com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = ((com.ds.bpm.bpd.xml.activity.Activity) userObject).getOwnerProcess();
	baEditor = new BlockActivityEditor(wp, this, pEditor);
	baEditor.getGraph().createWorkflowGraph(parentWindow);
    }

    public WorkflowManager getWorkflowManager() {
	try {
	    return baEditor.getGraph().getWorkflowManager();
	} catch (Exception ex) {
	    return null;
	}
    }

    public AbstractEditor getParentEditor() {
	return pEditor;
    }

}
