package com.ds.bpm.bpd.enums;

import com.ds.bpm.enums.activitydef.deivce.ActivityDefDeviceAtt;
import com.ds.bpm.enums.command.CommandEventDeadLine;
import com.ds.bpm.enums.command.CommandExecType;
import com.ds.enums.CommonYesNoEnum;
import com.ds.enums.DurationUnit;
import com.ds.enums.Enumstype;
import com.ds.enums.attribute.AttributeName;

public enum ActivityCommandEnums implements AttributeName {
    
    
    CanOffLineSend(ActivityDefDeviceAtt.CANOFFLINESEND,  CommonYesNoEnum.class),
  
    CommandTimeOut(ActivityDefDeviceAtt.COMMANDSENDTIMEOUT, null),

    CommandRetryTimes(ActivityDefDeviceAtt.COMMANDRETRYTIMES, null),
    
    CommandDelayTime(ActivityDefDeviceAtt.COMMANDDELAYTIME, null),
    
    CommandExecType(ActivityDefDeviceAtt.COMMANDEXECTYPE, CommandExecType.class),

    CommandReTryType(ActivityDefDeviceAtt.COMMANDRETRY,  CommandEventDeadLine.class),

    DurationUnit(ActivityDefDeviceAtt.DURATIONUNIT, DurationUnit.class);	

    private String name;
    private Class<? extends Enumstype> clazz;
    private String displayName;

    ActivityCommandEnums(ActivityDefDeviceAtt att, Class<? extends Enumstype> clazz) {

	this.name = att.getType();
	this.displayName = att.getName();
	this.clazz = clazz;

    }

    public String getName() {
	return name;
    }

    public void setName(String name) {
	this.name = name;
    }

    public Class<? extends Enumstype> getClazz() {
	return clazz;
    }

    public void setClazz(Class<? extends Enumstype> clazz) {
	this.clazz = clazz;
    }

    public String getDisplayName() {
	return displayName;
    }

    public void setDisplayName(String displayName) {
	this.displayName = displayName;
    }

    @Override
    public String getType() {
	return name;
    }

}
