package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import javax.swing.JOptionPane;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;

import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SaveAsSVG extends ActionBase {

	public SaveAsSVG(AbstractEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		// Create file output stream
		try {
			String file = BPD.getInstance().saveDialog(
					ResourceManager
							.getLanguageDependentString("SaveAsSVGLabel"),
					2,
					BPD.getInstance().getActivedProcessEditor().getGraph().get(
							"Id").toString());
			if (file != null && file.length() > 0) {
				FileOutputStream fos = new FileOutputStream(new File(file));
				// Created writer with UTF-8 encoding
				Writer out = new OutputStreamWriter(fos, "UTF-8");
				// Get a DOMImplementation
				DOMImplementation domImpl = GenericDOMImplementation
						.getDOMImplementation();


				String svgNS = "http://www.w3.org/2000/svg";


				// Create an instance of org.w3c.dom.Document
				Document document = domImpl.createDocument(svgNS, "svg", null);
				// Create an instance of the SVG Generator
				SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
				// Render into the SVG Graphics2D implementation
				AbstractGraph graph = BPD.getInstance()
						.getActivedProcessEditor().getGraph();
				graph.paint(svgGenerator);
				// Use CSS style attribute
				boolean useCSS = true;
				// Finally, stream out SVG to the writer
				//svgGenerator.stream(out, useCSS);
				// Close the file output stream
				fos.flush();
				fos.close();
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			String msg = ResourceManager
					.getLanguageDependentString("ErrorSVGSavingFailed");
			BPD.getInstance().message(msg, JOptionPane.WARNING_MESSAGE);
		}
	}

}
