/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：编辑工作流属性的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.graph.BlockActivityEditor;
import com.ds.bpm.bpd.graph.BlockActivityGraph;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class that realizes <B>process properties</B> action. 流程属性Action类
 */
public class ProcessProperties extends ActionBase {

	public ProcessProperties(AbstractEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		if (BPD.getInstance().getActivedProcessEditor() instanceof BlockActivityEditor) {
			BlockActivityGraph blockActivityGraph = (BlockActivityGraph) BPD
					.getInstance().getActivedProcessEditor().getGraph();
			blockActivityGraph.startEditingAtCell(blockActivityGraph
					.getMyBlockActivity());
		} else {
			com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = (com.ds.bpm.bpd.xml.elements.WorkflowProcess) BPD
					.getInstance().getActivedProcessEditor().getGraph()
					.getPropertyObject();
			XMLPanel p = wp.getPanel();

			XMLElementDialog d = new XMLElementDialog((JFrame) editor
					.getWindow(), ResourceManager
					.getLanguageDependentString("ProcessKey")
					+ " '"
					+ wp.toString()
					+ "' - "
					+ ResourceManager
							.getLanguageDependentString("PropertiesKey"),false);
			d.editXMLElement(p, true, false);
			BPD.getInstance().getActivedProcessEditor().update();
		}
	}
}
