/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：检查工作流正确性的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.graph.BlockActivityEditor;
import com.ds.bpm.bpd.graph.End;
import com.ds.bpm.bpd.graph.Start;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.Participant;
import com.ds.bpm.bpd.xml.elements.Transition;

/**
 * Class that realizes <B>check validity</B> action on given graph.
 */
public class CheckValidity extends ActionBase {

	private static ImageIcon checkOKIcon;

	public CheckValidity(AbstractEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		/*
		 * if (editor instanceof PackageEditor && !((PackageEditor)
		 * editor).isInitialized()) { ((PackageEditor) editor).enterPackageID(); }
		 */
		// check graph connections
		boolean isSchemaValidationError = !BPD.getInstance()
				.getActivedProcessEditor().getGraph()
				.validateAgainsXPDLSchema();
		boolean isConnectionError = !BPD.getInstance()
				.getActivedProcessEditor().getGraph().checkConnections(true);
		boolean isGraphConformanceError = !BPD.getInstance()
				.getActivedProcessEditor().getGraph().checkGraphConformance(
						true);
		boolean isLogicError = !BPD.getInstance().getActivedProcessEditor()
				.getGraph().checkLogic(true);
		boolean isModelOK = !(isSchemaValidationError || isConnectionError
				|| isGraphConformanceError || isLogicError);
		// gets Hashtable with error messages
		Map xpdlSchemaValidationErrors = BPD.getInstance()
				.getActivedProcessEditor().getGraph()
				.getXPDLSchemaValidationErrorMessages();
		Map connectionErrors = BPD.getInstance().getActivedProcessEditor()
				.getGraph().getConnectionErrorMessages();
		List basicGraphConformanceErrors = BPD.getInstance()
				.getActivedProcessEditor().getGraph()
				.getBasicGraphConformanceErrorMessages();
		Map graphConformanceErrors = BPD.getInstance()
				.getActivedProcessEditor().getGraph()
				.getGraphConformanceErrorMessages();
		Map logicErrors = BPD.getInstance().getActivedProcessEditor()
				.getGraph().getLogicErrorMessages();
		// Prints connection error messages contained in a given Hashtable.
		// Hashtable has activity elements as a keys and it's error
		// connection messages as a values.
		String title = ResourceManager
				.getLanguageDependentString("DialogValidationReport");
		URL iconURL = ResourceManager.getResource("CheckOKImage");
		if (iconURL != null)
			checkOKIcon = new ImageIcon(iconURL);

		if (editor.getWindow() instanceof JFrame) {
			if (isModelOK) {
				// If the all elements are properly connected
				JOptionPane
						.showMessageDialog(
								(JFrame) editor.getWindow(),
								ResourceManager
										.getLanguageDependentString("InformationPackageIsValid"),
								title, JOptionPane.INFORMATION_MESSAGE,
								checkOKIcon);
			} else {
				//new FormHTMLDisplay();
//				
//				new ValidationErrorDisplay(xpdlSchemaValidationErrors,
//						connectionErrors, basicGraphConformanceErrors,
//						graphConformanceErrors, logicErrors, (JFrame) editor
//								.getWindow(), title, false);
			}
		} else {
			if (isModelOK) {
				String OKMessage;
				if (BPD.getInstance().getActivedProcessEditor() instanceof BlockActivityEditor) {
					OKMessage = ResourceManager
							.getLanguageDependentString("InformationBlockIsValid");
				} else {
					OKMessage = ResourceManager
							.getLanguageDependentString("InformationProcessIsValid");
				}
				// If the all elements are properly connected
				JOptionPane.showMessageDialog((JDialog) editor.getWindow(),
						OKMessage, title, JOptionPane.INFORMATION_MESSAGE,
						checkOKIcon);
			} else {
				//new FormHTMLDisplay();
//				new ValidationErrorDisplay(xpdlSchemaValidationErrors,
//						connectionErrors, basicGraphConformanceErrors,
//						graphConformanceErrors, logicErrors, (JDialog) editor
//								.getWindow(), title, false);
			}
		}

		if (isModelOK) {
			return;
		}
		// clears the selection
		BPD.getInstance().getActivedProcessEditor().getGraph().clearSelection();
		// selects wrong connected elements.
		Set wc = new HashSet(connectionErrors.keySet());
		wc.addAll(graphConformanceErrors.keySet());
		wc.addAll(logicErrors.keySet());
		// Find graph objects
		WorkflowManager wm = BPD.getInstance().getActivedProcessEditor()
				.getGraph().getWorkflowManager();
		Set graphObjects = new HashSet();
		Iterator it = wc.iterator();
		while (it.hasNext()) {
			Object obj = it.next();
			if (obj instanceof Activity) {
				Object gAct = wm.getActivity(((Activity) obj).getID());
				if (gAct != null) {
					graphObjects.add(gAct);
				}
			} else if ((obj instanceof Start) || (obj instanceof End)) {
				graphObjects.add(obj);
			} else if (obj instanceof Transition) {
				Object gTrans = wm.getTransition(((Transition) obj).getID());
				if (gTrans != null) {
					graphObjects.add(gTrans);
				}
			} else if (obj instanceof Participant) {
				Object gPart = wm.getParticipant(((Participant) obj).getID());
				if (gPart != null) {
					graphObjects.add(gPart);
				}
			}
		}
		BPD.getInstance().getActivedProcessEditor().getGraph()
				.setSelectionCells(graphObjects.toArray());
		BPD.getInstance().getActivedProcessEditor().valueChanged(null);
	}
}
