/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：更换主界面语言的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Set;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.BarFactory;
import com.ds.bpm.bpd.MainLeftDownPanel;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ProcessGraph;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.config.ConfigDialog;
import com.ds.bpm.bpd.ldap.ImportExternalParticipants;
import com.ds.bpm.bpd.misc.PFLocale;

/**
 * Class that realizes <B>change language</B> action.
 */
public class ChangeLanguage extends ActionBase {

	public ChangeLanguage(PackageEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		makeChangeLangDialog();
	}

	private void makeChangeLangDialog() {
		final JList list;
		JFrame frame = (JFrame) editor.getWindow();
		String title = ResourceManager
				.getLanguageDependentString("DialogChangeLanguage");
		final JDialog changeLangDlg = new JDialog(frame, title, true);
		changeLangDlg.setSize(new Dimension(300, 150));
		changeLangDlg.setLocationRelativeTo(frame);
		// Cancel Button
		JButton cancelButton = new JButton(ResourceManager
				.getLanguageDependentString("CancelKey"), new ImageIcon(
				ResourceManager.getResource("CancelImage")));
		// Set Button
		final JButton setButton = new JButton(ResourceManager
				.getLanguageDependentString("SetKey"), new ImageIcon(
				ResourceManager.getResource("OKImage")));
		changeLangDlg.getRootPane().setDefaultButton(setButton);
		// Lay out the buttons from left to right
		JPanel buttonPane = new JPanel();
		// buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
		buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
		buttonPane.add(setButton);
		buttonPane.add(Box.createHorizontalStrut(5));
		// buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
		buttonPane.add(cancelButton);

		java.util.List pfLocales = Utils.findPropertyFiles();
		if (pfLocales.size() == 0) {
			System.err
					.println("Can't find the property files - you have probably"
							+ " started BPD from wrong location");
			return;
		}

		// List
		list = new JList(pfLocales.toArray());

		// Scroll List
		JScrollPane scroll = new JScrollPane(list);
		scroll.setPreferredSize(new Dimension(250, 120));
		scroll.setMinimumSize(new Dimension(250, 120));
		scroll.setAlignmentX(JPanel.LEFT_ALIGNMENT);
		// Label
		JLabel lab = new JLabel(ResourceManager
				.getLanguageDependentString("AvailableLocales"));
		lab.setLabelFor(list);
		// Put it together
		JPanel listPane = new JPanel();
		listPane.setLayout(new BoxLayout(listPane, BoxLayout.Y_AXIS));
		listPane.add(lab);
		listPane.add(Box.createRigidArea(new Dimension(0, 5)));
		listPane.add(scroll);
		listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		// Put everything together
		Container contentPane = changeLangDlg.getContentPane();
		contentPane.add(listPane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.SOUTH);
		changeLangDlg.setResizable(false);
		// Actions for buttons
		cancelButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				changeLangDlg.dispose();
			}
		});
		setButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				Object temp = list.getSelectedValue();
				if (temp != null) {
					PFLocale pfloc = (PFLocale) temp;
					try {
						ResourceManager.setChoosen(pfloc.getLocale());
						// change title
						try {
							editor.setTitle(editor.getWindow(), editor
									.getTitle());
							BPD.getInstance().refreshModel();
							
						} catch (Exception ex) {
						}
						// change statusbar display
						editor.getStatusBar().updateMessage();
						// change language of configuration dialog
						ConfigDialog.getInstance()
								.refreshLanguageDependentStrings();
						// change language of components of PackageEditor
						changeLanguage(editor);
						// Call change language for package tree panel
						changePackageSpecific((PackageEditor) editor);
						// get all process editor and block activity editor
						// instances
						// within current package and all external packages
						// and change the language of it's components
						// changeLanguageForAllEditors();

						// Call change language for labels within all packages
						Iterator it = BPD.getInstance().getXMLInterface().getAllPackages().iterator();
						while (it.hasNext()) {
							((com.ds.bpm.bpd.xml.elements.Package) it
									.next()).refreshLabelName();
						}

					} catch (MissingResourceException mre) {
						String message = ResourceManager
								.getLanguageDependentString("NotFoundKey");
						message = message + ": " + BPDConstants.RESOURCE_PATH;
						message += pfloc.getLocaleString();
						message = message + ".properties";

						JOptionPane.showMessageDialog(editor.getWindow(),
								message, BPD.getAppTitle(),
								JOptionPane.ERROR_MESSAGE);
					}

					changeLangDlg.dispose();

				} else {
					JOptionPane
							.showMessageDialog(
									editor.getWindow(),
									ResourceManager
											.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
									BPD.getAppTitle(),
									JOptionPane.WARNING_MESSAGE);
				}
			}
		});
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		list.addMouseListener(new MouseAdapter() {

			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() == 2) {
					setButton.doClick();
				}
			}
		});

		changeLangDlg.getRootPane().getInputMap(
				JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false), "Cancel");
		changeLangDlg.getRootPane().getActionMap().put("Cancel",
				new AbstractAction() {

					public void actionPerformed(ActionEvent e) {
						changeLangDlg.dispose();
					}
				});
		Utils.center(changeLangDlg, 100, 100);

		changeLangDlg.show();
	}

	/** Changes the language and Locale of all process editors */
	private void changeLanguageForAllEditors() {
		// collect all process objects in the package (and all process
		// objects from external packages)
		// Iterator
		// pkgGraphs=((PackageEditor)editor).getPkgIdToGraphMap().values().iterator();
		Set wObjects = new HashSet();
		/*
		 * while (pkgGraphs.hasNext()) { PackageGraph
		 * peg=(PackageGraph)pkgGraphs.next(); Set
		 * ws=BPDGraphModel.getAllActivitiesInModel(peg.getModel()); if
		 * (ws!=null) { wObjects.addAll(ws); } }
		 */

		int count = editor.getContentTabbedPane().getTabCount();
		for (int i = 0; i < count; i++) {
			wObjects.add((ProcessEditor) editor.getContentTabbedPane()
					.getComponentAt(i));
		}

		// collect all block activity objects in the model (and all block
		// activity objects from external models), and call change language
		// on editors
		Iterator wObjs = wObjects.iterator();
		Set baObjects = new HashSet();
		while (wObjs.hasNext()) {
			// com.ds.bpm.bpd.graph.Process
			// pr=(com.ds.bpm.bpd.graph.Process)wObjs.next();
			ProcessEditor pe = (ProcessEditor) wObjs.next();
			if (pe != null) {
				WorkflowManager wm = ((ProcessGraph) pe.getGraph())
						.getWorkflowManager();
				Set bas = wm.getBlockActivities(true);
				baObjects.addAll(bas);
				// change lang on wEditor
				changeLanguage(pe.getParentEditor());
			}
		}

		// iterate through all block activity objects, get their editors and
		// call change language on them
		Iterator baObjs = baObjects.iterator();
		while (baObjs.hasNext()) {
			com.ds.bpm.bpd.graph.BlockActivity ba = (com.ds.bpm.bpd.graph.BlockActivity) baObjs
					.next();
			ProcessEditor bae = ba.getImplementationEditor();
			if (bae != null) {
				changeLanguage(bae.getParentEditor());
			}
		}
	}

	/** Changes the language and Locale of menubar items */
	private void changeMenuItems(AbstractEditor ed) {
		Iterator iter = ed.getMenuItems().values().iterator();
		while (iter.hasNext()) {
			JMenuItem jmi = (JMenuItem) iter.next();
			jmi.setLocale(ResourceManager.getChoosenLocale());
			jmi.setText(ResourceManager.getLanguageDependentString(jmi
					.getActionCommand()
					+ BPDConstants.LABEL_SUFFIX));
			// change mnemonic
			BarFactory.setMnemonic(jmi, ResourceManager
					.getLanguageDependentString(jmi.getActionCommand()
							+ BPDConstants.MNEMONIC_SUFFIX));
			// change accelerator
			BarFactory.setAccelerator(jmi, ResourceManager
					.getLanguageDependentString(jmi.getActionCommand()
							+ BPDConstants.ACCEL_SUFFIX));
		}
	}

	/** Changes the language and Locale of menubar bar */
	private void changeMenuBar(AbstractEditor ed) {
		MenuElement[] me = ed.getMenubar().getSubElements();
		for (int i = 0; i < me.length; i++) {
			JMenu jm = (JMenu) me[i].getComponent();
			jm.setLocale(ResourceManager.getChoosenLocale());
			jm.setText(ResourceManager.getLanguageDependentString(jm
					.getActionCommand()
					+ BPDConstants.LABEL_SUFFIX));
			// change mnemonic
			BarFactory.setMnemonic(jm, ResourceManager
					.getLanguageDependentString(jm.getActionCommand()
							+ BPDConstants.MNEMONIC_SUFFIX));
		}
	}

	/** Changes the language and Locale of toolbar components */
	private void changeToolbarComponents(AbstractEditor ed) {
		AbstractButton ab = null;
		Iterator iter = ed.getToolbarComponents().values().iterator();
		while (iter.hasNext()) {
			ab = (AbstractButton) iter.next();
			ab.setLocale(ResourceManager.getChoosenLocale());
			ab.setToolTipText(ResourceManager.getLanguageDependentString(ab
					.getActionCommand()
					+ BPDConstants.TIP_SUFFIX));
		}
	}

	/** Changes the language and Locale of tabbed pane items */
	/*
	 * private void changeTabbedPaneItems (AbstractEditor ed) {
	 * ed.getTabbedPane().setLocale(ResourceManager.getChoosenLocale());
	 * String[] toolBars =
	 * Utils.tokenize(ResourceManager.getResourceString(ed.toolbarToLoad()),"
	 * "); for (int i=0; i<toolBars.length; i++) { // if I found "-" it means
	 * that button follows if (!toolBars[i].equals("-")) { try { String nm =
	 * ResourceManager.getLanguageDependentString(toolBars[i]+BPDConstants.LABEL_SUFFIX);
	 * ed.getTabbedPane().setTitleAt(i,nm);
	 * ed.getTabbedPane().setToolTipTextAt(i,nm); } catch (Exception ex) { // } }
	 * else { break; } } }
	 */

	private void changeSpecialButtonGroup(AbstractEditor ed) {
		JComponent c;
		Object[] keys = ed.getSpecialButtonGroup().keySet().toArray();
		for (int i = 0; i < keys.length; i++) {
			c = (JComponent) ed.getSpecialButtonGroup().get(keys[i]);
			c.setLocale(ResourceManager.getChoosenLocale());
			c.setToolTipText(ResourceManager
					.getLanguageDependentString((String) keys[i]
							+ BPDConstants.TIP_SUFFIX));
		}
	}

	private void changeSpecialItems(AbstractEditor ed) {
		JMenuItem mi;
		Object[] keys = ed.getSpecialItems().keySet().toArray();
		for (int i = 0; i < keys.length; i++) {
			mi = (JMenuItem) ed.getSpecialItems().get(keys[i]);
			mi.setLocale(ResourceManager.getChoosenLocale());
			BarFactory.setAccelerator(mi, ResourceManager
					.getLanguageDependentString((String) keys[i]
							+ BPDConstants.ACCEL_SUFFIX));
			BarFactory.setMnemonic(mi, ResourceManager
					.getLanguageDependentString((String) keys[i]
							+ BPDConstants.MNEMONIC_SUFFIX));
		}
	}

	/**
	 * Changes the language and Locale of packagel tree panel and import
	 * external participants components.
	 */
	private void changePackageSpecific(PackageEditor pe) {

		MainLeftDownPanel.getInstance(pe).getPackageTreePanel().setLocale(ResourceManager.getChoosenLocale());
		MainLeftDownPanel.getInstance(pe)
				.getPackageTreePanel()
				.setTitle(
						ResourceManager
								.getLanguageDependentString("PackageTreePanel.Name.display"),
						false);
		MainLeftDownPanel.getInstance(pe).getRemotePackageTreePanel().setLocale(ResourceManager.getChoosenLocale());
		MainLeftDownPanel.getInstance(pe)
		.getRemotePackageTreePanel()
				.setTitle(
						ResourceManager
								.getLanguageDependentString("PackageTreePanel.Name.display"),
						false);
		MainLeftDownPanel.getInstance(pe).getPackageTreePanel().refreshWorkflowTree();
		MainLeftDownPanel.getInstance(pe).getRemotePackageTreePanel().refreshWorkflowTree();
		// catche exception if LDAP dialog wasn't instantiated
		try {
			((ImportExternalParticipants) pe.getAction(Utils
					.getUnqualifiedClassName(ImportExternalParticipants.class)))
					.refreshLabels();
		} catch (Exception ex) {
		}
		com.ds.bpm.bpd.xml.elements.Participant
				.getFreeTextExpressionParticipant()
				.set(
						"Name",
						ResourceManager
								.getLanguageDependentString("FreeTextExpressionParticipantKey"));

		// change the help tutorial and manual
		// BPD.getInstance().initHelpSystem();
	}

	private void changeContentTab(AbstractEditor ed) {
		JTabbedPane ctp = ed.getContentTabbedPane();
		Component[] processEditorArray = (Component[]) ctp.getComponents();
		for (int i = 0; i < processEditorArray.length; i++) {
			((ProcessEditor) processEditorArray[i])
					.refreshEditorConfiguration();
			((ProcessEditor) processEditorArray[i]).update();
		}
	}

	private void changeLanguage(AbstractEditor ed) {
		
	
		// Call change language for menubar items
		changeMenuItems(ed);
		// Call change language for toolbar components
		changeToolbarComponents(ed);
		// Call change language for menubar bar
		changeMenuBar(ed);
		// Call change language for tabbed pane
		// changeTabbedPaneItems(ed);
		// Call change language for special buttons
		changeSpecialButtonGroup(ed);
		// Call change language for special items
		changeSpecialItems(ed);
		// Call change for some specific stuff
		changeContentTab(ed);
	}
	
	public void exit(ActionEvent e) {
		if (BPD.getInstance().close()) {
			try {
				String fileList = "";
				for (int i = BPD.getInstance().getRecentFilesMenu()
						.getItemCount(); i > 0;) {
					JMenuItem mItem = ((JMenuItem) BPD.getInstance()
							.getRecentFilesMenu().getMenuComponent(--i));
					fileList += mItem.getText().substring(2);
					if (i > 0)
						fileList += "\n";
				}
				FileOutputStream fos = new FileOutputStream(
						BPDConstants.BPD_USER_HOME + BPDConstants.RFL_FILENAME);
				fos.write(fileList.getBytes("UTF8"));
				// Write to file
				fos.flush();
				fos.close();
			} catch (Exception ex) {
			}
			System.exit(0);
		}
	}

}
