/* PackageGraph.java
 * 
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：PackageGraph类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import javax.swing.tree.DefaultMutableTreeNode;

import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;

import com.ds.bpm.bpd.actions.Save;
import com.ds.bpm.bpd.graph.Activity;
import com.ds.bpm.bpd.graph.BlockActivity;
import com.ds.bpm.bpd.graph.ProcessView;
import com.ds.bpm.bpd.xml.PackageValidator;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * PackageEditor implementation of JGraph.
 */
public class PackageGraph extends AbstractGraph {

	private static final int processWidth = BPDConfig.getInstance()
			.getProcessWidth();

	private static final int processHeight = BPDConfig.getInstance()
			.getProcessHeight();

	/**
	 * Constructs package graph based on a given model.
	 */
	public PackageGraph(GraphModel model, PackageEditor pe) {
		super(model, pe);
	}

	public PackageGraph(GraphModel model, GraphLayoutCache view,
			PackageEditor pe) {
		super(model, view, pe);
	}

	public com.ds.bpm.bpd.xml.elements.Package getXMLPackage() {
		return (com.ds.bpm.bpd.xml.elements.Package) xmlObject;
	}

	public void setPropertyObject(XMLComplexElement ce) {
		xmlObject = ce;
	}

	/**
	 * Returns the point where will be inserted the next process.
	 */
	public Point getNextInsertionPoint() {
		int hmp;
		try {
			hmp = BPDGraphModel.getAllActivitiesInModel(graphModel).size();
		} catch (Exception ex) {
			hmp = 0;
		}

		return new Point(
				(int) (BPDConstants.PROCESS_OFFSET + processWidth
						* BPDConstants.PROCESS_DISTANCE_COEFF
						* (hmp % BPDConstants.HOW_MANY_PROCESSES_IN_ONE_ROW)),
				(int) (BPDConstants.PROCESS_OFFSET + processHeight
						* BPDConstants.PROCESS_DISTANCE_COEFF
						* ((int) hmp / BPDConstants.HOW_MANY_PROCESSES_IN_ONE_ROW)));
	}

	public void createWorkflowGraph(Window pFrame) {
		com.ds.bpm.bpd.xml.elements.Package p = (com.ds.bpm.bpd.xml.elements.Package) xmlObject;
		com.ds.bpm.bpd.xml.elements.WorkflowProcesses wps = (com.ds.bpm.bpd.xml.elements.WorkflowProcesses) p
				.get("WorkflowProcesses");
		Iterator it = wps.toCollection().iterator();

		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it
					.next();
			createWorkflowObject(pFrame, wp);
			// decrement ID of WPs
			wps.decrementID();
		}
	}

	public void createWorkflowObject(Window pFrame,
			WorkflowProcess wp) {
		com.ds.bpm.bpd.graph.Process pr = workflowManager.insertProcess(
				wp, true);
		pr.setUserObject(wp);
		pr.createWorkflowGraph(pFrame);
		paintImmediately(getBounds());
		((PackageEditor) editor).putProcessObjectMapping(wp, pr);
	}

	/**
	 * Gets a tooltip text for element.
	 */
	public String getTooltip() {
		return "";
	}

	public ProcessEditor getProcessEditor() {
		return null;
	}

	/**
	 * Override Superclass Method to Return Custom vertexView.
	 */
	   protected VertexView createVertexView(JGraph graph,CellMapper cm,Object cell) {//HM, JGraph3.4.1
		if (cell instanceof com.ds.bpm.bpd.graph.Process) {
			return new ProcessView(cell, this, cm);
		} else {
			 return super.createVertexView(graph,cm,cell);//HM, JGraph3.4.1
		}
	}

	/**
	 * Overrides Superclass method.
	 */
	public String convertValueToString(Object value) {
		if (value instanceof CellView) {
			value = ((CellView) value).getCell();
		}
		if (value instanceof com.ds.bpm.bpd.graph.Process
				&& ((DefaultMutableTreeNode) value).getUserObject() != null) {
			return ((DefaultMutableTreeNode) value).getUserObject().toString();
		} else if (value != null) {
			return value.toString();
		}
		return null;
	}

	/**
	 * Overrides <code>JComponent</code>'s <code>getToolTipText</code>
	 * method in order to allow the graph controller to create a tooltip for the
	 * topmost cell under the mousepointer. This differs from JTree where the
	 * renderers tooltip is used.
	 * <p>
	 * NOTE: For <code>JGraph</code> to properly display tooltips of its
	 * renderers, <code>JGraph</code> must be a registered component with the
	 * <code>ToolTipManager</code>. This can be done by invoking
	 * <code>ToolTipManager.sharedInstance().registerComponent(graph)</code>.
	 * This is not done automatically!
	 * 
	 * @param event
	 *            the <code>MouseEvent</code> that initiated the
	 *            <code>ToolTip</code> display
	 * @return a string containing the tooltip or <code>null</code> if
	 *         <code>event</code> is null
	 */
	public String getToolTipText(MouseEvent event) {
		if (event != null) {
			Object cell = getFirstCellForLocation(event.getX(), event.getY());
			if (cell != null) {
				String s = convertValueToString(cell);
				if (cell instanceof WorkflowElement) {
					s = ((WorkflowElement) cell).getTooltip();
				}
				return s;
			}
		}
		return null;
	}

	// 验证流程是否符合XPDLSchema
	public boolean validateAgainsXPDLSchema() {
		com.ds.bpm.bpd.xml.elements.Package pkg = BPD.getInstance()
				.getActivedProcessEditor().getGraph().getXMLPackage();
		Save.updateExtendedAttributesForWorkflowProcesses(pkg);
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, true);
		boolean isValid = pv.validateAgainstXPDLSchema();
		xpdlSchemaValidationErrors = pv.getXPDLSchemaValidationErrors();
		if (!isValid && xpdlSchemaValidationErrors.size() > 0) {
			basicXpdlSchemaValidationError = ResourceManager
					.getLanguageDependentString("MessageThereAreSomeSchemaValidationErrors");
		} else {
			basicXpdlSchemaValidationError = null;
		}
		return isValid;
	}

	// 检查流程连接是否正确
	public boolean checkConnections(boolean fullCheck) {
		updateXMLObjectsBeforeChecking();
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, true);
		boolean areGraphsWellConnected = pv.checkGraphConnections(fullCheck);
		basicGraphConnectionError = pv
				.getBasicGraphConnectionError(getXMLPackage());
		graphConnectionErrors = pv.getGraphsConnectionErrors(getXMLPackage());
		if (fullCheck || areGraphsWellConnected) {
			areGraphsWellConnected = checkStartEndEndsConnections(fullCheck)
					&& areGraphsWellConnected;
		}
		return areGraphsWellConnected;
	}

	protected boolean checkStartEndEndsConnections(boolean fullCheck) {
		boolean wellConnected = true;
		Set activities = BPDGraphModel.getAllActivitiesInModel(graphModel);
		if (activities != null) {
			Iterator it = activities.iterator();
			while (it.hasNext() && (fullCheck || wellConnected)) {
				Activity act = (Activity) it.next();
				ProcessEditor pe = act.getImplementationEditor();
				if (pe != null) {
					WorkflowProcess wp = (WorkflowProcess) act.getUserObject();
					ProcessGraph pg = (ProcessGraph) pe.getGraph();
					if (pg.getImproperlyConnectedStarts(false).size() > 0
							|| pg.getImproperlyConnectedEnds(false).size() > 0) {
						wellConnected = false;
						basicGraphConnectionError = ResourceManager
								.getLanguageDependentString("InformationOneOrMoreProcessesHaveImproperlyConnectedElements");
						if (!fullCheck) {
							break;
						}
						if (graphConnectionErrors == null) {
							graphConnectionErrors = new HashMap();
						}

						graphConnectionErrors
								.put(wp, basicGraphConnectionError);
					}
					// find all block activities
					Set blockActs = workflowManager.getBlockActivities(true);
					Iterator itBas = blockActs.iterator();
					while (itBas.hasNext()) {
						BlockActivity ba = (BlockActivity) itBas.next();
						ProcessEditor bwe = ba.getImplementationEditor();
						if (bwe != null) {
							ProcessGraph bag = (ProcessGraph) bwe.getGraph();
							if (bag.getImproperlyConnectedStarts(false).size() > 0
									|| bag.getImproperlyConnectedEnds(false)
											.size() > 0) {
								wellConnected = false;
								basicGraphConnectionError = ResourceManager
										.getLanguageDependentString("InformationOneOrMoreProcessesHaveImproperlyConnectedElements");
								if (!fullCheck) {
									break;
								}
								graphConnectionErrors.put(wp,
										basicGraphConnectionError);
							}

						}
					}
				}
			}
		}
		return wellConnected;
	}

	protected void updateXMLObjectsBeforeChecking() {
		// first update extended attributes for start and end for all processes
		Set activities = BPDGraphModel.getAllActivitiesInModel(graphModel);
		if (activities != null) {
			Iterator it = activities.iterator();
			while (it.hasNext()) {
				Activity act = (Activity) it.next();
				ProcessEditor pe = act.getImplementationEditor();
				if (pe != null) {
					WorkflowProcess wp = (WorkflowProcess) act.getUserObject();
					wp.setStartDescriptions(Utils.getStartDescriptions(pe));
					wp.setEndDescriptions(Utils.getEndDescriptions(pe));
					// find all block activities
					Set blockActs = workflowManager.getBlockActivities(true);
					Iterator itBas = blockActs.iterator();
					while (itBas.hasNext()) {
						BlockActivity ba = (BlockActivity) itBas.next();
						ProcessEditor bwe = ba.getImplementationEditor();
						com.ds.bpm.bpd.xml.activity.Activity bap = (com.ds.bpm.bpd.xml.activity.Activity	) ba
								.getUserObject();
						bap.setStartDescriptions(Utils
								.getStartDescriptions(bwe));
						bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
					}
				}
			}
		}
	}

	/**
	 * Checks the graph for conformance.
	 * 
	 * @param fullCheck
	 *            true if the full check should be performed, and false if
	 *            checking should stop on first conformance error
	 * @return true if the graph is conformant
	 */
	public boolean checkGraphConformance(boolean fullCheck) {
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, true);
		boolean areGraphsConformant = pv.checkGraphConformance(fullCheck);
		basicGraphConformanceErrors = pv
				.getBasicGraphConformanceErrors(getXMLPackage());
		graphConformanceErrors = pv.getGraphConformanceErrors(getXMLPackage());
		return areGraphsConformant;
	}

	public boolean checkLogic(boolean fullCheck) {
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, true);
		boolean isLogical = pv.checkPackage(fullCheck);
		basicLogicError = pv.getBasicLogicError(getXMLPackage());
		logicErrors = pv.getLogicErrors(getXMLPackage());
		return isLogical;
	}

	/**
	 * Reacts upon the XML element change by setting isModified flag of
	 * PackageEditor if needed.
	 */
	public void xmlElementChanged(XMLElement el) {
		if (el instanceof com.ds.bpm.bpd.xml.activity.Activity) {
			editor.getStatusBar().updateMessage();
		}
	}

}

/* End of PackageGraph.java */
