/* PEOverviewPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：全图预览图形构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;

import javax.swing.BorderFactory;
import javax.swing.JPanel;

import com.ds.bpm.bpd.graph.Activity;

import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphLayoutCache;

public class BPDOverviewPanel extends JPanel implements ComponentListener,
		GraphModelListener, Observer {
	protected ProcessGraph graph;

	protected ProcessEditor processEditor;

	public BPDOverviewPanel(JGraph g) {
		// 获得当前工作流图形编辑界面
		if (BPD.getInstance().getActivedProcessEditor() != null) {
			processEditor = BPD.getInstance().getActivedProcessEditor();
		} else {
			System.out
					.println("BPDOverviewPanel Error:There Is Not ActivedProcessEditor!");
		}
		GraphLayoutCache view = new ViewRedirector(g, g.getGraphLayoutCache());
		graph = new ProcessGraph(g.getModel(), view, processEditor
				.getParentEditor(), processEditor);
		graph.setAntiAliased(true);
		setBorder(BorderFactory.createEtchedBorder());
		graph.getModel().addGraphModelListener(this);
		graph.setEnabled(true);
		graph.addComponentListener(this);
		initGraphBehavior(graph);
		graph.addMouseListener(new MouseListener(){

			public void mouseClicked(MouseEvent e) {						
				BPD.getInstance().getPackageEditor().contentTabbedPane.setSelectedComponent(graph.getProcessEditor());
				BPD.getInstance().getActivedProcessEditor().getGraph().setSelectionModel(graph.getSelectionModel());
				Object object= BPD.getInstance().getActivedProcessEditor().getGraph().getSelectionCell();	
				if (object!=null&&(object instanceof Activity)){
					Activity gAct=(Activity) object;	
				BPD.getInstance().getActivedProcessEditor().graphScrollPane.getHorizontalScrollBar().getModel().setValue(gAct.getXOff());
				BPD.getInstance().getActivedProcessEditor().graphScrollPane.getVerticalScrollBar().getModel().setValue(gAct.getYOff());
				BPD.getInstance().getActivedProcessEditor().graphScrollPane.updateUI();
			}		
			}
			public void mouseEntered(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			public void mouseExited(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			public void mousePressed(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			public void mouseReleased(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}
			
		});
		
		g.getGraphLayoutCache().addObserver(this);
		//setLayout(new BorderLayout());
		add(graph, BorderLayout.CENTER);
	}

	//
	// Observer
	//

	public void update(Observable o, Object arg) {
		componentResized(null);
	}

	//
	// GraphModelListener
	//

	public void graphChanged(GraphModelEvent e) {
		componentResized(null);
	}

	//
	// Component Listener
	//

	  public void componentResized(ComponentEvent e) {
	      Rectangle r = null;
	      if(AbstractCellView.getBounds(graph.getGraphLayoutCache().getRoots())!=null) {
	         r = AbstractCellView.getBounds(graph.getGraphLayoutCache().getRoots()).getBounds();
	      }
	      if (processEditor.getGraph().getBounds().width>0){
	    	  double scale=200/processEditor.getGraph().getBounds().width;
		      if (r != null) {
		         Dimension d = new Dimension(r.x+r.width, r.y+r.height);
		         Dimension s = getSize();
				 double h=s.getHeight();
				 double w=s.getWidth();
				
				 if (h<160){
					h=160;
				 };
				 if (w>200){
						w=200;
					 };
		         double sx = w*0.95/d.getWidth();
		         double sy = h*0.95/d.getHeight();			
		         scale = Math.min(Math.max(Math.min(sx, sy), 0.05), 0.5);
		      }
			
		      graph.setScale(scale);
	      }
	     
	      repaint();
	   }


	public void componentShown(ComponentEvent e) {
		componentResized(e);
	}

	public void componentHidden(ComponentEvent e) {
	}

	public void componentMoved(ComponentEvent e) {
	}

	//
	// View Redirector
	//
	 public class ViewRedirector extends GraphLayoutCache {

	      protected GraphLayoutCache realView;

	      public ViewRedirector(JGraph graph, GraphLayoutCache realView) {
	         super(graph);//HM, JGraph3.4.1
	         this.realView = realView;
	         setModel(graph.getModel());
	      }

	      public CellView[] getRoots() {
	         return realView.getRoots();
	      }

	      public CellView getMapping(Object cell, boolean create) {
	         if (realView != null)
	            return realView.getMapping(cell, create);
	         return null;
	      }

	      public void putMapping(Object cell, CellView view) {
	         if (realView != null)
	            realView.putMapping(cell, view);
	         }

	   }
	protected void initGraphBehavior(JGraph graph) {
		graph.setHandleSize(4);
		graph.setTolerance(4);
		graph.setSelectNewCells(true);
		graph.setSizeable(false);
		graph.setMoveable(false);
		
	}
}

/* End of PEOverviewPanel.java */
