/* BPDAboutDialog.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：关于BPD对话框构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */
package com.ds.bpm.bpd;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;

import com.ds.bpm.bpd.misc.Version;
import com.ds.bpm.bpd.xml.XMLButton;

/**
 * Displays about dialog for BPD aplication.
 */
public class BPDAboutDialog extends JDialog {
	private JButton okButton;

	private JPanel aboutPnl;

	private JToolBar buttonToolbar;

	private JPanel txtPnl;

	private JLabel txtbpd;

	/**
	 * CardLayout for displaying different panes on one JDialog
	 */
	// private CardLayout card = new CardLayout();
	private ActionListener actionHandler = new ActionHandler();

	public static void showAbout(Frame owner, String title, ImageIcon logo) {
		BPDAboutDialog about = new BPDAboutDialog(owner, title, logo);
		about.show();
		about = null;
	}

	private BPDAboutDialog(Frame owner, String title, ImageIcon logo) {
		super(owner, title, true);
		createUI();
		setResizable(false);
		pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension winsize = this.getSize();
		setLocation(screenSize.width / 2 - (winsize.width / 2),
				screenSize.height / 2 - (winsize.height / 2));
		setLocationRelativeTo(owner);
	}

	private void createUI() {
		createButtonPane();
		createAboutPane();
		getContentPane().add(aboutPnl, BorderLayout.CENTER);
		getContentPane().add(buttonToolbar, BorderLayout.SOUTH);
		getRootPane().setDefaultButton(okButton);
	}

	private void createButtonPane() {
		Dimension dim = getDimension(new String[] { "OK", "Credits", "About" });
		okButton = new XMLButton(ResourceManager
				.getLanguageDependentString("OKKey"), "OK", dim);
		okButton.addActionListener(actionHandler);
		buttonToolbar = new JToolBar(JToolBar.HORIZONTAL);
		buttonToolbar.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
		buttonToolbar.setFloatable(false);
		buttonToolbar.add(Box.createHorizontalGlue());
		buttonToolbar.add(okButton);
		buttonToolbar.add(Box.createHorizontalGlue());
	}

	private void createAboutPane() {
		//JLabel aboutLabel = new JLabel(new ImageIcon(ResourceManager
		//		.getResource("properties")), JLabel.CENTER);
		JLabel aboutLabel = new JLabel();
		aboutLabel.setBorder(BorderFactory.createEtchedBorder());
		aboutPnl = new JPanel(new BorderLayout());
		txtPnl = new JPanel(new BorderLayout());
		txtPnl.setFont(new Font("宋体", Font.PLAIN, 16));
		txtPnl.add(BorderLayout.NORTH, new JLabel(ResourceManager
				.getLanguageDependentString("Version"
						+ BPDConstants.LABEL_SUFFIX)
				+ ": " + Version.getVersion(), SwingConstants.CENTER));
		String companyName = "JDS软件";
		if (ResourceManager.getChoosenLocale().getDisplayLanguage()
				.equals("英文")
				|| ResourceManager.getChoosenLocale().getDisplayLanguage()
						.equals("English")) {
			companyName = "JDS International Limitd.";
		}
		JLabel vendor = new JLabel("Copyright (C) 2003-2012 " + companyName,
				SwingConstants.CENTER);
		vendor.setFont(new Font("SansSerif", Font.BOLD, 14));
		txtPnl.add(BorderLayout.CENTER, vendor);
//		txtPnl.add(BorderLayout.SOUTH, new JLabel(
//				"http://www.itjds.net     service@itjds.net",
//				SwingConstants.CENTER));
		aboutPnl.add(aboutLabel, BorderLayout.CENTER);
		aboutPnl.add(txtPnl, BorderLayout.SOUTH);
	}

	private Dimension getDimension(String[] s) {
		String[] labels = s;
		int longest = 0;
		int w = 0;
		for (int i = 0; i < labels.length; i++) {
			try {
				w = getFontMetrics(getFont()).stringWidth(labels[i]);
				if (w > longest)
					longest = w;
			} catch (Exception e) {
			}
		}
		w = longest + 22;
		int h = getFontMetrics(getFont()).getHeight() + 2;
		Dimension dim = new Dimension(w, h);
		return dim;
	}

	// Close on escape
	protected JRootPane createRootPane() {
		KeyStroke stroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
		JRootPane rootPane = new JRootPane();
		rootPane.registerKeyboardAction(new ActionListener() {
			public void actionPerformed(ActionEvent actionEvent) {
				setVisible(false);
			}
		}, stroke, JComponent.WHEN_IN_FOCUSED_WINDOW);
		return rootPane;
	}

	private class ActionHandler implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (e.getSource() == okButton) {
				dispose();
			}
		}
	}
}

/** End of PEAboutDialog.java */

