package com.ds.rad;

import com.ds.common.JDSException;
import com.ds.config.JDSUtil;
import com.ds.config.ResultModel;
import com.ds.handler.Conts;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.FileVersion;
import com.ds.vfs.VFSConstants;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import freemarker.template.TemplateException;
import org.springframework.web.bind.annotation.RequestMapping;

import java.io.*;

@RequestMapping(value = "/vfs/")
public class VFSRADService {
    @RequestMapping(value = "download")
    public ResultModel<InputStream> download(String path, String personId, HttpRequest request, HttpResponse response) {
        InputStream stream = null;
        ResultModel<InputStream> userStatusInfo = new ResultModel<InputStream>();
        try {
            File file = new File(JDSUtil.getJdsRealPath() + path);
            if (file.exists()) {
                stream = new FileInputStream(file);
                String mimeType = Conts.getSuffixMap().get(file.getName().substring(file.getName().indexOf(".")));
                response.setMimeType("application/octet-stream");
                response.addHeader("Content-disposition", "filename=" + new String(file.getName().getBytes("utf-8"), "ISO8859-1"));
                response.addHeader("Content-Length", String.valueOf(file.length()));
                response.sendResponse(stream, Integer.valueOf(Long.toString(file.length())));

            } else {
                // 激活下载操作
                FileInfo fileInfo = null;
                FileVersion version = null;
                try {
                    version = getVfsClient().getFileVersionByPath(path);
                    if (path.indexOf(VFSConstants.URLVERSION) > -1) {
                        path = path.split(VFSConstants.URLVERSION)[0];
                    }
                    fileInfo = getVfsClient().getFileByPath(path);
                    if (fileInfo != null) {
                        stream = version.getInputStream();
                    }
                } catch (JDSException e) {
                    e.printStackTrace();
                }
                if (stream != null) {
                    String mimeType = Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf(".")));
                    response.setMimeType("application/octet-stream");
                    response.addHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                    JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                    if (fileInfo.getPath().endsWith(".js")) {
                        try {
                            Writer stringWriter = freemarkerResult.doExecute(version.getFileObject().getHash(), CtVfsFactory.getLocalCachePath());
                            response.setMimeType(mimeType);
                            String json=stringWriter.toString();
                            response.sendResponse(getInputStream(json, "utf-8"),-1);
                        } catch (TemplateException e) {
                            e.printStackTrace();
                        }
                    } else {
                        response.addHeader("Content-Length", String.valueOf(version.getLength()));
                        response.sendResponse(stream, version.getLength().intValue());
                    }
                }

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return userStatusInfo;

    }

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }

    public InputStream getInputStream(String content, String charSet) {
        if (content == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(content.getBytes(charSet));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
