package com.ds.rad;

import com.ds.bpm.bpd.BPD;
import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5;
import com.ds.common.util.IOUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.context.JDSActionContext;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.tool.module.EUModule;
import com.ds.vfs.FileInfo;
import com.ds.vfs.VFSConstants;

import java.awt.*;
import java.io.*;
import java.util.List;
import java.util.Set;

@EsbBeanAnnotation(expressionArr = "export()", id = "export")
public class ExportService {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, ExportService.class);

    public ExportService() {

    }


    public String export() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        String localPath = null;

        if (projectName == null) {
            return "参数中不存在所需的 工程名称 ";
        }
        try {
            ProjectVersion version = ESDFacrory.getESDClient().getProjectVersionByName(projectName.toString());
            if (version==null){
                return "工程版本错误！ ";
            }
            localPath = JDSUtil.getJdsRealPath() + File.separator + "export" + "/" + version.getProject().getProjectName() + "/" + version.getVersion() + "/";
            List<FileInfo> fileInfos = version.getRootFolder().getFileListRecursively();
            for (FileInfo fileInfo : fileInfos) {
                if (!fileInfo.getName().endsWith(".cls")) {
                    String realPath = StringUtility.replace(fileInfo.getPath(), version.getRootFolder().getPath(), "/");
                    File file = new File(localPath + realPath);
                    InputStream input = fileInfo.getCurrentVersion().getInputStream();
                    if (file.getParentFile() != null && !file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (!file.exists()) {
                        file.createNewFile();

                    }
                    FileOutputStream output = new FileOutputStream(file);
                    IOUtility.copy(input, output);
                    IOUtility.shutdownStream(input);
                    IOUtility.shutdownStream(output);
                }

            }
            JDSActionContext.getActionContext().getContext().put("build", "false");
            Set<EUModule> modules = version.getAllModule();
            for (EUModule module : modules) {

                File file = new File(localPath + "cls/" + MD5.getHashString(module.getClassName()));
                StringBuffer json = ESDFacrory.getESDClient().genJSON(module, null);
                InputStream input = null;

                input = new ByteArrayInputStream(json.toString().getBytes(VFSConstants.Default_Encoding));
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }

                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream output = new FileOutputStream(file);
                IOUtility.copy(input, output);
                IOUtility.shutdownStream(input);
                IOUtility.shutdownStream(output);
            }
            JDSActionContext.getActionContext().getContext().remove("build");

            File f1 = new File("D:\\");
            Desktop.getDesktop().open(f1);

        } catch (IOException e) {
            e.printStackTrace();
        } catch (JDSException e) {
            e.printStackTrace();
        }
        return "导出成功";
    }

    public void close() {
        BPD.getInstance().close();
    }


}
