package com.ds.login;

import com.ds.common.JDSException;
import com.ds.common.swing.util.ImageUtil;
import com.ds.config.UserBean;
import com.ds.editor.ESDEditor;
import com.ds.editor.chrome.PageEditor;
import com.ds.server.JDSServer;

import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import static com.ds.editor.ESDEditor.MAIN_URL;


public class JDSTrayIcon extends TrayIcon {


    public JDSTrayIcon() {
        super(ImageUtil.getCoolweiImg(), UserBean.getInstance().getPanelDisplayName(), new TrayMenu());
        this.setImageAutoSize(true);
        this.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    try {
                        if (JDSServer.getInstance().getAdminUser() == null) {
                            if (ESDEditor.getInstance().getLoginPanel().isVisible()) {
                                ESDEditor.getInstance().getLoginPanel().setVisible(false);
                            } else {
                                ESDEditor.getInstance().getLoginPanel().setVisible(true);
                            }
                        } else if (ESDEditor.getInstance() != null) {
                            PageEditor editor = ESDEditor.getInstance().getAllPage().get(MAIN_URL);
                            if (editor != null) {
                                editor.manage().window().setPosition(editor.manage().window().getPosition());
                            }
                        }
                    } catch (JDSException e1) {
                        e1.printStackTrace();
                    }


                }
            }
        });
    }


}
