package com.ds.login;

import com.ds.common.util.ClassUtility;
import com.ds.config.UserBean;
import com.google.common.io.LineReader;

import java.util.Properties;

public class ESDProperties {
    public Properties props;
    private static ESDProperties instance;
    public static final String clientPath = "ESD.properties";

    String getValue(String name) {
        return props.getProperty(name);
    }

    ESDProperties() {
        try {
            props = new Properties();

            props.load(ClassUtility.loadResource(clientPath));
        } catch (Throwable e) {
            System.out.println("系统启动文件缺失！ [" + clientPath + "] 请检查系统包是否完整！");
            System.exit(0);
            e.printStackTrace();
        }
    }

    public static ESDProperties getInstance() {
        if (instance == null) {
            instance = new ESDProperties();
        }
        return instance;
    }

}
