package com.ds.editor.chrome.task;

import com.ds.common.JDSException;
import com.ds.common.md5.MD5;
import com.ds.common.util.IOUtility;
import com.ds.config.JDSUtil;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.PageHis;
import com.ds.server.JDSServer;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.chrome.ChromeDriver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class RobotScreenPage implements Runnable {

    private final ChromeDriver chrome;
    private final URL url;
    private final Integer deploy;

    public RobotScreenPage(ChromeDriver chrome, URL url, Integer deploy) {
        this.chrome = chrome;
        this.url = url;
        this.deploy = deploy;
    }

    @Override
    public void run() {
        String account = null;
        try {
            account = JDSServer.getInstance().getAdminUser().getAccount();
            List<PageHis> hisPages = ESDFacrory.getInstance().getUrls(account);
            PageHis page = ESDFacrory.getInstance().getHisPage(account, url);
            if (page == null) {
                page = new PageHis();
                hisPages.add(page);
            }
            page.setUrl(url.toString());
            page.setOpenTime(System.currentTimeMillis());
            Thread.sleep(deploy);
            if (page.getImgScr() != null) {
                File oldFile = new File(JDSUtil.getJdsRealPath() + page.getImgScr());
                if (oldFile.exists()) {
                    oldFile.delete();
                }
            }
            page.setTitle(chrome.getTitle());
            File file = chrome.getScreenshotAs(OutputType.FILE);
            String fileHash = MD5.getHashString(file);
            File imgFile = new File(JDSUtil.getJdsRealPath() + File.separator + "temp" + File.separator + fileHash + ".png");
            IOUtility.copyFile(file, imgFile);
            page.setImgScr("/temp/" + fileHash + ".png");
            ESDFacrory.getInstance().setUrls(account, hisPages);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (JDSException e) {
            e.printStackTrace();
        }

    }
}
