package com.ds.common.swing;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import com.ds.common.swing.table.TableHeaderRenderer;
import com.ds.common.swing.table.TableViewAdapter;
import com.ds.common.swing.table.TableViewColumn;
import com.ds.common.swing.table.TableViewModel;


/**
 * The table view main class
 *
 * @version $Revision: 1.1 $ $Date: 2016/09/30 14:56:42 $.
 * Revision history:
 * $Log: TableView.java,v $
 * Revision 1.1  2016/09/30 14:56:42  administrator
 *
 * Committed on the Free edition of March Hare Software CVSNT Server.
 * Upgrade to CVS Suite for more features and support:
 * http://march-hare.com/cvsnt/
 *
 * Revision 1.1  2003/12/26 03:38:52  andy
 * no message
 *
 * Revision 1.11  2003/06/06 06:31:32  stbrunner
 * Change description
 *
 */
public class TableView extends JTable implements MouseListener {
  private TableViewColumn mCurrentCollumn;
  private Point mLastMouseClickedPosition;

  private JDialog mDialogSearch;
//  private JLabel mLabelSearchTest = new JLabel();
  private JTextField mTextFieldSearchTest = new JTextField();
  private JButton mButtonSearch = new JButton();
  private JPopupMenu mPopupMenu = new JPopupMenu();
  private JDialog mDialogVisiblity;
  private JMenuItem mMenuItemHide = new JMenuItem();
  private JMenuItem mMenuItemSearch = new JMenuItem();
  private JMenuItem mMenuItemVisiblityProperties = new JMenuItem();
  private JButton mButtonVisiblityOK = new JButton();
  private JRadioButtonMenuItem mRadioButtonMenuItemAutoResizeColumnAll = new JRadioButtonMenuItem();
  private JRadioButtonMenuItem mRadioButtonMenuItemAutoResizeColumnNext = new JRadioButtonMenuItem();
  private JRadioButtonMenuItem mRadioButtonMenuItemAutoResizeColumnNone = new JRadioButtonMenuItem();
  private ButtonGroup mButtonGroupAutoResizeColumn = new ButtonGroup();
  private ResourceBundle mRessource = ResourceBundle.getBundle(getClass().getName());
  private GridLayout mGridLayout = new GridLayout();

  /**
   * Construct.
   * @param pOwner the owner frame to set the dialogues modal.
   * @param pModel the model
   * @deprecated pOwner unsued
   */
  public TableView(JFrame pOwner, TableViewModel pModel) {
    this(pModel);
  }
  
  /**
   * Construct.
   * @param pModel the model
   * 
   */
  public TableView(TableViewModel pModel) {
    super(getModel(pModel));

    getTableHeader().setDefaultRenderer(new TableHeaderRenderer());
    getTableHeader().addMouseListener(this);

    initMenu();
  }

//  /**
//   * Init the class.
//   * @param pOwner the owner frame to set the dialogues modal.
//   */
//  private void init(JFrame pOwner) {
//    getTableHeader().setDefaultRenderer(new TableHeaderRenderer());
//
//    mDialogSearch = new javax.swing.JDialog(pOwner);
//    mDialogVisiblity = new javax.swing.JDialog(pOwner);
//    getTableHeader().addMouseListener(this);
//
//    try {
//      jbInit();
//    }
//    catch (Exception e) {
//      e.printStackTrace();
//    }
//  }

  //  private static Map sTableModel = new HashMap();

  /**
   * Contruct adapter from table viw model.
   * @param pModel the table view model to be adapted
   * @return the adapter
   */
  private static TableViewAdapter getModel(TableViewModel pModel) {
    if (pModel != null) {
      return new TableViewAdapter(pModel);
    }
    return null;
  }

  /**
   * Set a new table view model.
   * @param pModel the new model
   */
  public void setModel(TableViewModel pModel) {
    super.setModel(getModel(pModel));
  }

  /**
   * Select a new row.
   * @param pRow the row Object
   */
  public void addRowSelection(Object pRow) {
    addRowSelection(pRow, false);
  }

  /**
   * Select a new row.
   * @param pRow the row Object
   * @param pScroll scroll to the new row ?
   */
  public void addRowSelection(Object pRow, boolean pScroll) {
    int index = ((TableViewAdapter) getModel()).indexOf(pRow);
    addRowSelectionInterval(index, index);
    scrollRectToVisible(this.getCellRect(index, index, true));
  }

  /**
   * Select new rows.
   * @param pRows the rows Objects
   */
  public void addRowSelection(Object[] pRows) {
    for (int i = 0; i < pRows.length; i++) {
      addRowSelection(pRows[i]);
    }
  }

  /**
   * Select new rows.
   * @param pRows the rows Objects
   */
  public void addRowSelection(List pRows) {
    for (Iterator i = pRows.iterator(); i.hasNext();) {
      try {
        addRowSelection(i.next());
      }
      catch (Exception e) {
      }
    }
  }

  /**
   * Auto size the column to fit with his content.
   * @param pColumnIndex visible column index (not table model index)
   */
  public void autoSizeColumn(int pColumnIndex) {
    int width = 0;
    TableColumn column = getColumnModel().getColumn(pColumnIndex);

    for (int i = 0; i < getRowCount(); i++) {
      Rectangle cell = getCellRect(i, pColumnIndex, true);
      TableModel model = getModel();

      width = Math.max(width,
          getCellRenderer(i, pColumnIndex).getTableCellRendererComponent(this, model.getValueAt(i, column.getModelIndex()), 
              false, false, i, column.getModelIndex()).getPreferredSize().width + 1);
    }
    sizeColumnsToFit(pColumnIndex, width);
  }

  /**
   * Set a column size.
   * @param pColumnIndex visible column index (not table model index)
   * @param pWidth column width
   */
  public void sizeColumnsToFit(int pColumnIndex, int pWidth) {
    TableColumn column = getColumnModel().getColumn(pColumnIndex);

    for (int i = 0; i < getColumnCount(); i++) {
      TableColumn tableColumn = getColumnModel().getColumn(i);
      tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    pWidth = Math.max(pWidth, column.getMinWidth());
    int diff = column.getWidth() - pWidth;
    column.setPreferredWidth(pWidth);

    // Use the mode to determine how to absorb the changes.
    switch (autoResizeMode) {
      case AUTO_RESIZE_NEXT_COLUMN :
        TableColumn newTableColumn = getColumnModel().getColumn(Math.min(pColumnIndex + 1, getColumnCount() - 1));
        newTableColumn = column == newTableColumn && getColumnCount() > 1 ? getColumnModel().getColumn(getColumnCount() - 2) : newTableColumn;
        // last column ?
        newTableColumn.setPreferredWidth(newTableColumn.getPreferredWidth() + diff);
        break;

      case AUTO_RESIZE_SUBSEQUENT_COLUMNS :
        int cont = getColumnCount() - pColumnIndex;
        if (cont == 1 && getColumnCount() > 1) {
          // last column
          column = getColumnModel().getColumn(pColumnIndex - 1);
          column.setPreferredWidth(column.getPreferredWidth() + diff);
          break;
        }
        int coldiff = diff / (cont - 1);
        int colrest = diff % (cont - 1);

        for (int i = pColumnIndex + 1; i < getColumnCount(); i++) {
          column = getColumnModel().getColumn(i);
          column.setPreferredWidth(column.getPreferredWidth() + coldiff + (colrest > 0 ? 1 : 0));
          colrest--;
        }
        break;

      case AUTO_RESIZE_LAST_COLUMN :
        column = getColumnModel().getColumn(getColumnCount() - 1);
        column.setPreferredWidth(column.getPreferredWidth() + diff);
        break;

      case AUTO_RESIZE_ALL_COLUMNS :
        coldiff = diff / (getColumnCount() - 1);
        colrest = diff % (getColumnCount() - 1);

        for (int i = 0; i < getColumnCount(); i++) {
          if (i != pColumnIndex) {
            column = getColumnModel().getColumn(i);
            column.setPreferredWidth(column.getPreferredWidth() + coldiff + (colrest > 0 ? 1 : 0));
            colrest--;
          }
        }
        break;
    }
  }

  /**
   * Invoked when the mouse button has been clicked (pressed and released) on a component.
   * @param pEvent the event
   */
  public void mouseClicked(MouseEvent pEvent) {
    mLastMouseClickedPosition = pEvent.getPoint();
    Point p = pEvent.getComponent().getLocationOnScreen();
    mLastMouseClickedPosition.x += p.getX();
    mLastMouseClickedPosition.y += p.getY();
    TableViewAdapter adapter = (TableViewAdapter) getModel();
    mCurrentCollumn = adapter.getColumn(getColumnModel().getColumn(columnAtPoint(pEvent.getPoint())).getModelIndex());
    if (pEvent.getComponent().getCursor().getType() == Cursor.E_RESIZE_CURSOR) {
      if (pEvent.getClickCount() == 2) {
        TableColumnModel model = getColumnModel();
        JTableHeader header = getTableHeader();
        int columnIndex = -1;
        int length = Integer.MAX_VALUE;

        for (int i = 0; i < model.getColumnCount(); i++) {
          TableColumn newColumn = model.getColumn(i);
          Rectangle rect = header.getHeaderRect(i);
          int newLength = Math.abs(rect.x + rect.width - pEvent.getX());
          if (newLength < length) {
            columnIndex = i;
            length = newLength;
          }
        }

        autoSizeColumn(columnIndex);
      }
    }
    else if (pEvent.isMetaDown()) {
      mMenuItemSearch.setEnabled(mCurrentCollumn.isSearchable());
      mPopupMenu.pack();
      mPopupMenu.setLocation(mLastMouseClickedPosition);
      mPopupMenu.setVisible(true);
    }
    else if (pEvent.isControlDown() && mCurrentCollumn.isSearchable()) {
      menuItemSearchActionPerformed(null);
    }
    else if (mCurrentCollumn != null && mCurrentCollumn.isSortable()) {
      List selection = getSelectedRowObjects();
      adapter.sort(mCurrentCollumn);
      getTableHeader().repaint();
      addRowSelection(selection);
    }
  }

  /**
   * Get the selection.
   * @return the row Object to be selected
   */
  public Object getSelectedRowObject() {
    return ((TableViewAdapter) getModel()).getNewRow(super.getSelectedRow());
  }

  /**
   * Get the selections.
   * @return list of Objects to be selected
   */
  public List getSelectedRowObjects() {
    int[] visibelSelectedRows = super.getSelectedRows();
    List result = new ArrayList(visibelSelectedRows.length);
    TableViewAdapter model = (TableViewAdapter) getModel();
    for (int i = 0; i < visibelSelectedRows.length; i++) {
      result.add(model.getNewRow(visibelSelectedRows[i]));
    }
    return result;
  }

  /**
   * Invoked when a mouse button has been pressed on a component.
   * @param pEvent the event
   */
  public void mousePressed(MouseEvent pEvent) {
  }

  /**
   * Invoked when a mouse button has been released on a component.
   * @param pEvent the event
   */
  public void mouseReleased(MouseEvent pEvent) {
  }

  /**
   * Invoked when the mouse enters a component.
   * @param pEvent the event
   */
  public void mouseEntered(MouseEvent pEvent) {
  }

  /**
   * Invoked when the mouse exits a component.
   * @param pEvent the event
   */
  public void mouseExited(MouseEvent pEvent) {
  }

  /**
   * Init the Menu
   * @throws Exception
   */
  private void initMenu() {
    mRadioButtonMenuItemAutoResizeColumnNext.setSelected(true);
    mButtonGroupAutoResizeColumn.add(mRadioButtonMenuItemAutoResizeColumnAll);
    mButtonGroupAutoResizeColumn.add(mRadioButtonMenuItemAutoResizeColumnNext);
    mButtonGroupAutoResizeColumn.add(mRadioButtonMenuItemAutoResizeColumnNone);
    setAutoResizeMode(AUTO_RESIZE_NEXT_COLUMN);

    mMenuItemHide.setText(mRessource.getString("menu.hide"));
    mMenuItemHide.addActionListener(new ActionListener() {
      /**
       * @param pEvent the event
       */
      public void actionPerformed(ActionEvent pEvent) {
        menuItemHideActionPerformed(pEvent);
      }

    });

    mMenuItemSearch.setText(mRessource.getString("menu.search"));
    mMenuItemSearch.addActionListener(new ActionListener()
    {
      /**
       * @param pEvent the event
       */
      public void actionPerformed(ActionEvent pEvent) {
        menuItemSearchActionPerformed(pEvent);
      }
    });

    mMenuItemVisiblityProperties.setText(mRessource.getString("menu.visiblepro"));
    mMenuItemVisiblityProperties.addActionListener(new ActionListener() {
      /**
       * @param pEvent the event
       */
      public void actionPerformed(ActionEvent pEvent) {
        menuItemVisiblityPropertiesActionPerformed(pEvent);
      }
    });

    mPopupMenu.setInvoker(this);

    mRadioButtonMenuItemAutoResizeColumnAll.setText(mRessource.getString("menu.autosizeall"));
    mRadioButtonMenuItemAutoResizeColumnAll.addActionListener(new java.awt.event.ActionListener() {
      /**
       * @param pEvent the event
       */
      public void actionPerformed(ActionEvent pEvent) {
        radioButtonMenuItemAutoResizeColumnAllActionPerformed(pEvent);
      }
    });

    mRadioButtonMenuItemAutoResizeColumnNext.setText(mRessource.getString("menu.autosizenext"));
    mRadioButtonMenuItemAutoResizeColumnNext.addActionListener(new java.awt.event.ActionListener() {
      /**
       * @param pEvent the event
       */
      public void actionPerformed(ActionEvent pEvent) {
        radioButtonMenuItemAutoResizeColumnNextActionPerformed(pEvent);
      }
    });

    mRadioButtonMenuItemAutoResizeColumnNone.setText(mRessource.getString("menu.autosizenone"));
    mRadioButtonMenuItemAutoResizeColumnNone.addActionListener(new java.awt.event.ActionListener() {
      /**
       * @param pEvent the event
       */
      public void actionPerformed(ActionEvent pEvent) {
        radioButtonMenuItemAutoResizeColumnNoneActionPerformed(pEvent);
      }

    });

    mPopupMenu.add(mMenuItemHide);
    mPopupMenu.add(mMenuItemSearch);
    mPopupMenu.add(mMenuItemVisiblityProperties);
    mPopupMenu.addSeparator();
    mPopupMenu.add(mRadioButtonMenuItemAutoResizeColumnAll);
    mPopupMenu.add(mRadioButtonMenuItemAutoResizeColumnNext);
    mPopupMenu.add(mRadioButtonMenuItemAutoResizeColumnNone);
  }
  /**
   * Is the index made.
   * @return boolean true if the indes is made
   */
  public boolean isMakeIndex() {
    return ((TableViewAdapter) getModel()).isMakeIndex();
  }

  /**
   * Sets the indes is made
   * @param pMakeIndex the value
   */
  public void setMakeIndex(boolean pMakeIndex) {
    ((TableViewAdapter) getModel()).setMakeIndex(pMakeIndex);
  }


  /**
   * Init the GUI
   * @throws Exception throws on error
   */
//  private void jbInit() throws Exception {
//    mRadioButtonMenuItemAutoResizeColumnNext.setSelected(true);
//    mButtonGroupAutoResizeColumn.add(mRadioButtonMenuItemAutoResizeColumnAll);
//    mButtonGroupAutoResizeColumn.add(mRadioButtonMenuItemAutoResizeColumnNext);
//    mButtonGroupAutoResizeColumn.add(mRadioButtonMenuItemAutoResizeColumnNone);
//    setAutoResizeMode(AUTO_RESIZE_NEXT_COLUMN);
//    mDialogSearch.setVisible(false);
//    mDialogSearch.getRootPane().setDefaultButton(mButtonSearch);
//    mDialogSearch.setTitle(mRessource.getString("search.title"));
//    mLabelSearchTest.setText(mRessource.getString("search.text"));
//    mTextFieldSearchTest.setMinimumSize(new Dimension(100, 21));
//    mTextFieldSearchTest.setPreferredSize(new Dimension(100, 21));
//    mDialogSearch.getContentPane().setLayout(new GridBagLayout());
//    mButtonSearch.setText(mRessource.getString("search.btn"));
//    mButtonSearch.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        buttonSearchActionPerformed(pEvent);
//      }
//
//    });
//
//    mMenuItemHide.setText(mRessource.getString("menubar.hide"));
//    mMenuItemHide.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        menuItemHideActionPerformed(pEvent);
//      }
//
//    });
//
//    mMenuItemSearch.setText(mRessource.getString("menubar.search"));
//    mMenuItemSearch.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        menuItemSearchActionPerformed(pEvent);
//      }
//    });
//
//    mMenuItemVisiblityProperties.setText(mRessource.getString("menubar.visiblepro"));
//    mMenuItemVisiblityProperties.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        menuItemVisiblityPropertiesActionPerformed(pEvent);
//      }
//    });
//
//    mPopupMenu.setInvoker(this);
//    mDialogVisiblity.getContentPane().setLayout(mGridLayout);
//    mDialogVisiblity.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
//    mDialogVisiblity.setResizable(false);
//    mDialogSearch.setResizable(false);
//    mDialogVisiblity.setTitle(mRessource.getString("visible.title"));
//    mButtonVisiblityOK.setText(mRessource.getString("btn.ok"));
//    mButtonVisiblityOK.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        buttonVisiblityOKActionPerformed(pEvent);
//      }
//    });
//
//    mGridLayout.setColumns(1);
//    mRadioButtonMenuItemAutoResizeColumnAll.setText(mRessource.getString("menubar.autosizeall"));
//    mRadioButtonMenuItemAutoResizeColumnAll.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        radioButtonMenuItemAutoResizeColumnAllActionPerformed(pEvent);
//      }
//    });
//
//    mRadioButtonMenuItemAutoResizeColumnNext.setText(mRessource.getString("menubar.autosizenext"));
//    mRadioButtonMenuItemAutoResizeColumnNext.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        radioButtonMenuItemAutoResizeColumnNextActionPerformed(pEvent);
//      }
//    });
//
//    mRadioButtonMenuItemAutoResizeColumnNone.setText(mRessource.getString("menubar.autosizenone"));
//    mRadioButtonMenuItemAutoResizeColumnNone.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent pEvent) {
//        radioButtonMenuItemAutoResizeColumnNoneActionPerformed(pEvent);
//      }
//
//    });
//    mDialogSearch.getContentPane().add(
//      mLabelSearchTest,
//      new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
//    mDialogSearch.getContentPane().add(
//      mTextFieldSearchTest,
//      new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
//    mDialogSearch.getContentPane().add(
//      mButtonSearch,
//      new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
//    mPopupMenu.add(mMenuItemHide);
//    mPopupMenu.add(mMenuItemSearch);
//    mPopupMenu.add(mMenuItemVisiblityProperties);
//    mPopupMenu.addSeparator();
//    mPopupMenu.add(mRadioButtonMenuItemAutoResizeColumnAll);
//    mPopupMenu.add(mRadioButtonMenuItemAutoResizeColumnNext);
//    mPopupMenu.add(mRadioButtonMenuItemAutoResizeColumnNone);
//  }

  /**
   * Search
   * @param pEvent the event
   */
  private void buttonSearchActionPerformed(ActionEvent pEvent) {
    TableViewAdapter adapter = (TableViewAdapter) getModel();
    List selection = getSelectedRowObjects();
    if ("".equals(mTextFieldSearchTest.getText())) {
      adapter.search(mCurrentCollumn, null);
    }
    else {
      adapter.search(mCurrentCollumn, mTextFieldSearchTest.getText());
    }
    for (Iterator i = selection.iterator(); i.hasNext();) {
      addRowSelection(i.next(), true);
    }
    if (getSelectedRowObjects().size() == 0 && getModel().getRowCount() > 0) {
      addRowSelectionInterval(0, 0);
      scrollRectToVisible(this.getCellRect(0, 0, true));
    }

    getTableHeader().repaint();
    mDialogSearch.setVisible(false);
  }

  /**
   * Hide column.
   * @param pEvent the event
   */
  private void menuItemHideActionPerformed(ActionEvent pEvent) {
    mMenuItemHide.setEnabled(((TableViewAdapter) getModel()).setVisible(mCurrentCollumn, false));
  }

  /**
   * Search.
   * @param pEvent the event
   */
  private void menuItemSearchActionPerformed(ActionEvent pEvent) {
    mTextFieldSearchTest.setText(((TableViewAdapter) getModel()).getSearchText(mCurrentCollumn));
    mTextFieldSearchTest.selectAll();

    if (mDialogSearch == null) {
      initDialogSearch();
    }

    mDialogSearch.pack();
    mDialogSearch.setLocation(mLastMouseClickedPosition);
    mDialogSearch.setVisible(true);
  }

  /**
   * Show visible properties panel.
   * @param pEvent the event
   */
  private void menuItemVisiblityPropertiesActionPerformed(ActionEvent pEvent) {
    final TableViewAdapter modelAdapter = (TableViewAdapter) getModel();
    TableViewColumn[] columns = modelAdapter.getModel().getColumns();

    if (mDialogVisiblity == null) {
      initDialogVisiblity();
    }

    mDialogVisiblity.getContentPane().removeAll();
    mGridLayout.setRows(columns.length + 1);

    for (int i = 0; i < columns.length; i++) {
      final TableViewColumn column = columns[i];
      final JCheckBox checkBoxColumn = new JCheckBox(column.getName());
      checkBoxColumn.setSelected(modelAdapter.isVisible(columns[i]));
      mDialogVisiblity.getContentPane().add(checkBoxColumn, null);

      checkBoxColumn.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent pEvent) {
          mMenuItemHide.setEnabled(modelAdapter.setVisible(column, checkBoxColumn.isSelected()));
        }

      });
    }

    mDialogVisiblity.getContentPane().add(mButtonVisiblityOK, null);
    mDialogVisiblity.pack();
    mDialogVisiblity.setLocation(mLastMouseClickedPosition);
    mDialogVisiblity.setVisible(true);
  }

  /**
   * Hide visible properties panel.
   * @param pEvent the event
   */
  private void buttonVisiblityOKActionPerformed(ActionEvent pEvent) {
    mDialogVisiblity.setVisible(false);
  }

  /**
   * Change auto-risize mode.
   * @param pEvent the event
   */
  private void radioButtonMenuItemAutoResizeColumnNoneActionPerformed(ActionEvent pEvent) {
    setAutoResizeMode(AUTO_RESIZE_OFF);
  }

  /**
   * Change auto-risize mode.
   * @param pEvent the event
   */
  private void radioButtonMenuItemAutoResizeColumnNextActionPerformed(ActionEvent pEvent) {
    setAutoResizeMode(AUTO_RESIZE_NEXT_COLUMN);
  }

  /**
   * Change auto-risize mode.
   * @param pEvent the event
   */
  private void radioButtonMenuItemAutoResizeColumnAllActionPerformed(ActionEvent pEvent) {
    setAutoResizeMode(AUTO_RESIZE_ALL_COLUMNS);
  }


  /**
   * @return the frame this table is embedded in
   */
  private JFrame getFrame() {
    Container parent = getParent();
    while (!(parent instanceof JFrame)) {
      parent = parent.getParent();
    }
    return (JFrame) parent;
  }

  /**
   * init the search dialog
   */
  private void initDialogSearch() {
    mDialogSearch = new JDialog(getFrame());

    mDialogSearch.setVisible(false);
    mDialogSearch.setTitle(mRessource.getString("search.title"));
    mDialogSearch.setResizable(false);
    mDialogSearch.setModal(true);

    Container contentPane = mDialogSearch.getContentPane();

    contentPane.setLayout(new GridBagLayout());

    // creating label
    JLabel jLabelSearchTest = new JLabel();
    jLabelSearchTest.setText(mRessource.getString("search.text"));
    contentPane.add(jLabelSearchTest, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 
        GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    // creating JTextField jTextFieldSearchTest
    mTextFieldSearchTest.setMinimumSize(new Dimension(100, 21));
    mTextFieldSearchTest.setPreferredSize(new Dimension(100, 21));
    contentPane.add(mTextFieldSearchTest, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0,
        GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    // creating Search Button
    JButton jButtonSearch = new JButton();
    mDialogSearch.getRootPane().setDefaultButton(jButtonSearch);
    jButtonSearch.setText(mRessource.getString("search.btn"));
    jButtonSearch.addActionListener(new ActionListener() {
      /**
       * @param pEvent the event
       */
      public void actionPerformed(ActionEvent pEvent) {
        buttonSearchActionPerformed(pEvent);
      }

    });
    contentPane.add(jButtonSearch, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0,
        GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
  }

  /**
   * Init the dialogue visibility.
   */
  private void initDialogVisiblity() {
    mDialogVisiblity = new javax.swing.JDialog(getFrame());

    Container contentPane = mDialogVisiblity.getContentPane();

    GridLayout gridLayout1 = new GridLayout();
    gridLayout1.setColumns(1);
    mDialogVisiblity.setModal(true);
    mDialogVisiblity.getContentPane().setLayout(gridLayout1);
    mDialogVisiblity.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    mDialogVisiblity.setResizable(false);

    mDialogVisiblity.setTitle(mRessource.getString("visible.title"));

    mButtonVisiblityOK.setText(mRessource.getString("btn.ok"));
    mButtonVisiblityOK.addActionListener(new ActionListener() {
      /**
       * @param pEvent
       */
      public void actionPerformed(ActionEvent pEvent) {
        buttonVisiblityOKActionPerformed(pEvent);
      }
    });
  }
}