
package com.ds.bpm.bpd.xml.panels.formula.iot;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.misc.OrgTreeNode;
import com.ds.bpm.bpd.misc.PlaceTree;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.iot.Place;
import com.ds.iot.ct.CtIotFactory;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XMLIOTPlacePanel extends XMLPanel {

    private static Dimension minimalDimension = new Dimension(120, 100);

    private static Dimension listDimension = new Dimension(120, 160);

    private List elements = new ArrayList();

    private int selectionMode;

    // 组织机构树
    JTree allPlaceTree;

    // 已选List
    private JList choosenList = new JList();

    // 构造器----显示原有信息
    public XMLIOTPlacePanel(XMLElement myOwner, String title, boolean hasBorder, boolean minDimension, int selectionMode) {

        super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
        this.selectionMode = selectionMode;

        // 调用Place接口得到服务器的
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());

        List<Place> places = new ArrayList<Place>();
        try {
            Place place = CtIotFactory.getCtIotService().getPlaceById("root");
            places.add(place);

        } catch (JDSException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        PlaceTree placeTree = new PlaceTree(places);

        allPlaceTree = new JTree(placeTree.getRoot());
        allPlaceTree.setRootVisible(false);
        TreeSelectionModel selectModel = new DefaultTreeSelectionModel();
        selectModel.setSelectionMode(selectionMode);
        allPlaceTree.setSelectionModel(selectModel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane placeScrollPane = new JScrollPane();
        placeScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        placeScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        placeScrollPane.setViewportView(allPlaceTree);
        placeScrollPane.setPreferredSize(new Dimension(180, 200));
        allPlaceTree.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent me) {
                JTree tree = (JTree) me.getSource();
                TreePath selPath = tree.getSelectionPath();
                if (selPath != null) {
                    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
                    Place place = (Place) node.getUserObject();
                    if (place != null) {
                        // 动态增加子节点。
                        if (node.getChildren().length == 0) {

                            List<Place> childrens = place.getChilders();
                            for (Place cplace : childrens) {
                                node.insert(new OrgTreeNode(cplace));
                            }
                        }
                    }
                }
            }
        });
        allPlaceTree.addTreeWillExpandListener(new TreeWillExpandListener() {
            public void treeWillExpand(TreeExpansionEvent tee) {
                TreePath selPath = tee.getPath();
                if (selPath != null) {
                    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
                    Place place = (Place) node.getUserObject();
                    if (place != null) {
                        // 动态增加子节点。
                        if (node.getChildren().length == 0) {

                            List<Place> childrens = place.getChilders();
                            for (Place cplace : childrens) {
                                node.insert(new OrgTreeNode(cplace));
                            }

                        }
                    }
                }
            }

            public void treeWillCollapse(TreeExpansionEvent tee) {

            }
        });
        leftPanel.add(new JLabel("■ 门店"), BorderLayout.NORTH);
        leftPanel.add(placeScrollPane, BorderLayout.CENTER);
        JPanel placePanel = new JPanel();
        placePanel.setLayout(new BorderLayout());
        placePanel.setPreferredSize(new Dimension(182, 250));
        placePanel.add(leftPanel, BorderLayout.CENTER);

        if (myOwner.toValue() != null && !myOwner.toValue().toString().equals("")) {
            String val = myOwner.toValue().toString();
            String[] vals = Utils.tokenize(val, FormulaParameter.DELIMITER_MULTIPLE);
            for (int i = 0; i < vals.length; i++) {
                String place_id = vals[i];
                if (!place_id.trim().equals("")) {
                    String place_name = null;

                    try {
                        place_name = CtIotFactory.getCtIotService().getPlaceById(place_id).getName();
                    } catch (JDSException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }

                    if (place_name != null) {
                        elements.add(new XMLSelectOption(place_name, place_id));
                    }
                }
            }
        }

        final DefaultListModel listModel = new DefaultListModel();

        // fills list
        Iterator it = elements.iterator();

        while (it.hasNext()) {
            XMLElement elem = (XMLElement) it.next();
            listModel.addElement(elem);
        }

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        String a = ResourceManager.getLanguageDependentString("AddKey");
        String r = ResourceManager.getLanguageDependentString("RemoveKey");
        Dimension dim = new Dimension(45, 15);
        XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
        XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
        // 添加按钮的操作
        buttonAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                addOperation();
            }
        });
        // 删除按钮的操作
        buttonRemove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                removeOperation();
            }
        });
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonAdd);
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonRemove);
        buttonPanel.setPreferredSize(new Dimension(80, 60));

        JPanel choosenPanel = new JPanel();
        choosenPanel.setLayout(new BorderLayout());
        JScrollPane choosenScrollPane = new JScrollPane();
        choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        choosenScrollPane.setViewportView(choosenList);
        choosenList.setModel(listModel);
        if (getSelectionMode() == TreeSelectionModel.SINGLE_TREE_SELECTION) {
            choosenList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        } else {
            choosenList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        }
        choosenScrollPane.setPreferredSize(new Dimension(110, 200));
        choosenPanel.add(new JLabel("■ 已选"), BorderLayout.NORTH);
        choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

        jPanel.add(placePanel, BorderLayout.WEST);
        jPanel.add(buttonPanel, BorderLayout.CENTER);
        jPanel.add(choosenPanel, BorderLayout.EAST);
        add(jPanel);
    }

    public void setElements() {
        DefaultListModel model = (DefaultListModel) getList().getModel();
        String val = "";
        for (int i = 0; i < model.size(); i++) {
            Object obj = model.get(i);
            val = val + FormulaParameter.DELIMITER_MULTIPLE + ((XMLSelectOption) obj).getText();
        }
        if (!val.equals("")) {
            val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
        }
        getOwner().setValue(val);
    }

    public JList getList() {
        return choosenList;
    }

    public boolean checkRequired() {
        if (getList().getModel().getSize() == 0) {
            XMLPanel.errorMessage(this.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
                    ResourceManager.getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
            return false;
        }
        return true;
    }

    public int getSelectionMode() {
        return selectionMode;
    }

    // 添加操作
    private void addOperation() {
        TreePath[] paths = allPlaceTree.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            if (getSelectionMode() == TreeSelectionModel.SINGLE_TREE_SELECTION) {
                model.removeAllElements();
            }
            for (int i = 0; i < paths.length; i++) {
                TreePath path = paths[i];
                OrgTreeNode node = (OrgTreeNode) path.getLastPathComponent();
                Place place = (Place) node.getUserObject();
                XMLSelectOption elem = new XMLSelectOption(place.getName(), place.getPlaceid());
                if (!model.contains(elem)) {
                    model.addElement(elem);
                }
            }
        }
    }

    // 删除操作
    private void removeOperation() {
        Object[] objs = choosenList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                model.removeElement(obj);
            }
            if (model.size() > 0) {
                choosenList.setSelectedIndex(model.size() - 1);
            }
        }
    }
}
