
package com.ds.bpm.bpd.xml.panels.formula.database;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.common.database.metadata.TableInfo;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XMLESDTablePanel extends XMLPanel {

    private static Dimension minimalDimension = new Dimension(120, 100);

    private static Dimension listDimension = new Dimension(120, 160);

    private List elements = new ArrayList();

    private int selectionMode;

    private ESDClient client;

    // 数据库表
    JList allTableList = new JList();

    // 已选List
    private JList choosenList = new JList();


    // 构造器----显示原有信息
    public XMLESDTablePanel(XMLElement myOwner, String title,
                            boolean hasBorder, boolean minDimension, int selectionMode) throws JDSException {

        super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
        this.selectionMode = selectionMode;

        // 调用Org接口得到服务器的人员角色列表
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
                .getActivedProcessEditor().getGraph().getPropertyObject();
        String projectName = wp.getProjectName();
        this.client = ESDFacrory.getESDClient();

        Project project = this.client.getProjectByName(projectName);

        List<TableInfo> tables = project.getTables();

        allTableList.setListData(tables.toArray(new TableInfo[tables.size()]));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        tableScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        tableScrollPane.setViewportView(allTableList);
        tableScrollPane.setPreferredSize(new Dimension(180, 200));
        allTableList.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() > 1) {
                    addOperation();
                }
            }
        });

        allTableList.setSelectionMode(selectionMode);
        leftPanel
                .add(
                        new JLabel("■ 数据库表"),
                        BorderLayout.NORTH);
        leftPanel.add(tableScrollPane, BorderLayout.CENTER);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.setPreferredSize(new Dimension(182, 250));
        tablePanel.add(leftPanel, BorderLayout.CENTER);

        if (myOwner.toValue() != null
                && !myOwner.toValue().toString().equals("")) {
            String val = myOwner.toValue().toString();
            String[] vals = Utils.tokenize(val,
                    FormulaParameter.DELIMITER_MULTIPLE);
            for (int i = 0; i < vals.length; i++) {
                String table_name = vals[i];
                if (!table_name.trim().equals("")) {
                    elements.add(table_name);
                }
            }
        }

        final DefaultListModel listModel = new DefaultListModel();

        // fills list
        Iterator it = elements.iterator();

        while (it.hasNext()) {
            listModel.addElement(it.next());
        }

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        String a = ResourceManager.getLanguageDependentString("AddKey");
        String r = ResourceManager.getLanguageDependentString("RemoveKey");
        Dimension dim = new Dimension(45, 15);
        XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
        XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
        // 添加按钮的操作
        buttonAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                addOperation();
            }
        });
        // 删除按钮的操作
        buttonRemove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                removeOperation();
            }
        });
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonAdd);
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonRemove);
        buttonPanel.setPreferredSize(new Dimension(80, 60));

        JPanel choosenPanel = new JPanel();
        choosenPanel.setLayout(new BorderLayout());
        JScrollPane choosenScrollPane = new JScrollPane();
        choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        choosenScrollPane.setViewportView(choosenList);
        choosenList.setModel(listModel);
        choosenList.setSelectionMode(selectionMode);
        choosenScrollPane.setPreferredSize(new Dimension(110, 200));
        choosenPanel
                .add(
                        new JLabel("■ 已选库表"),
                        BorderLayout.NORTH);
        choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

        jPanel.add(tablePanel, BorderLayout.WEST);
        jPanel.add(buttonPanel, BorderLayout.CENTER);
        jPanel.add(choosenPanel, BorderLayout.EAST);
        add(jPanel);
    }

    public void setElements() {
        DefaultListModel model = (DefaultListModel) getList().getModel();
        String val = "";
        for (int i = 0; i < model.size(); i++) {
            Object obj = model.get(i);
            val = val + FormulaParameter.DELIMITER_MULTIPLE + obj;
        }
        if (!val.equals("")) {
            val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
        }

        getOwner().setValue(val);
    }

    public JList getList() {
        return choosenList;
    }

    public boolean checkRequired() {
        if (getList().getModel().getSize() == 0) {
            XMLPanel
                    .errorMessage(
                            this.getDialog(),
                            ResourceManager
                                    .getLanguageDependentString("Sys.ErrorDialog.title"),
                            getOwner().toLabel()
                                    + ResourceManager
                                    .getLanguageDependentString("Sys.Colon"),
                            ResourceManager
                                    .getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
            return false;
        }
        return true;
    }

    public int getSelectionMode() {
        return selectionMode;
    }

    // 添加操作
    private void addOperation() {
        Object[] objs = allTableList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            if (getSelectionMode() == ListSelectionModel.SINGLE_SELECTION) {
                model.removeAllElements();
            }
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                if (obj instanceof TableInfo) {
                    String elem = ((TableInfo) obj).getName();
                    if (!model.contains(elem)) {
                        model.addElement(elem);
                    }
                }
            }
        }
    }

    // 删除操作
    private void removeOperation() {
        Object[] objs = choosenList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                model.removeElement(obj);
            }
            if (model.size() > 0) {
                choosenList.setSelectedIndex(model.size() - 1);
            }
        }
    }
}
