/* XMLTableControlPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：表格控制显示面板类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;

/**
 * Creates a control panel for table panel. 表格控制Panel
 */
public class XMLTableControlPanel extends XMLControlPanel {

	public XMLTableControlPanel(XMLCollection myOwner, String title,
			boolean isVertical, boolean hasBorder) {

		super(myOwner, title, isVertical, hasBorder);

		controlledPanel = ((XMLCollection) myOwner).getControlledPanel();

		String n = ResourceManager.getLanguageDependentString("AddKey");
		String e = ResourceManager.getLanguageDependentString("EditKey");
		String d = ResourceManager.getLanguageDependentString("RemoveKey");

		Dimension dim = getPreferredDimension(new String[] { n, e, d });

		XMLButton buttonNew = new XMLButton(n, "AddSmall", dim);
		XMLButton buttonEdit = new XMLButton(e, "EditSmall", dim);
		XMLButton buttonDelete = new XMLButton(d, "RemoveSmall", dim);
		if (isVertical) {
			add(Box.createRigidArea(new Dimension(0, 10)));
		}
		add(buttonNew);
		add(Box.createRigidArea(new Dimension((isVertical) ? 0 : 6,
				(isVertical) ? 6 : 0)));
		add(buttonEdit);
		add(Box.createRigidArea(new Dimension((isVertical) ? 0 : 6,
				(isVertical) ? 6 : 0)));
		add(buttonDelete);
		add(Box.createVerticalGlue());

		buttonNew.setVisible(!myOwner.isReadOnly());
		buttonDelete.setVisible(!myOwner.isReadOnly());

		// action listener for defining new element
		buttonNew.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				addPerform(ae);
			}
		});

		// action listener for modifying selected element
		buttonEdit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				editPerform(ae);
			}
		});

		// action listener for removing selected element
		buttonDelete.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				deletePerform(ae);
			}
		});
	}

	public XMLComplexElement getSelectedElement() {
		return ((XMLTablePanel) controlledPanel).getSelectedElement();
	}

	protected void addElement(XMLComplexElement e) {
		((XMLCollection) getOwner()).add(e);
		JTable t = ((XMLTablePanel) controlledPanel).getTable();
		DefaultTableModel dtm = (DefaultTableModel) t.getModel();
		Vector v = new Vector(e.toComplexTypeValues());
		// add object itself to the first column (it is invisible column)
		v.add(0, e);
		dtm.addRow(v);
		try {
			t.setRowSelectionInterval(t.getRowCount() - 1, t.getRowCount() - 1);
		} catch (Exception ex) {
		}
		t.requestFocus();
	}

	protected void modifyElement(XMLComplexElement e) {
		((XMLTablePanel) controlledPanel).modifyElement(e);
	}

	protected void removeElement(XMLComplexElement e) {
		((XMLTablePanel) controlledPanel).removeElement(e);
	}

	/**
	 * Pops message into message dialog.
	 */
	public void complainLoudly(String message) {
		JOptionPane.showMessageDialog(getDialog(), ResourceManager
				.getLanguageDependentString(message), ResourceManager
				.getLanguageDependentString("Title"),
				JOptionPane.WARNING_MESSAGE);
	}

	protected void addPerform(ActionEvent ae) {
		XMLElement newElement = ((XMLCollection) getOwner())
				.generateNewElement();
		XMLElementDialog de = new XMLElementDialog(getDialog(), newElement
				.toLabel()
				+ " - "
				+ ResourceManager.getLanguageDependentString("DefiningKey"));
		XMLPanel panel = newElement.getPanel();
		de.editXMLElement(panel, true, false);
		// if cancel hasn't been pressed
		if (panel != null && !de.isCanceled()) {
			addElement((XMLComplexElement) newElement);
			((XMLCollection) getOwner()).onElementCreated(newElement);
		}
	}

	protected void editPerform(ActionEvent ae) {
		XMLComplexElement editElement = getSelectedElement();
		if (editElement != null) { // && !editElement.isReadOnly()) {
			XMLElementDialog de = new XMLElementDialog(getDialog(), editElement
					.toLabel()
					+ " '"
					+ editElement.toString()
					+ "' - "
					+ ResourceManager.getLanguageDependentString("EditingKey"));
			de.editXMLElement(editElement.getPanel(), true, false);
			if (!de.isCanceled()) {
				modifyElement(editElement);
				((XMLCollection) getOwner()).onElementModified(editElement);
			}
		} else {
			complainLoudly("WarningEmptySelectionToEditOrDelete");
		}
		((XMLTablePanel) controlledPanel).getTable().requestFocus();
	}

	protected void deletePerform(ActionEvent ae) {
		XMLComplexElement deleteElement = getSelectedElement();
		if (deleteElement == null) {
			complainLoudly("WarningEmptySelectionToEditOrDelete");
		} else if (deleteElement.isReadOnly()) {
			complainLoudly(((XMLCollection) getOwner())
					.getReadOnlyMessageName(deleteElement));
		} else if (!((XMLCollection) getOwner())
				.canRemoveElement(deleteElement)) {
			complainLoudly(((XMLCollection) getOwner())
					.getInUseMessageName(deleteElement));
		} else {
			int yn = JOptionPane
					.showConfirmDialog(
							getDialog(),
							ResourceManager
									.getLanguageDependentString("MessageDoYouReallyWantToRemoveSelectedItem"),
							deleteElement.toLabel()
									+ " '"
									+ deleteElement.toString()
									+ "' - "
									+ ResourceManager
											.getLanguageDependentString("DeletingKey"),
							JOptionPane.YES_NO_OPTION);
			if (yn == JOptionPane.YES_OPTION) {
				removeElement(deleteElement);
				((XMLCollection) getOwner()).onElementDeleted(deleteElement);
				XMLElementDialog.notifyListeners(new XMLElement());
			}
		}
	}
}
