/* XMLRadioPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.GridLayout;
import java.util.Enumeration;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

import com.ds.bpm.bpd.xml.XMLChoice;

/**
 * Creates a panel with radio buttons.
 */
public class XMLRadioPanel extends XMLPanel {
	private ButtonGroup rGroup;

	public XMLRadioPanel(XMLChoice myOwner) {
		this(myOwner, "");
	}

	public XMLRadioPanel(XMLChoice myOwner, String title) {
		this(myOwner, title, XMLPanel.BOX_LAYOUT);
	}

	public XMLRadioPanel(XMLChoice myOwner, String title, int layout) {
		this(myOwner, title, layout, true);
	}

	public XMLRadioPanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical) {
		this(myOwner, title, layout, isVertical, true);
	}

	public XMLRadioPanel(XMLChoice myOwner, String title, int layout,
			boolean isVertical, boolean hasBorder) {

		super(myOwner, 2, title, layout, false, hasBorder);

		XMLPanel bgPanel = new XMLPanel(myOwner, myOwner.getChoices().length,
				"", layout, isVertical, false);

		int noOfElements = myOwner.getChoices().length;

		if (noOfElements > 2) {
			int half = (int) noOfElements / 2;
			if ((double) half != noOfElements / 2)
				half++;
			if (half > 1) {
				bgPanel.setLayout(new GridLayout(half, half));
			} else {
				int m, n;
				if (isVertical) {
					m = 2 * half;
					n = 1;
				} else {
					m = 1;
					n = 2 * half;
				}
				bgPanel.setLayout(new GridLayout(m, n));
			}
		}

		rGroup = new ButtonGroup();
		Object[] c = myOwner.getChoices();
		for (int i = 0; i < c.length; i++) {
			JRadioButton jr = new JRadioButton(c[i].toString());
			if (c[i] == myOwner.getChoosen()) {
				jr.setSelected(true);
			}
			jr.setEnabled(!myOwner.isReadOnly());
			// Group the radio buttons.
			rGroup.add(jr);
			bgPanel.add(jr);
		}
		add(Box.createHorizontalGlue());
		add(bgPanel);
	}

	public void setElements() {
		// if (getOwner() instanceof DTDAttribute) {
		getOwner().setValue(getSelectedItem());
		// }
	}

	public Object getSelectedItem() {
		Enumeration e = rGroup.getElements();
		int i = 0;
		while (e.hasMoreElements()) {
			JRadioButton jr = (JRadioButton) e.nextElement();
			if (jr.isSelected()) {
				return ((XMLChoice) getOwner()).getChoices()[i];
			}
			i++;
		}
		return null;
	}

	public ButtonGroup getButtonGroup() {
		return rGroup;
	}

}

/* End of DTDRadioPanel.java */
