/* XMLLocationPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;

/**
 * Creates panel with JLabel, JTextField and JButton, this panel is used to set
 * the file name from some choosed location.
 */
public class XMLLocationPanel extends XMLPanel {

	private static Dimension locationDimension = new Dimension(175, 20);

	private static Dimension fileButtonDimension = new Dimension(25, 20);

	public XMLLocationPanel(XMLElement myOwner) {
		this(myOwner, XMLPanel.BOX_LAYOUT);
	}

	public XMLLocationPanel(XMLElement myOwner, int layout) {
		this(myOwner, XMLPanel.BOX_LAYOUT, -1);
	}

	public XMLLocationPanel(XMLElement myOwner, int layout,
			final int filteringMode) {

		super(myOwner, 4, "", layout, false, false);

		JLabel jl = new JLabel(myOwner.toLabel() + " ");
		jl.setAlignmentX(Component.LEFT_ALIGNMENT);
		jl.setAlignmentY(Component.BOTTOM_ALIGNMENT);
		jl.setHorizontalAlignment(SwingConstants.RIGHT);
		// jl.setMaximumSize(new Dimension(Short.MAX_VALUE,10));

		final JTextField jtf = new JTextField();
		jtf.setText(myOwner.toValue().toString());
		jtf.setAlignmentX(Component.LEFT_ALIGNMENT);
		jtf.setAlignmentY(Component.BOTTOM_ALIGNMENT);
		jtf.setMinimumSize(new Dimension(locationDimension));
		jtf.setMaximumSize(new Dimension(locationDimension));
		jtf.setPreferredSize(new Dimension(locationDimension));
		jtf.setEnabled(!myOwner.isReadOnly());

		JButton jb = new JButton("...");
		jb.setAlignmentX(Component.LEFT_ALIGNMENT);
		jb.setAlignmentY(Component.BOTTOM_ALIGNMENT);
		jb.setMinimumSize(new Dimension(fileButtonDimension));
		jb.setMaximumSize(new Dimension(fileButtonDimension));
		jb.setPreferredSize(new Dimension(fileButtonDimension));
		jb.setEnabled(!myOwner.isReadOnly());

		add(Box.createHorizontalGlue());
		add(jl);
		add(jtf);
		add(jb);

		jb.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				String fileName = "";
				String message = XMLUtil
						.getLanguageDependentString("DialogChooseFile");
				fileName = XMLUtil.dialog(getDialog(), message, 0, filteringMode,
						null);
				if (fileName != null && fileName.length() > 0) {
					jtf.setText(fileName);
				}
			}
		});
	}

	public boolean checkRequired() {
		if (isEmpty() && getOwner().isRequired() && !getOwner().isReadOnly()) {

			XMLPanel.defaultErrorMessage(this.getDialog(),
					((JLabel) getComponent(1)).getText());
			((JTextField) getComponent(2)).requestFocus();
			return false;
		}
		return true;
	}

	public boolean isEmpty() {
		return getText().trim().equals("");
	}

	public void setElements() {
		getOwner().setValue(getText());
	}

	public String getText() {
		return ((JTextField) getComponent(2)).getText();
	}

}

/* End of DTDLocationPanel.java */
