/* XMLListPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML列表元素的展示面板类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;

/**
 * Creates a list panel. 显示List面板
 */
public class XMLListPanel extends XMLPanel {

	private static Dimension minimalDimension = new Dimension(120, 60);

	private static Dimension listDimension = new Dimension(120, 100);

	/**
	 * Object which we are replacing from one place to another within the list
	 * by draging it.
	 */
	private Object replacingObject;

	/**
	 * Index of the object which we are replacing from one place to another
	 * within the list by draging it.
	 */
	private int startReplaceIndex;

	/**
	 * The new index of the object which we are replacing from one place to
	 * another within the list by draging it.
	 */
	private int endReplaceIndex;

	/** Indicates if object is beeing draged. */
	private boolean dragging = false;

	/**
	 * Indicates if the code for changing object position within the list is
	 * executed.
	 */
	private boolean changing = false;

	// 构造器
	public XMLListPanel(XMLCollection myOwner, String title, boolean hasBorder,
			final boolean enableEditing, boolean minDimension) {

		super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);

		JScrollPane scrollParam = new JScrollPane();
		scrollParam.setAlignmentX(Component.LEFT_ALIGNMENT);
		// scrollParam.setAlignmentY(Component.TOP_ALIGNMENT);

		final DefaultListModel listModel = new DefaultListModel();

		// fills list
		Iterator it = myOwner.toCollection().iterator();

		while (it.hasNext()) {
			XMLElement elem = (XMLElement) it.next();
			listModel.addElement(elem);
		}

		final JList allParam = new JList(listModel);
		allParam.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		allParam.setAlignmentX(Component.LEFT_ALIGNMENT);
		allParam.setAlignmentY(Component.TOP_ALIGNMENT);

		// mouse listener for editing on double-click and dragging list items
		allParam.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent me) {
				// implement some action only if editing is enabled
				if (enableEditing && me.getClickCount() > 1) {
					editElementDialog();
				}
			}

			/** Marks the object which place within the list will be changed. */
			public void mousePressed(MouseEvent me) {
				if (getOwner().isReadOnly())
					return;
				dragging = true;
				JList l = getList();
				replacingObject = null;
				startReplaceIndex = -1;
				try {
					replacingObject = l.getSelectedValue();
					startReplaceIndex = l.getSelectedIndex();
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}

			/** Just indicates that dragging is over. */
			public void mouseReleased(MouseEvent me) {
				dragging = false;
			}

		});

		/** Changes position of object within the list. */
		if (!myOwner.isReadOnly()) {
			allParam.addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent lse) {
					if (dragging && !changing) {
						changing = true;
						JList l = (JList) lse.getSource();
						endReplaceIndex = -1;
						try {
							endReplaceIndex = l.getSelectedIndex();
						} catch (Exception ex) {
							ex.printStackTrace();
						}

						if (replacingObject == null || startReplaceIndex == -1
								|| endReplaceIndex == -1
								|| startReplaceIndex == endReplaceIndex) {
							changing = false;
							return;
						}
						DefaultListModel listModel = (DefaultListModel) l
								.getModel();

						if (((XMLElement) replacingObject).isReadOnly()
								|| ((XMLElement) listModel.get(endReplaceIndex))
										.isReadOnly()) {
							changing = false;
							return;
						}

						listModel.remove(startReplaceIndex);
						listModel.add(endReplaceIndex, replacingObject);
						((XMLCollection) getOwner()).remove(replacingObject);
						((ArrayList) ((XMLCollection) getOwner())
								.toCollection()).add(endReplaceIndex,
								replacingObject);
						try {
							l.setSelectedIndex(endReplaceIndex);
						} catch (Exception ex) {
						}

						if (startReplaceIndex != endReplaceIndex) {
							XMLElementDialog.notifyListeners(getOwner());
						}

						startReplaceIndex = endReplaceIndex;
						changing = false;
					}
				}
			});
			allParam
					.setToolTipText(ResourceManager
							.getLanguageDependentString("MessageDragItemToChangeItsPosition"));
		}

		if (enableEditing) {
			allParam.getInputMap(JComponent.WHEN_FOCUSED)
					.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false),
							"edit");
			allParam.getActionMap().put("edit", new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					editElementDialog();
				}
			});
		}
		allParam.getInputMap(JComponent.WHEN_FOCUSED).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0, false), "delete");
		allParam.getActionMap().put("delete", new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				removeSelectedElement();
			}
		});

		scrollParam.setViewportView(allParam);
		// scrollParam.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		if (!minDimension) {
			scrollParam.setPreferredSize(new Dimension(listDimension));
		} else {
			scrollParam.setPreferredSize(new Dimension(minimalDimension));
		}

		add(scrollParam);

		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

		JButton buttonUp = new JButton();
		java.net.URL u = ResourceManager.getResource("ArrowUpImage");
		if (u != null) {
			buttonUp.setIcon(new ImageIcon(u));
		}
		buttonUp.setEnabled(!myOwner.isReadOnly());
		buttonUp.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				moveItem(0);
			}
		});
		buttonUp.setPreferredSize(new Dimension(25, 25));
		JButton buttonDown = new JButton();
		u = ResourceManager.getResource("ArrowDownImage");
		if (u != null) {
			buttonDown.setIcon(new ImageIcon(u));
		}
		buttonDown.setEnabled(!myOwner.isReadOnly());
		buttonDown.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				moveItem(1);
			}
		});
		buttonDown.setPreferredSize(new Dimension(25, 25));
		p.add(buttonUp);
		p.add(Box.createVerticalGlue());
		p.add(buttonDown);
		add(Box.createRigidArea(new Dimension(5, 0)));
		add(p);
	}

	public boolean isItemChangingPosition() {
		return (changing || dragging);
	}

	public JList getList() {
		JScrollPane jsp = (JScrollPane) getComponent(0);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		JList l = (JList) jvp.getComponent(0);
		return l;
	}

	// 编辑选择的列表项
	private void editElementDialog() {
		XMLElement editElement = null;
		try {
			editElement = (XMLElement) getList().getSelectedValue();
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		if (editElement != null) {
			if (editElement.isReadOnly()) {
				// 默认值不能编辑
				return;
			}
			XMLElementDialog de = new XMLElementDialog((JDialog) getDialog(),
					editElement.toLabel()
							+ " '"
							+ editElement.toString()
							+ "' - "
							+ ResourceManager
									.getLanguageDependentString("EditingKey"));
			de.editXMLElement(editElement.getPanel(), true, false);
			if (!de.isCanceled()) {
				((XMLCollection) getOwner()).onElementModified(editElement);
				paintAll(getGraphics());
			}
		} else {
			if (getList().getModel().getSize() != 0) {
				JOptionPane
						.showMessageDialog(
								getDialog(),
								ResourceManager
										.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
								ResourceManager
										.getLanguageDependentString("Title"),
								JOptionPane.WARNING_MESSAGE);
			}
		}
		getList().requestFocus();
	}

	// 删除所选的列表项
	private void removeSelectedElement() {
		JList l = getList();
		Object obj = null;
		int ind = 0;
		try {
			obj = l.getSelectedValue();
			ind = l.getSelectedIndex();
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		if (obj != null) {
			if (((XMLElement) obj).isReadOnly()) {
				// 默认值不能删除
				return;
			}
			if (((XMLCollection) getOwner()).canRemoveElement((XMLElement) obj)) {
				int yn = JOptionPane
						.showConfirmDialog(
								getDialog(),
								ResourceManager
										.getLanguageDependentString("MessageDoYouReallyWantToRemoveSelectedItem"),
								((XMLElement) obj).toLabel()
										+ " - "
										+ ResourceManager
												.getLanguageDependentString("DeletingKey"),
								JOptionPane.YES_NO_OPTION);
				if (yn == JOptionPane.YES_OPTION) {
					DefaultListModel listModel = (DefaultListModel) l
							.getModel();
					listModel.removeElement(obj);
					((XMLCollection) getOwner()).remove(obj);
					((XMLCollection) getOwner())
							.onElementRemoved((XMLElement) obj);
				} else {
					l.requestFocus();
					return;
				}
			} else {
				String message = "";
				if (obj instanceof XMLComplexElement) {
					message = ResourceManager
							.getLanguageDependentString(((XMLCollection) getOwner())
									.getInUseMessageName((XMLComplexElement) obj));
				}
				JOptionPane.showMessageDialog(getDialog(), message,
						ResourceManager.getLanguageDependentString("Title"),
						JOptionPane.ERROR_MESSAGE);
			}
		} else {
			JOptionPane
					.showMessageDialog(
							getDialog(),
							ResourceManager
									.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
							ResourceManager.getLanguageDependentString("Title"),
							JOptionPane.WARNING_MESSAGE);
		}
		try {
			if (ind == 0) {
				ind++;
			}
			l.setSelectedIndex(ind - 1);
		} catch (Exception ex) {
		}

		l.requestFocus();
	}

	// 移动列表项，参数值为0时上移，为1时下移
	private void moveItem(int upOrDown) {
		changing = true;
		JList l = getList();
		Object rObject = null;
		int sri = -1;
		try {
			rObject = l.getSelectedValue();
			if (((XMLElement) rObject).isReadOnly()) {
				changing = false;
				return;
			}
			sri = l.getSelectedIndex();
		} catch (Exception ex) {
		}
		if (rObject == null || sri == -1) {
			changing = false;
			return;
		}
		DefaultListModel listModel = (DefaultListModel) l.getModel();
		int eri = sri;
		if (upOrDown == 0) {
			eri--;
			if (eri < 0) {
				eri = 0;
			}
			if (((XMLElement) listModel.get(eri)).isReadOnly()) {
				changing = false;
				return;
			}
		} else {
			eri++;
		}
		if (eri > ((XMLCollection) getOwner()).size() - 1) {
			eri = ((XMLCollection) getOwner()).size() - 1;
		}

		listModel.remove(sri);
		listModel.add(eri, rObject);
		((XMLCollection) getOwner()).remove(rObject);
		((ArrayList) ((XMLCollection) getOwner()).toCollection()).add(eri,
				rObject);
		try {
			l.setSelectedIndex(eri);
		} catch (Exception ex) {
		}

		if (sri != eri) {
			XMLElementDialog.notifyListeners(getOwner());
		}

		changing = false;
	}
}
