/* XMLListChoiceControlPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;

import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLChoice;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;

/**
 * Creates a control panel for list choice panel.
 */
public class XMLListChoiceControlPanel extends XMLControlPanel {
	private XMLCollection mySelection;

	public XMLListChoiceControlPanel(XMLCollection myOwner,
			XMLCollection mySel, String title, boolean isVertical,
			boolean hasBorder) {

		super(myOwner, title, isVertical, hasBorder);

		this.mySelection = mySel;
		controlledPanel = ((XMLCollection) myOwner).getControlledPanel();

		String a = XMLUtil.getLanguageDependentString("AddKey");
		String r = XMLUtil.getLanguageDependentString("RemoveKey");
		Dimension dim = getPreferredDimension(new String[] { a, r });

		final XMLButton buttonAdd = new XMLButton(a, "Add", dim);
		final XMLButton buttonRemove = new XMLButton(r, "Remove", dim);

		if (isVertical) {
			add(Box.createRigidArea(new Dimension(0, 10)));
		}
		buttonAdd.setEnabled(!myOwner.isReadOnly());
		buttonRemove.setEnabled(!myOwner.isReadOnly());
		add(buttonAdd);
		add(Box.createRigidArea(new Dimension((isVertical) ? 0 : 5,
				(isVertical) ? 5 : 0)));
		add(buttonRemove);
		if (isVertical) {
			add(Box.createRigidArea(new Dimension(0, 10)));
		}

		buttonRemove.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JList l = ((XMLListChoicePanel) controlledPanel).getList();
				Object obj = null;
				int ind = 0;
				try {
					obj = l.getSelectedValue();
					ind = l.getSelectedIndex();
				} catch (Exception ex) {
				}

				if (obj != null) {
					if (((XMLElement) obj).isRequired()) {
						JOptionPane
								.showMessageDialog(
										getDialog(),
										XMLUtil
												.getLanguageDependentString("ErrorCannotRemoveMandatoryProperty"),
												XMLUtil.getLanguageDependentString("Title"),
										JOptionPane.ERROR_MESSAGE);
						return;
					} else {
						int yn = JOptionPane
								.showConfirmDialog(
										getDialog(),
										XMLUtil
												.getLanguageDependentString("MessageDoYouReallyWantToRemoveSelectedItem"),
										((XMLElement) obj).toLabel()
												+ " - "
												+ XMLUtil
														.getLanguageDependentString("DeletingKey"),
										JOptionPane.YES_NO_OPTION);
						if (yn == JOptionPane.YES_OPTION) {
							DefaultListModel listModel = (DefaultListModel) l
									.getModel();
							listModel.removeElement(obj);
							((XMLCollection) getOwner()).remove(obj);
							((XMLCollection) getOwner())
									.onElementDeleted((XMLElement) obj);
						} else {
							l.requestFocus();
							return;
						}
					}
				} else {
					JOptionPane
							.showMessageDialog(
									getDialog(),
									XMLUtil
											.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
											XMLUtil.getLanguageDependentString("Title"),
									JOptionPane.WARNING_MESSAGE);
				}
				try {
					if (ind == 0) {
						ind++;
					}
					l.setSelectedIndex(ind - 1);
				} catch (Exception ex) {
				}

				l.requestFocus();
			}
		});

		buttonAdd.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JList l = ((XMLListChoicePanel) controlledPanel).getList();
				DefaultListModel listModel = (DefaultListModel) l.getModel();
				int size = listModel.getSize();

				XMLElement[] choices = new XMLElement[mySelection
						.getChoosable().size()];
				mySelection.getChoosable().toArray(choices);
				XMLChoice ch = new XMLChoice("Select", choices) {
					public XMLPanel getPanel() {
						return new XMLComboButtonPanel(this, mySelection);
					}
				};
				ch.setRequired(true);
				String label = mySelection.toLabel() + " - "
						+ XMLUtil.getLanguageDependentString("SelectKey");
				XMLElementDialog de = new XMLElementDialog(getDialog(), label);
				de.editXMLElement(ch.getPanel(), true, false);
				// if cancel hasn't been pressed
				if (!de.isCanceled()) {
					XMLElement newElement = ((XMLCollection) getOwner())
							.generateNewElement();
					newElement.setValue(ch.getChoosen());
					listModel.addElement(newElement);
					l.setSelectedIndex(size);
					((XMLCollection) getOwner()).add(newElement);
					((XMLCollection) getOwner()).onElementCreated(newElement);
				}
				l.requestFocus();
			}
		});
	}

}
