/* XMLPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.xml.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Window;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

import com.ds.bpm.bpd.xml.NewXMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;

public class NewXMLPanel extends JPanel {

   public static int GRID_LAYOUT=0;
   public static int BOX_LAYOUT=1;

   protected NewXMLElement myOwner;
   private String title;

   public NewXMLPanel () {
      super();
   }

   public NewXMLPanel (NewXMLElement myOwner,int noOfElements,String title,int layout,
      boolean isVertical,boolean hasBorder) {

      super();

      this.myOwner=myOwner;

      setTitle(title,hasBorder);

      if (layout==NewXMLPanel.BOX_LAYOUT) {
         setLayout(new BoxLayout(this,((isVertical) ? BoxLayout.Y_AXIS:BoxLayout.X_AXIS)));
      }
      else {
         setLayout(new GridLayout
            (((isVertical) ? noOfElements : 1),((isVertical) ? 1 : noOfElements)));
      }
      setAlignmentX(Component.LEFT_ALIGNMENT);
      setAlignmentY(Component.TOP_ALIGNMENT);

      if (myOwner!=null) {
         setEnabled(!myOwner.isReadOnly());
      }

   }

   public void setTitle (String title,boolean hasBorder) {
      this.title=title;

      int emptyBorderHSize=5;
      int emptyBorderVSize=1;

      Border emptyb=BorderFactory.createEmptyBorder(emptyBorderVSize,emptyBorderHSize,
         emptyBorderVSize,emptyBorderHSize);
      Border inb=BorderFactory.createEmptyBorder(0,0,0,0);
      if (hasBorder) {
         inb=BorderFactory.createMatteBorder(1,1,1,1,Color.darkGray);
         inb=BorderFactory.createTitledBorder(inb,title);
      }
      else {
         emptyb=BorderFactory.createTitledBorder(emptyb,title);
      }
      setBorder(BorderFactory.createCompoundBorder(emptyb,inb));
   }

   public static void defaultErrorMessage (Window w,String elementTitle) {
      String message=XMLUtil.getLanguageDependentString("ErrorValueMustBeDefined");
      String dialogTitle=XMLUtil.getLanguageDependentString("DialogValueIsNotDefined");
      NewXMLPanel.errorMessage(w,dialogTitle,elementTitle,message);
   }

   public static void errorMessage (Window w,String dialogTitle,String elementTitle,String message) {
      JOptionPane.showMessageDialog(w,elementTitle+message,
         dialogTitle,JOptionPane.ERROR_MESSAGE);
   }

   public NewXMLElement getOwner () {
      return myOwner;
   }

   public String getTitle() {
      return title;
   }

   /**
   * Checks if the element that owns panel
   */
   public boolean checkRequired () {
      return true;
   }

   // Always returns true, this is set because of panels that are never empty
   // but this method is used when checking emptiness of group panel,
   // and panels that do not override this method should not be ever considered
   public boolean isEmpty () {
      return true;
   }

   public void setElements () {
      return;
   }

   /**
   * Find the hosting dialog.
   */
   public JDialog getDialog () {
      for (Container p = getParent(); p != null; p = p.getParent()) {
         if (p instanceof JDialog) {
            return (JDialog)p;
         }
      }
      return null;
   }

}
