/* XMLControlPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.xml.panels;

import java.awt.Dimension;

import com.ds.bpm.bpd.xml.NewXMLCollection;

public abstract class NewXMLControlPanel extends NewXMLPanel {
   protected NewXMLPanel controlledPanel;


   public NewXMLControlPanel (NewXMLCollection myOwner,String title,
      boolean isVertical,boolean hasBorder) {
      super(myOwner,0,title,NewXMLPanel.BOX_LAYOUT,isVertical,hasBorder);
   }

   public void setControlledPanel(NewXMLPanel controlledPanel) {
      this.controlledPanel = controlledPanel;
   }

   protected Dimension getPreferredDimension (String[] s) {
      double longest=0;
      double w=0;
      for (int i=0;i<s.length; i++) {
         String n=s[i];
         try {
            w=getFontMetrics(getFont()).stringWidth(s[i]);
            if (w>longest) longest=w;
         } catch(Exception ex) {}
      }
      double h=getFontMetrics(getFont()).getHeight();

      w=longest+25;
      //w=longest+20;
      if (w<30) w=30;

      return new Dimension((int)w,(int)h);
   }

}
