/*
 * Created on 2004-4-1
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements.formula.org;

import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.formula.Formula;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.formula.org.XMLPersonPanel;
import com.ds.bpm.formula.ExpressionParameter;

import javax.swing.*;


public class FormulaPersonParameter extends FormulaParameter {

    /**
     * 构造器
     */
    public FormulaPersonParameter() {
        super();
    }

    /**
     * 构造器
     *
     * @param parent
     * @param param
     */
    public FormulaPersonParameter(Formula parent, ExpressionParameter param) {
        super(parent, param);
    }

    public XMLPanel getPanel() {
        String title = param.getParameterDesc();
        if (title == null || title.trim().equals("")) {
            title = param.getParameterName();
        }
        int model = param.getSingle() ? ListSelectionModel.SINGLE_SELECTION : ListSelectionModel.MULTIPLE_INTERVAL_SELECTION;
        return new XMLPersonPanel(this, title, true, true, model);
    }

    public String getParamValue() {
        String val = param.getParameterCode() + "=";
        if (toValue() instanceof XMLSelectOption) {
            val = val + ((XMLSelectOption) toValue()).getText();
        } else {
            val = val + toValue().toString();
        }
        return val;
    }


}
