/*
 * Created on 2004-4-6
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements.formula.iot;

import com.ds.bpm.bpd.xml.elements.formula.Formula;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.formula.iot.XMLIOTDeviceTypePanel;
import com.ds.bpm.formula.ExpressionParameter;

import javax.swing.*;


public class FormulaDeviceTypeParameter extends FormulaParameter {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 构造器
     */
    public FormulaDeviceTypeParameter() {
        super();
    }

    /**
     * 构造器
     *
     * @param parent
     * @param param
     */
    public FormulaDeviceTypeParameter(Formula parent, ExpressionParameter param) {
        super(parent, param);
    }

    public XMLPanel getPanel() {
        String title = param.getParameterDesc();
        if (title == null || title.trim().equals("")) {
            title = param.getParameterName();
        }
        int model = param.getSingle() ? ListSelectionModel.SINGLE_SELECTION : ListSelectionModel.MULTIPLE_INTERVAL_SELECTION;

        return new XMLIOTDeviceTypePanel(this, title, true, true,
                model);
    }


    public String getParamValue() {
        String val = param.getParameterCode() + "=";
        val = val + toValue().toString();
        return val;
    }
}
