/* FormalParameter.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.JTextField;

import org.w3c.dom.Node;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.elements.BasicType;
import com.ds.bpm.bpd.xml.elements.DataType;
import com.ds.bpm.bpd.xml.elements.DataTypes;
import com.ds.bpm.bpd.xml.elements.DeclaredType;
import com.ds.bpm.bpd.xml.elements.Description;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class FormalParameter extends XMLCollectionElement {
	private DataType refDataType;

	private Description refDescription = new Description(); // min=0

	private XMLAttribute attrIndex = new XMLAttribute("Index");

	// default="IN"
	private XMLAttribute attrMode = new XMLAttribute("Mode", new String[] { "",
			"IN", "OUT", "INOUT" }, 1);

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param fps
	 *            The reference to collection of formal parameters where this
	 *            instance will be put into.
	 * @param p
	 *            The package which elements holds instance of of this class.
	 */
	public FormalParameter(FormalParameters fps, Package p) {
		super(fps);

		refDataType = new DataType(p);
		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		super.fillStructure();
		// allow ID to be modified if this is a formal parameter of workflow
		// process
		if (myCollection.getOwner() instanceof WorkflowProcess) {
			attrId.setValue("");
		}
		complexStructure.add(attrIndex);
		attributes.add(attrIndex);
		complexStructure.add(attrMode);
		attributes.add(attrMode);
		refDataType.setRequired(true);
		complexStructure.add(refDataType);
		complexStructure.add(refDescription);
	}

	public void fromXML(Node node) {
		attrMode.setValue("");
		super.fromXML(node);
	}

	/**
	 * Checks if an ID entered by the user is unique.
	 */
	public boolean isIDUniqueAndValid(XMLPanel groupPanel) {
		XMLTextPanel tp = (XMLTextPanel) ((XMLGroupPanel) groupPanel)
				.getPanel(0);
		String IDToCheck = tp.getText();
		// if there is an element with given ID, return false
		FormalParameter fp = ((FormalParameters) getCollection())
				.getFormalParameter(IDToCheck);
		boolean isOK = true;
		String message = null;
		String dialogTitle = null;
		if (fp != null && fp != this) {
			message = XMLUtil.getLanguageDependentString("ErrorIDMustBeUnique");
			dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotUnique");
			isOK = false;
		} else if (!XMLCollection.isIdValid(IDToCheck)) {
			message = XMLUtil.getLanguageDependentString("ErrorIDMustBeValid");
			dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotValid");
			isOK = false;
		}
		if (!isOK) {
			XMLPanel.errorMessage(groupPanel.getDialog(), dialogTitle, "",
					message);
			((JTextField) tp.getComponent(2)).requestFocus();
		}
		return isOK;
	}

	public String toString() {
		if (myCollection.getOwner() instanceof WorkflowProcess) {
			return attrId.toString();
		} else {
			return super.toString();
		}
	}

	/**
	 * Overrides parent method to display data type details for BasicType and
	 * for DeclaredType.
	 */
	public Collection toComplexTypeValues() {
		java.util.List l = new ArrayList();
		Iterator it = complexStructure.iterator();
		while (it.hasNext()) {
			XMLElement el = (XMLElement) it.next();
			if (el instanceof XMLAttribute) {
				l.add(el.toString());
			} else if (el instanceof DataType) {
				DataType dt = (DataType) el;
				DataTypes dtt = (DataTypes) dt.get("Type");
				Object type = dtt.toValue();
				if (type instanceof BasicType) {
					l.add(el.toValue()
							+ " - "
							+ ((XMLAttribute) ((BasicType) type).get("Type"))
									.getChoosen());
				} else if (type instanceof DeclaredType) {
					l.add(el.toValue()
							+ " - "
							+ ((XMLComplexChoice) ((DeclaredType) type)
									.get("SubType")).getChoosen());
				} else {
					l.add(el.toValue());
				}
			} else {
				l.add(el.toValue());
			}
		}
		return l;
	}

}
