/* WorkflowProcesses.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的工作流集合类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.activity.Activities;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>WorkflowProcess</b> instances. 工作流集合类
 */
public class WorkflowProcesses extends XMLCollection {

	private ArrayList externalProcesses = new ArrayList();

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param p
	 *            The container for all processes.
	 */
	public WorkflowProcesses(Package p) {
		super(p);
	}

	public boolean isMine(WorkflowProcess wp) {
		return refCollectionElements.contains(wp);
	}

	protected void addPropertyToAllActivities(UserProperty up) {
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			wp.addPropertyToAllActivities(up);
		}
	}

	protected void removePropertyFromAllActivities(UserProperty up) {
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			wp.removePropertyFromAllActivities(up);
		}
	}

	protected void refreshMandatories(UserProperty up) {
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			wp.refreshMandatories(up);
		}
	}

	// min=0, max=unbounded
	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		
		
		WorkflowProcess wp = new WorkflowProcess(this, (Package) myOwner,new WFApplication(),false,null);
		wp.setRequired(true);
		return wp;
	}

	/**
	 * Returns a workflow process with specified ID.
	 * 
	 * @param ID
	 *            The 'Id' attribute of wanted instance of WorkflowProcess
	 *            element defined within a XML file.
	 * @return Returns the instance of WorkflowProcess element that have the
	 *         specified ID as an 'Id' attribute if it exist among all defined
	 *         processes within package, if it doesn't exist, <tt>null</tt> is
	 *         returned.
	 */
	public WorkflowProcess getWorkflowProcess(String ID) {
		WorkflowProcess wp = (WorkflowProcess) super.getCollectionElement(ID);
		// if the process haven't been found, search external processes
		if (wp == null) {
			String extID;
			Iterator it = externalProcesses.iterator();
			while (it.hasNext()) {
				WorkflowProcess wptmp = (WorkflowProcess) it.next();
				extID = wptmp.getID();
				if (extID.equals(ID)) {
					wp = wptmp;
					break;
				}
			}
		}
		return wp;
	}

	/**
	 * Returns the collection of processes defined in the current package. It
	 * doesn't include processes from referenced external packages.
	 */
	public Collection getTableElements() {
		// ArrayList chos=new ArrayList(externalProcesses);
		// chos.addAll(refCollectionElements);
		ArrayList chos = new ArrayList(refCollectionElements);
		return chos;
	}

	/**
	 * Returns collection of all workflow processes from current package and
	 * processes from referenced external packages, but leaving out the
	 * processes from external packages which Id is equal to any of current
	 * package processes Ids.
	 */
	public Collection getChoosable() {
		ArrayList chos = new ArrayList(refCollectionElements);
		Iterator i = externalProcesses.iterator();
		while (i.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) i.next();
			if (getCollectionElement(wp.getID()) == null) {
				chos.add(wp);
			}
		}
		return chos;
	}

	/**
	 * Checks if specified workflow process can be removed. Workflow process can
	 * be removed only if it is not referenced within any subflow.
	 */
	public boolean canRemoveElement(XMLElement el) {
		boolean remove = true;
		WorkflowProcess toRemove = (WorkflowProcess) el;
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			// do not check itself and external workflows
			if (wp != toRemove) {
				Activities acts = (Activities) wp.get("Activities");
				remove = acts.canRemoveWorkflow(toRemove);
				if (!remove) {
					break;
				}
				ActivitySets actsts = (ActivitySets) wp.get("ActivitySets");
				remove = actsts.canRemoveWorkflow(toRemove);
				if (!remove) {
					break;
				}
			}
		}
		return remove;
	}

	public Collection getExternalWorkflowProcesses() {
		return externalProcesses;
	}

	public WorkflowProcess createCopyOfWorkflowProcess(WorkflowProcess wp) {
		if (wp == null)
			return null;

		Package mine = (Package) myOwner;
		Package ext = wp.getPackage();

		Document document = null;
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder dbuilder = dbf.newDocumentBuilder();
			document = dbuilder.newDocument();
		} catch (Exception ex) {
		}
		ext.toXML(document);

		WorkflowProcess copyOfWP = (WorkflowProcess) generateNewElement();
		String ID = copyOfWP.getID();

		NodeList nl = document.getElementsByTagName("WorkflowProcess");
		Node wantedWorkflowNode = null;
		if (nl.getLength() > 0) {
			String extID = wp.getID();
			for (int i = 0; i < nl.getLength(); i++) {
				Node n = nl.item(i);
				String IDOfNode = XMLUtil.getID(n);
				if (IDOfNode.equals(extID)) {
					wantedWorkflowNode = n;
					break;
				}
			}
		} else {
			return null;
		}

		if (wantedWorkflowNode == null)
			return null;
		// String XML=wp.toXML(null,0).trim(); // trimming is neccessary for our
		// parser
		copyOfWP.readFromXML(wantedWorkflowNode);

		// Add all TypeDeclarations from package of wp that we want to import
		// to the current package
		TypeDeclarations mineTD = (TypeDeclarations) mine
				.get("TypeDeclarations");
		TypeDeclarations extTD = (TypeDeclarations) ext.get("TypeDeclarations");
		TypeDeclarations tmpTD = new TypeDeclarations((Package) myOwner);
		// I'm doing this to avoid to implement complex cloning
		// NOTE: can't just add all TDs from extTD directly - it would be the
		// same objects
		// that would be read only
		nl = document.getElementsByTagName("TypeDeclarations");
		if (nl.getLength() > 0) {
			Node n = nl.item(0);
			tmpTD.fromXML(n);
		}
		// String TDXml=extTD.toXML(null,0).trim(); // trimming is neccessary
		// for our parser
		// tmpTD.fromXML(null,TDXml);
		// Do not add type dec. if it already exists
		Iterator it = tmpTD.toCollection().iterator();
		while (it.hasNext()) {
			TypeDeclaration td = (TypeDeclaration) it.next();
			if (mineTD.getDeclaredType(td.getID()) == null) {
				mineTD.toCollection().add(td);
			}
		}

		// put all DataFields defined at the
		// package level of imported workflow process to the workflow process
		// level of the newly created workflow process
		DataFields extDF = (DataFields) ext.get("DataFields");
		DataFields copyDF = (DataFields) copyOfWP.get("DataFields");
		DataFields tmpDF = new DataFields((Package) myOwner);
		// I'm doing this to avoid to implement complex cloning
		// NOTE: can't just add all DFs from copyDF directly - it would be the
		// same objects
		// that would be read only
		// String DFXml=extDF.toXML(null,0).trim(); // trimming is neccessary
		// for our parser
		nl = document.getElementsByTagName("DataFields");
		if (nl.getLength() > 0) {
			Node n = nl.item(0);
			tmpDF.fromXML(n);
		}
		// tmpDF.fromXML(null,DFXml);
		copyDF.toCollection().addAll(tmpDF.toCollection());

		// do not process external user properties
		copyOfWP.afterImporting(false);

		// Seting user defined properties of current package
		UserProperties up = ((Package) myOwner)
				.getUserDefinedActivityProperties();
		Set mandatoryProps = up.getMandatoryProperties();
		it = mandatoryProps.iterator();
		while (it.hasNext()) {
			UserProperty upr = (UserProperty) it.next();
			copyOfWP.addPropertyToAllActivities(upr);
		}

		// Setting back newly generated ID (do not keep ID of external workflow
		// process)
		copyOfWP.set("Id", ID);
		// add it to collection
		refCollectionElements.add(copyOfWP);
		return copyOfWP;
	}

	
	/**
	 * add by wenzhang 添加得到所有主流程的方法
	 * @return 
	 */
	public List getMainProceList(){
		List mainProcesses=new ArrayList();
		//this.mainProcesses=this.getMainProcessList();
		Collection wps=this.toCollection();
		for (int i=0;wps.size()>i;i++){
			WorkflowProcess wp=(WorkflowProcess)(wps.toArray())[i];
			if (!wp.isSubFlow()){
				mainProcesses.add(wp);
			}
		}
		return mainProcesses;
	}
	
	/**
	 *
	 */
	protected void insertFromExternal(Package ep) {
		WorkflowProcesses externalWPs = (WorkflowProcesses) ep
				.get("WorkflowProcesses");
		// insert only the workflows that owns package 'ep'
		// and are not referenced from some ext. pack. of 'ep'
		Iterator it = externalWPs.refCollectionElements.iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			if (!externalProcesses.contains(wp)) {
				externalProcesses.add(wp);
			}
		}
		/*
		 * System.out.println("WPS before for package
		 * "+myOwner+"="+refCollectionElements);
		 * refCollectionElements.addAll(externalWPs.refCollectionElements);
		 * System.out.println("WPS after for package
		 * "+myOwner+"="+refCollectionElements);
		 */
	}

	/**
	 *
	 */
	protected void removeFromExternal(Package ep) {
		WorkflowProcesses externalWPs = (WorkflowProcesses) ep
				.get("WorkflowProcesses");

		Iterator it = externalWPs.toCollection().iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			externalProcesses.remove(wp);
		}
	}

	public int[] getInvisibleTableFieldOrdinals() {
		int[] itfo = new int[10];
		itfo[0] = 3;
		itfo[1] = 4;
		itfo[2] = 5;
		itfo[3] = 6;
		itfo[4] = 7;
		itfo[5] = 8;
		itfo[6] = 9;
		itfo[7] = 10;
		itfo[8] = 11;
		itfo[9] = 12;
		return itfo;
	}

	/**
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		isReadOnly = true;
		return super.getPanel();
	}

	public void refreshCollection(Set elementsToAddOrRemove, boolean append) {
		super.refreshCollection(elementsToAddOrRemove, append);
		if (append) {
			Iterator it = refCollectionElements.iterator();
			while (it.hasNext()) {
				WorkflowProcess wp = (WorkflowProcess) it.next();
				if (isMine(wp)) {
					wp.setIDPrefixForCollections();
				}
			}
		}
	}
	 public WorkflowProcess createCopyOfWorkflowProcess (WorkflowProcess wp,boolean localCopy) {
	      if (wp==null) return null;

	      Package mine=(Package)myOwner;
	      Package ext=wp.getPackage();

	      Document document=null;
	      try {
	         DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
	         DocumentBuilder dbuilder = dbf.newDocumentBuilder();
	         document = dbuilder.newDocument();
	      } catch (Exception ex) {}
	      ext.toXML(document);


	      WorkflowProcess copyOfWP=(WorkflowProcess)generateNewElement();
	      String ID=copyOfWP.getID();

	      NodeList nl=document.getElementsByTagName("WorkflowProcess");
	      Node wantedWorkflowNode=null;
	      if (nl.getLength()>0) {
	         String extID=wp.getID();
	         for (int i=0; i<nl.getLength(); i++) {
	            Node n=nl.item(i);
	            String IDOfNode=XMLUtil.getID(n);
	            if (IDOfNode.equals(extID)) {
	               wantedWorkflowNode=n;
	               break;
	            }
	         }
	      } else {
	         return null;
	      }

	      if (wantedWorkflowNode==null) return null;
	      //String XML=wp.toXML(null,0).trim(); // trimming is neccessary for our parser
	      copyOfWP.readFromXML(wantedWorkflowNode);

	      if(!localCopy) {
	         // Add all TypeDeclarations from package of wp that we want to import
	         // to the current package
	         TypeDeclarations mineTD=(TypeDeclarations)mine.get("TypeDeclarations");
	         TypeDeclarations extTD=(TypeDeclarations)ext.get("TypeDeclarations");
	         TypeDeclarations tmpTD=new TypeDeclarations((Package)myOwner);
	         // I'm doing this to avoid to implement complex cloning
	         // NOTE: can't just add all TDs from extTD directly - it would be the same objects
	         //       that would be read only
	         nl=document.getElementsByTagName("TypeDeclarations");
	         if (nl.getLength()>0) {
	            Node n=nl.item(0);
	            tmpTD.fromXML(n);
	         }
	         //String TDXml=extTD.toXML(null,0).trim(); // trimming is neccessary for our parser
	         //tmpTD.fromXML(null,TDXml);
	         // Do not add type dec. if it already exists
	         Iterator it=tmpTD.toCollection().iterator();
	         while (it.hasNext()) {
	            TypeDeclaration td=(TypeDeclaration)it.next();
	            if (mineTD.getDeclaredType(td.getID())==null) {
	               mineTD.toCollection().add(td);
	            }
	         }

	         // put all DataFields defined at the
	         // package level of imported workflow process to the workflow process
	         // level of the newly created workflow process
	         DataFields extDF=(DataFields)ext.get("DataFields");
	         DataFields copyDF=(DataFields)copyOfWP.get("DataFields");
	         DataFields tmpDF=new DataFields((Package)myOwner);
	         // I'm doing this to avoid to implement complex cloning
	         // NOTE: can't just add all DFs from copyDF directly - it would be the same objects
	         //       that would be read only
	         //String DFXml=extDF.toXML(null,0).trim(); // trimming is neccessary for our parser
	         nl=document.getElementsByTagName("DataFields");
	         if (nl.getLength()>0) {
	            Node n=nl.item(0);
	            tmpDF.fromXML(n);
	         }
	         //tmpDF.fromXML(null,DFXml);
	         copyDF.toCollection().addAll(tmpDF.toCollection());
	      }

	      // do not process external user properties
	      copyOfWP.afterImporting(true);

	      // Setting back newly generated ID (do not keep ID of external workflow process)
	      copyOfWP.set("Id",ID);
	      if (localCopy) {
	         copyOfWP.set("Name",
	                      XMLUtil.getLanguageDependentString("CopyOfKey")+
	                         " "+copyOfWP.get("Name").toString());
	      }
	      
	      // add it to collection
	      refCollectionElements.add(copyOfWP);
	      return copyOfWP;
	   }
	/**
	 * Overrides parent method to be accessible within PEGraph.
	 */
	public void decrementID() {
		super.decrementID();
	}

	/**
	 * Overrides parent method to be accessible within workflow process.
	 */
	protected void updateID(String someID) {
		super.updateID(someID);
	}
}
