/* Transition.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Description：路由属性类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.config.AppConfigManager;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginManager;
import com.ds.bpm.bpd.xml.*;
import com.ds.bpm.bpd.xml.activity.Activities;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.panels.*;
import com.ds.bpm.enums.route.RouteEnums;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CParameter;
import com.ds.config.PluginType;
import com.ds.enums.EnumsUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Point2D;
import java.util.*;
import java.util.List;

/**
 * Represents a WfMC DTD element that has the similar name.
 */
public class Transition extends XMLCollectionElement {
    public static final String ROUTING_TYPE = "ROUTINGTYPE";

    public static final String NO_ROUTING = "NOROUTING";

    public static final String SIMPLE_ROUTING = "SIMPLEROUTING";

    // 定义路由属性面板的组件
    private Condition refCondition = new Condition(); // min==0

    private Description refDescription = new Description(); // min=0

    private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);

    // min=0

    private XMLAttribute attrFrom = new XMLAttribute("From"); // required

    private XMLAttribute attrTo = new XMLAttribute("To"); // required

    private XMLAttribute attrName = new XMLAttribute("Name");


    private XMLAttribute imgClass = new XMLAttribute("ImgClass");


    private XMLAttribute attrRouteOrder = new XMLAttribute("RouteOrder");

    private XMLAttribute attrDirection = new XMLAttribute(EnumsUtil.getAttribute(RouteEnums.RouteDirction));

    /**
     * The workflow element which is source for transition
     */
    // XML文件工作流定义中路由的触发活动元素
    private transient XMLComplexElement from = null;

    /**
     * The workflow element which is tareget for transition
     */
    // XML文件工作流定义中路由的到达活动元素
    private transient XMLComplexElement to = null;

    /**
     * The map that holds data about break points for graph object.
     */
    // 路由转折点的图形对象集合
    private Map ordNoToPoint = new HashMap();

    /**
     * The type of graphical routing of transition.
     */
    private String routingType;

    /**
     * Enables canceling of changes to the extended attributes collection.
     */
    private ExtendedAttributes clonedEAs;

    // 插件工具类
    private transient PluginManager manager;

    // 活动插件属性集
    private transient Map plugins;

    // 监听器
    private Listeners listeners = new Listeners(this);

    // 流程原插件属性集
    private transient Map oldPlugins = new HashMap();

    private WorkflowProcess myWorkflow = null;

    /**
     * Creates a new instance of the class.
     *
     * @param ts
     *            The reference to collection of Transitions where this instance will be put into.
     */

    /***************************************************************************
     * add by wenzhang li 2006-02-21 原程序中如果 Transition 是 ActivitySet中时会造成 this.myWorkflow 类型转换错误(WorkflowProcess)
     * getCollection().getOwner()得到的是ActivitySet 加了一个判断程序 循环得到WorkflowProcess对象
     */
    private WorkflowProcess getWorkflowProcess(XMLComplexElement xmlComplexElement) {

        if (xmlComplexElement instanceof ActivitySet) {
            xmlComplexElement = this.myWorkflow = (WorkflowProcess) ((ActivitySet) getCollection().getOwner()).getCollection().getOwner();
            getWorkflowProcess(xmlComplexElement);
        }
        return (WorkflowProcess) xmlComplexElement;
    }

    public Transition(Transitions ts) {
        super(ts);
        XMLComplexElement xmlComplexElement = getCollection().getOwner();
        this.myWorkflow = getWorkflowProcess(xmlComplexElement);

        // this.myWorkflow = (WorkflowProcess) getCollection().getOwner();//old
        fillStructure();
        loadPlugins();
        fillPlugins();
        // 初始化页面显示

        attrId.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.ID.display"));
        attrName.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.Name.display"));
        attrRouteOrder.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.RouteOrder.display"));
        attrDirection.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.RouteDirection.display"));
        refCondition.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.Condition.display"));
        refDescription.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.Description.display"));
        imgClass.setLabelName("按钮图标");
    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    protected void fillStructure() {
        super.fillStructure();
        attrId.setReadOnly(true);
        attrFrom.setReadOnly(true);
        attrTo.setReadOnly(true);

        // 添加路由名称属性
        complexStructure.add(attrName);
        attributes.add(attrName);
        // 添加触发活动属性
        attrFrom.setRequired(true);
        complexStructure.add(attrFrom);
        attributes.add(attrFrom);
        // 添加到达活动属性
        attrTo.setRequired(true);
        complexStructure.add(attrTo);
        attributes.add(attrTo);
        // 添加路由条件属性
        complexStructure.add(refCondition);
        // 添加路由描述属性
        complexStructure.add(refDescription);
        // 添加路由扩展属性
        complexStructure.add(refExtendedAttributes);

        complexStructure.add(imgClass);
        ExtendedAttribute ea;
        // 添加顺序编号到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ((ArrayList) refExtendedAttributes.toCollection()).add(ea);
        ea.set("Name", attrRouteOrder.toName());
        ea.set("Value", attrRouteOrder.toValue());

        // 把监听器属性加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.get("Value").setRequired(false);
        ea.set("Name", listeners.toName());
        ea.setAnyXMLCollection(listeners);
        ((ArrayList) refExtendedAttributes.toCollection()).add(ea);
        // 添加路由方向到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ((ArrayList) refExtendedAttributes.toCollection()).add(ea);
        ea.set("Name", attrDirection.toName());
        ea.set("Value", attrDirection.toValue());


    }

    public void setRoutingType(String rType) {
        routingType = rType;
    }

    public String getRoutingType() {
        return routingType;
    }

    /**
     * Returns the map of break points of transition graph object. The map keys are point indexes (the position of point
     * on transition graph object), and the values are Point objects.
     */
    public Map getBreakPoints() {
        return ordNoToPoint;
    }

    /**
     * Sets the map of break points of transition graph object. The map keys are point indexes (the position of point on
     * transition graph object), and the values are Point objects.
     */
    public void setBreakPoints(Map breakPoints) {
        ordNoToPoint = breakPoints;
    }

    /*
     * Sets the source element for transition. @param from The source element for the transition.
     */
    public void setFrom(XMLElement from) {
        this.from = (XMLComplexElement) from;
        if (from != null) {
            attrFrom.setValue(this.from.get("Id").toValue());
        }

    }

    /*
     * Sets the target element for transition. @param to The target element for the transition.
     */
    public void setTo(XMLElement to) {
        this.to = (XMLComplexElement) to;
        if (to != null) {
            attrTo.setValue(this.to.get("Id").toValue());
        }
    }

    /*
     * Gets the source element for transition. @return The source element for the transition.
     */
    public XMLComplexElement getFrom() {
        return from;
    }

    /*
     * Gets the target element for transition. @return The target element for the transition.
     */
    public XMLComplexElement getTo() {
        return to;
    }

    /**
     * Prepares the panel with all editable (and non-editable) elements which defines a transition.
     *
     * @return XMLPanel to be shown.
     */
    public XMLPanel getPanel() {
        try {
            // 路由Panel集合
            List panels = new ArrayList();
            XMLElement f = new XMLAttribute("From");
            f.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.From.display"));
            f.setValue(from.toString());
            f.setReadOnly(true);
            XMLElement t = new XMLAttribute("To");
            t.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.To.display"));
            t.setValue(to.toString());
            t.setReadOnly(true);
            String generalAttributesLabel = ResourceManager.getLanguageDependentString("Transition.General.display");
            XMLGroupPanel generalAttributesPanel = new XMLGroupPanel(this, new XMLElement[]{attrId, attrName, f, t, attrRouteOrder, attrDirection, refCondition, refDescription}, generalAttributesLabel);
            panels.add(generalAttributesPanel);
            panels.add(this.listeners.getPanel());
            for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                panels.add(((PluginElement) entry.getValue()).getPanel());
            }
            XMLTabbedPanel p = new XMLTabbedPanel(this, (XMLPanel[]) panels.toArray(new XMLPanel[panels.size()])) {
                public void setElements() {
                    super.setElements();
                    if (BPD.getInstance().getActivedProcessEditor() != null) {
                        BPD.getInstance().getActivedProcessEditor().getGraph().refreshTransitionGraph();
                    }

                }
            };
            return p;

        } catch (Exception ex) {
            ex.printStackTrace();
            XMLElement el = new XMLElement("ErrorMessage") {
                public XMLPanel getPanel() {
                    setReadOnly(true);
                    value = ResourceManager.getLanguageDependentString("ErrorGraphObjectIsNotDefined");
                    return new XMLMultiLineTextPanel(this);
                }
            };
            return el.getPanel();
        }
    }

    /**
     * Overrides super-class method to retreive the name of target activity for this transition. This is used when
     * displaying instance of this class within combo box at one of Activities buttonviews panel.
     *
     * @return The name of target activity for transition.
     */
    public String toString() {
        if (attrName != null) {
            return attrName.toString();
        } else {
            return "";
        }
    }

    /**
     * Indicates wether the condition for transition is defined or not.
     *
     * @return <tt>true</tt> if this transition has condition that needs to be accomplished before the control is given
     * to next activity, <tt>false</tt> otherwise.
     */
    public boolean hasCondition() {
        return refCondition.toString().trim().length() > 0;
    }

    /**
     * Gets the tooltip for transition. The tooltip consists of property names and values.
     *
     * @return The tooltip to be displayed when user holds the mouse above transition's graph object.
     */
    public String getTooltip() {
        XMLElement f = new XMLElement("From");
        f.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.From.display"));
        f.setValue(from.toString());
        XMLElement t = new XMLElement("To");
        t.setLabelName(ResourceManager.getLanguageDependentString("Transition.General.To.display"));
        t.setValue(to.toString());
        return XMLUtil.makeTooltip(new XMLElement[]{attrName, f, t, attrRouteOrder, attrDirection, refDescription, refCondition});
    }

    /**
     * Must be called after importing from XML file to read the break-points from the extended attributes.
     */
    public void afterImporting() {
        // set from and to activities
        Activities acts = (Activities) getCollection().getOwner().get("Activities");
        String actFromId = attrFrom.toValue().toString();
        String actToId = attrTo.toValue().toString();
        this.from = acts.getActivity(actFromId);
        this.to = acts.getActivity(actToId);

        // 监听器
        listeners.afterImporting();

        ordNoToPoint = new Hashtable();
        routingType = null;
        Set easToRemove = new HashSet();
        if (refExtendedAttributes.size() > 0) {
            ExtendedAttribute ea;
            Iterator it = refExtendedAttributes.toCollection().iterator();
            Point p;
            String[] pPos;
            int i = 1;
            String nm = "";
            String val = "";
            while (it.hasNext()) {
                ea = (ExtendedAttribute) it.next();
                nm = ea.get("Name").toValue().toString();
                val = ea.get("Value").toValue().toString();
                if (nm.startsWith("BreakPoint") || nm.startsWith("BREAKPOINT")) {
                    pPos = XMLUtil.tokenize(val, ";");
                    if (pPos == null || pPos.length != 3) {
                        continue;
                    }
                    try {

                        // fid by wenzhang当pPos[1]为非整数时系统会出新类型转换错误
                        int x = 0;
                        int y = 0;
                        if (pPos[0].indexOf(".") > 0) {
                            x = Integer.parseInt(pPos[0].substring(0, pPos[0].indexOf(".")));
                        } else {
                            x = Integer.parseInt(pPos[0]);
                        }
                        if (pPos[1].indexOf(".") > 0) {
                            y = Integer.parseInt(pPos[1].substring(0, pPos[1].indexOf(".")));
                        } else {
                            y = Integer.parseInt(pPos[1]);
                        }
                        p = new Point(x, y);

                        int index;
                        try {
                            index = Integer.parseInt(pPos[2].substring(0, pPos[2].indexOf(".")));
                        } catch (Exception exInner) {
                            index = i;
                        }
                        ordNoToPoint.put(new Integer(index), p);
                        easToRemove.add(ea);
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    i++;
                }
                if (nm.equals(ROUTING_TYPE) && routingType == null) {
                    routingType = val;
                    easToRemove.add(ea);
                }
                // 把扩展属性中的顺序编号和路由方向
                if (nm.equalsIgnoreCase("RouteOrder")) {
                    attrRouteOrder.setValue(val);
                    attrRouteOrder.refreshDisplayValue();
                    continue;
                }
                if (nm.equalsIgnoreCase("RouteDirection")) {
                    attrDirection.setValue(val);
                    attrDirection.refreshDisplayValue();
                    continue;
                }
            }
            loadPlugins();
            fillPlugins();
            try {
                for (Iterator iter = plugins.entrySet().iterator(); iter.hasNext(); ) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    ((PluginElement) entry.getValue()).afterImporting();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        // removing internally used ext. attribs - otherwise, it would
        // be shown within ea list
        refExtendedAttributes.toCollection().removeAll(easToRemove);

    }

    /**
     * Overrides super-class method to realize this class specific writting to XML file.
     */
    public void toXML(Node parent) throws DOMException {
        // update attrFrom and attrTo values
        try {
            if (attrFrom != null && this.from != null && this.from.get("Id") != null) {
                attrFrom.setValue(this.from.get("Id").toValue());
            }

            if (attrTo != null && to != null) {
                attrTo.setValue(this.to.get("Id").toValue());
            }
        } catch (Exception ex) {
            ex.printStackTrace();

        }
        // remove all internally used ext. attribs
        Set easToRemove = new HashSet();

        ExtendedAttribute ea;
        if (routingType == null || routingType.equals(NO_ROUTING)) {
            int noOfPoints = ordNoToPoint.size();
            Point2D p;
            String pPos;

            for (int i = 1; i <= noOfPoints; i++) {
                // fix by wenzhang 将Point对象转换为Point2D
                p = (Point2D) ordNoToPoint.get(new Integer(i));
                pPos = String.valueOf(p.getX()) + ";" + String.valueOf(p.getY()) + ";" + String.valueOf(i);
                ea = new ExtendedAttribute(refExtendedAttributes);
                ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
                ea.set("Name", "BreakPoint" + String.valueOf(i));
                ea.set("Value", pPos);
                easToRemove.add(ea);
            }
        }

        if (routingType != null) {
            ea = new ExtendedAttribute(refExtendedAttributes);
            ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
            ea.set("Name", ROUTING_TYPE);
            ea.set("Value", routingType);
            easToRemove.add(ea);
        }
        // 保存顺序编号和路由方向
        ea = refExtendedAttributes.getExtendedAttribute(attrRouteOrder.toName());
        ea.set("Value", attrRouteOrder.toValue());
        ea = refExtendedAttributes.getExtendedAttribute(attrDirection.toName());
        ea.set("Value", attrDirection.toValue());

        super.toXML(parent);

        // removing internally used ext. attribs - otherwise, it would be
        // duplicated
        refExtendedAttributes.toCollection().removeAll(easToRemove);

    }

    /**
     * Used to create exact copy of instance of this class. The newly created instance will have all the properties same
     * as the copied one.
     *
     * @return The newly created instance of this class.
     */
    public Object clone() {
        Transition t = (Transition) super.clone();

        t.attrId.setValue(myCollection.generateID());
        t.attrName = (XMLAttribute) this.attrName.clone();
        t.attrFrom = (XMLAttribute) this.attrFrom.clone();
        t.imgClass = (XMLAttribute) this.imgClass.clone();
        t.attrTo = (XMLAttribute) this.attrTo.clone();
        t.attrRouteOrder = (XMLAttribute) this.attrRouteOrder.clone();
        t.attrDirection = (XMLAttribute) this.attrDirection.clone();
        t.refCondition = (Condition) this.refCondition.clone();
        t.refDescription = (Description) this.refDescription.clone();
        t.refExtendedAttributes = (ExtendedAttributes) this.refExtendedAttributes.clone();
        // 监听器
        t.listeners = (Listeners) this.listeners.clone();
        // 删除clone的扩展属性
        t.refExtendedAttributes.clear();
        Map actMap = BPD.getInstance().getActMap();
        String fromId = from.get("Id").toValue().toString();
        t.setFrom((Activity) actMap.get(fromId));
        String toId = to.get("Id").toValue().toString();
        t.setTo((Activity) actMap.get(toId));
        t.myWorkflow = this.myWorkflow;
        t.clonedEAs = null;
        t.fillStructure();
        // clone插件
        t = clonePlugins(t);
        return t;
    }

    /**
     * Checks if an ID entered by the user is unique.
     */
    public boolean isIDUniqueAndValid(XMLPanel groupPanel) {
        XMLTextPanel tp = (XMLTextPanel) ((XMLGroupPanel) ((XMLTabbedPanel) groupPanel).getTabbedPanel(0)).getPanel(0);
        String IDToCheck = tp.getText();
        // if there is an element with given ID, return false
        XMLComplexElement trans = getCollection().getCollectionElement(IDToCheck);
        boolean isOK = true;
        String message = null;
        String dialogTitle = null;
        if (trans != null && trans != this) {
            message = ResourceManager.getLanguageDependentString("ErrorIDMustBeUnique");
            dialogTitle = ResourceManager.getLanguageDependentString("DialogIDIsNotUnique");
            isOK = false;
        } else if (!XMLCollection.isIdValid(IDToCheck)) {
            message = ResourceManager.getLanguageDependentString("ErrorIDMustBeValid");
            dialogTitle = ResourceManager.getLanguageDependentString("DialogIDIsNotValid");
            isOK = false;
        }
        if (!isOK) {
            XMLPanel.errorMessage(groupPanel.getDialog(), dialogTitle, "", message);
            ((JTextField) tp.getComponent(2)).requestFocus();
        }
        return isOK;
    }

    /**
     * This method is called only if user doesn't press Cancel button within the dialog for editing Transition
     * properties, so the changes to the real collection of Transition are applied here.
     *
     * @return always returns <tt>true</tt>.
     */
    public boolean isValidEnter(XMLPanel panel) {
        XMLGroupPanel groupPanel = (XMLGroupPanel) ((XMLTabbedPanel) panel).getTabbedPanel(0);
        XMLTextPanel textPanel = (XMLTextPanel) groupPanel.getPanel(4);
        String routeOrderValue = textPanel.getText();

        if (!Utils.isInt(routeOrderValue)) {
            XMLPanel.errorMessage(groupPanel.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"), textPanel.getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
                    ResourceManager.getLanguageDependentString("Sys.ErrorMessage.invalid"));
            textPanel.requestFocus();
            return false;
        }
        return true;
    }

    // 把XPDL文件信息保存到Transition对象
    public void fromXML(Node node) {
        super.fromXML(node);
        // 把相同的BreakPoint元素保存到ExtendedAttribute对象中
        Node exAttrs = XMLUtility.getFirstChild(node, "ExtendedAttributes");
        refExtendedAttributes.remove(refExtendedAttributes.getExtendedAttribute("BreakPoint"));
        List exAttrsList = XMLUtility.getChildNodes(exAttrs, Node.ELEMENT_NODE);
        for (int i = 0; i < exAttrsList.size(); i++) {
            Element exAttr = (Element) exAttrsList.get(i);
            if (exAttr.getAttribute("Name").equals("BreakPoint")) {
                ExtendedAttribute ea = new ExtendedAttribute(refExtendedAttributes);
                ea.fromXML(exAttr);
                refExtendedAttributes.add(ea);
            }
        }
    }

    public void setAttributeValue(String name, String value, boolean isReadOnly) {
        if (name == null || name.equals("")) {
            return;
        }
        if (name.equals("Name")) {
            attrName.setValue(value);
            attrName.refreshDisplayValue();
            attrName.setReadOnly(isReadOnly);
        }
        if (name.equals("RouteOrder")) {
            attrRouteOrder.setValue(value);
            attrRouteOrder.refreshDisplayValue();
            // attrRouteOrder.setReadOnly(isReadOnly);
        }
        if (name.equals("RouteDirection")) {
            attrDirection.setValue(value);
            attrDirection.refreshDisplayValue();
            attrDirection.setReadOnly(isReadOnly);
        }
        if (name.equals("Condition")) {
            refCondition.setValue(value);
            refCondition.setReadOnly(isReadOnly);
        }
        if (name.equals("Description")) {
            refDescription.setValue(value);
            refDescription.setReadOnly(isReadOnly);
        }
    }

    public String getAttributeValue(String name) {
        String ret = "";
        if (name == null || name.equals("")) {
            return ret;
        }
        if (name.equals("Name")) {
            ret = attrName.toValue().toString();
        }
        if (name.equals("RouteOrder")) {
            ret = attrRouteOrder.toValue().toString();
        }
        if (name.equals("RouteDirection")) {
            ret = attrDirection.toValue().toString();
        }
        if (name.equals("Condition")) {
            ret = refCondition.toValue().toString();
        }
        if (name.equals("Description")) {
            ret = refDescription.toValue().toString();
        }
        return ret;
    }

    private void loadPlugins() {
        // 读取路由插件
        try {
            if (plugins != null && manager.getAppName() == myWorkflow.getAppName()) {
                return;
            }
            manager = PluginManager.getInstance(myWorkflow.getAppName(), myWorkflow.getClassifications());
            plugins = manager.getPlugins(PluginType.Route, null);
            for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                PluginElement pe = (PluginElement) entry.getValue();
                pe.setType(PluginType.Route);
                pe.setProperty("Route", this);
                pe.setProperty("WorkflowProcess", getOwnerProcess());
                BPDProjectConfig classification = AppConfigManager.getInstance().getApplicationMap().get(myWorkflow.getAppName()).getBPDProjectConfigMap().get(myWorkflow.getClassifications());
                pe.setProperty(PluginType.Classification.getType(), classification);
                pe.setBpdElement(manager.getBPDElement((String) entry.getKey()));
                Map params = manager.getPluginParams((String) entry.getKey());
                for (Iterator paramIt = params.entrySet().iterator(); paramIt.hasNext(); ) {
                    Map.Entry param = (Map.Entry) paramIt.next();
                    pe.setProperty((String) param.getKey(), ((CParameter) param.getValue()).getParameterValue());
                }
                pe.loadProperties();
                // plugins.put((String) entry.getKey(), pe);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fillPlugins() {
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            String name = (String) entry.getKey();
            Object val = entry.getValue();
            if (oldPlugins.containsKey(name)) {
                Object oldVal = oldPlugins.get(name);
                int index = complexStructure.indexOf(oldVal);
                // complexStructure.set(index, val);
                plugins.put(name, oldVal);
            } else {
                complexStructure.add(val);
            }
            oldPlugins.put(name, val);
        }
    }

    public WorkflowProcess getOwnerProcess() {
        return myWorkflow;
    }

    // 插件的clone方法
    public Transition clonePlugins(Transition t) {
        t.plugins = new HashMap();
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            String name = (String) entry.getKey();
            Object val = entry.getValue();
            Object cloneVal = ((PluginElement) val).clone();
            t.complexStructure.add(cloneVal);
            t.plugins.put(name, cloneVal);
        }
        return t;
    }

    public void setWorkflowProcess(WorkflowProcess wp) {
        this.myWorkflow = wp;
    }

    public Package getPackage() {
        return this.getOwnerProcess().getPackage();
    }

}
