/* SimulationInformation.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;

import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class SimulationInformation extends XMLComplexElement {
	private Cost refCost = new Cost();

	private TimeEstimation refTimeEstimation = new TimeEstimation();

	private XMLAttribute attrInstantiation = new XMLAttribute("Instantiation",
			new String[] { "", "ONCE", "MULTIPLE" }, 0);

	/**
	 * Creates a new instance of the class.
	 */
	public SimulationInformation() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		complexStructure.add(attrInstantiation);
		attributes.add(attrInstantiation);
		refCost.setRequired(true);
		complexStructure.add(refCost);
		refTimeEstimation.setRequired(true);
		complexStructure.add(refTimeEstimation);
	}

	public void fromXML(Node node) {
		attrInstantiation.setValue("");
		super.fromXML(node);
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		SimulationInformation s = (SimulationInformation) super.clone();

		s.attrInstantiation = (XMLAttribute) this.attrInstantiation.clone();
		s.refCost = (Cost) this.refCost.clone();
		s.refTimeEstimation = (TimeEstimation) this.refTimeEstimation.clone();

		s.fillStructure();

		return s;
	}

}
