/* SchemaType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Set;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import com.ds.bpm.bpd.xml.ParsingErrors;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLLocationPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Represents a WfMC DTD element that has the similar name. NOTE: This element
 * is not implemented.
 */
public class SchemaType extends XMLComplexElement {
	// min=0, max=unbounded
	// private Set refAny=new HashSet();

	// helper attributes
	private XMLAttribute attrHref;

	private Content refContent = new Content();

	private Node schemaNode;

	public SchemaType() {
		super();

		attrHref = new XMLAttribute("href", 1);

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		attrHref.setRequired(true);
		complexStructure.add(attrHref);
		refContent.setReadOnly(true);
		complexStructure.add(refContent);
	}

	public void toXML(Node parent) throws DOMException {
		// When saving to file, do not save the attribute that contains
		// the location of schema, and it's description directly,
		// but the schema content

		// removes attrHref
		complexStructure.remove(0);
		// removes refDescription
		complexStructure.remove(0);

		// save to xml
		if (parent != null) {
			Node node = (parent.getOwnerDocument()).createElement(name);
			// node.appendChild(parent.getOwnerDocument().createTextNode(refContent.toString().trim()));
			String fileLoc = attrHref.toString().trim();
			Node schema = null;
			if (fileLoc.length() > 0) {
				schema = parseDocument(attrHref.toString().trim());
			} else if (refContent.toValue() != null
					&& refContent.toValue().toString().length() > 0) {
				schema = schemaNode;
			}
			if (schema != null) {
				node.appendChild(parent.getOwnerDocument().importNode(schema,
						true));
			}
			parent.appendChild(node);
		}

		complexStructure.add(0, attrHref);
		complexStructure.add(1, refContent);
	}

	public void fromXML(Node node) {
		if (node != null) {
			Object newVal = null;
			if (node.hasChildNodes()) {
				// newVal=node.getChildNodes().item(0).getNodeValue();
				NodeList nl = node.getChildNodes();
				for (int i = 0; i < nl.getLength(); i++) {
					Node sn = nl.item(i);
					// System.out.println("Class =
					// "+nl.item(i).getClass().getName());
					if (sn instanceof Element) {
						newVal = XMLUtil.getContent(sn, true);
						schemaNode = sn;
						break;
					}
				}
				// should never happen
			} else {
				newVal = node.getNodeValue();
			}
			if (newVal != null) {
				value = newVal;
			}
		}
		refContent.setValue(value);
	}

	public XMLPanel getPanel() {
		XMLGroupPanel currentPanel = (XMLGroupPanel) super.getPanel();
		XMLPanel cp = currentPanel.getPanel(1);
		JScrollPane jsp = (JScrollPane) cp.getComponent(2);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		final JTextArea currentContent = (JTextArea) jvp.getComponent(0);

		XMLLocationPanel lp = (XMLLocationPanel) currentPanel.getPanel(0);
		final JTextField jtf = (JTextField) lp.getComponent(2);
		jtf.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent ae) {
				String fstr = XMLUtil.fileToString(jtf.getText());
				if (fstr == null) {
					fstr = "";
				}
				currentContent.setText(fstr);
			}

			public void insertUpdate(DocumentEvent ae) {
				String fstr = XMLUtil.fileToString(jtf.getText());
				if (fstr == null) {
					fstr = "";
				}
				currentContent.setText(fstr);
			}

			public void removeUpdate(DocumentEvent ae) {
				String fstr = XMLUtil.fileToString(jtf.getText());
				if (fstr == null) {
					fstr = "";
				}
				currentContent.setText(fstr);
			}
		});

		return currentPanel;
	}

	private Node parseDocument(String refToFile) {
		Document document = null;

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(false);

		// Parse the Document and traverse the DOM
		try {
			ParsingErrors pErrors = new ParsingErrors();

			DocumentBuilder parser = factory.newDocumentBuilder();
			parser.setErrorHandler(pErrors);
			document = parser.parse(refToFile);
			Set errorMessages = pErrors.getErrorMessages();
			if (errorMessages.size() > 0) {
				System.err.println("Errors in schema type");
			}
		} catch (Exception ex) {
			System.err.println("Fatal error while parsing xml schema document");
			return null;
		}
		if (document != null) {
			return document.getDocumentElement();
		} else {
			return null;
		}

	}

}
