/* Responsible.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素流程监控人数据类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 * ModifiedTime: 2004-2-10
 */

package com.ds.bpm.bpd.xml.elements;

import javax.swing.ListSelectionModel;

import com.ds.bpm.bpd.xml.panels.formula.org.XMLRightOrgPanel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name. 流程监控人数据类
 * 
 * @see XML
 */
public class Responsible extends XMLComplexElement {
	/**
	 * Defined participants at Package or WorkflowProcess level, depending for
	 * which of them this instance of Responsible belongs. If it is a
	 * WorkflowProcess, the Package participants are also included.
	 */
	private transient Participants definedParticipants = null;

	private XMLCollection parent;

	// Name Attribute
	private XMLAttribute attrName = new XMLAttribute("Name");

	// Value Attribute
	private XMLAttribute attrValue = new XMLAttribute("Value");

	/**
	 * Creates a new instance of the class. 创建一个流程监控人
	 * 
	 * @param packageOrWProcess
	 *            The class instance which member is this class instance. Can be
	 *            Package or WorkflowProcess
	 */
	public Responsible(XMLComplexElement packageOrWProcess) {
		super();
		setLabelName(ResourceManager
				.getLanguageDependentString("Process.Right.Responsible.display"));
		try {
			this.definedParticipants = (Participants) packageOrWProcess
					.get("Participants");
		} catch (NullPointerException npe) {
			npe.printStackTrace();
		}
		fillStructure();
	}

	public Responsible(XMLComplexElement packageOrWProcess, XMLCollection parent) {
		this(packageOrWProcess);
		this.parent = parent;
	}

	protected void fillStructure() {
		attributes.add(attrName);
		complexStructure.add(attrName);
		attributes.add(attrValue);
		complexStructure.add(attrValue);
	}

	/**
	 * Prepares a XMLOrgPanel to choose the one of allowed responsible.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		if (BPD.getInstance().getUserInfo() == null) {
			return null;
		}
		return new XMLRightOrgPanel(this, parent, this.toLabel(), true, true,
				ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	}

	/**
	 * Overrides super-class method to realize this class specific writting to
	 * XML file.
	 */
	public void toXML(Node parent) throws DOMException {
		if (!(value instanceof XMLSelectOption))
			return;
		if (!isEmpty() || isRequired()) {
			if (parent != null) {
				attrName.setValue(((XMLSelectOption) value).getName());
				attrValue.setValue(((XMLSelectOption) value).getText());
				super.toXML(parent);
			}
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Responsible r = (Responsible) super.clone();
		r.attrName = (XMLAttribute) this.attrName.clone();
		r.attrValue = (XMLAttribute) this.attrValue.clone();
		// set the same participant
		r.setValue(this.toValue());
		r.definedParticipants = this.definedParticipants;
		r.parent = this.parent;
		r.fillStructure();
		return r;
	}

	public String toString() {
		if (toValue() instanceof XMLSelectOption) {
			return ((XMLSelectOption) toValue()).getName();
		} else {
			return "";
		}
	}

	// 解析XPDL文件保存到流程监控人对象
	public void fromXML(Node node) {
		Element elem = (Element) node;
		XMLSelectOption value = new XMLSelectOption(elem.getAttribute("Name"),
				elem.getAttribute("Value"));
		setValue(value);
		super.fromXML(node);
	}
}
